
	call hdinfo_wait4ready
	pushad
	mov ax, sys_hdinfo_dsel
	mov es, ax

	mov dx, 0a1h	;irq masking register: mask irq so no interrupt generated
	in al, dx
	or al, 040h	;01000000xb = mask irq14
	out dx, al

        mov dx, 01f7h
        mov al, 0ech
        out dx, al

hdinfo_pause:
        mov cx, 0ffffh
hdinfo_pauseloop:  loop hdinfo_pauseloop
        in al, dx
;        test al, 80h    ;See if busy
;        jnz hdinfo_pause
;	test al, 029h
;	jz hdinfo_pause
;	test al, 08h    ;if 0 then data not ready(=10001000xb = busy&data req
;	jnz hdinfo_getinfo
;	test al, 1
;	jz hdinfo_pause		;If no error, continue cycle of waiting
;	jmp hdinfo_err2		;Hard drive not ready to transfer data

;	cli
hdinfo_getinfo:
;	jmp hdinfo_getinfo
        mov dx, 01f0h
        mov cx, (01a0h / 2)
        xor edi, edi
        rep insw

	call hdinfo_unmaskirq

        mov dx, 01f7h
        in al, dx
        test al, 1
        jnz hdinfo_err3

        popad
        clc
        retf
	;***************** Called Procedures *****************
hdinfo_wait4ready:
	pushad
	mov dx, 01f7h
        mov ecx, 0100h
hdinfo_waitloop:
	in al, dx
        and al, 040h    ;01000000xb = drive ready
        cmp al, 040h
        jz hdinfo_ready
	push ecx
	mov ecx, 0ffffh
hdinfo_waitpause:   loop hdinfo_waitpause
	pop ecx
	loop hdinfo_waitloop

hdinfo_err1:            ;HARD DRIVE TOO BUSY ERROR
	jmp hdinfo_err1
        popad           ;remove the data pushed from the beginning of hdinfo_wait4ready subroutine
        pop eax         ;pop called eip

	stc		;store carry flag as a return error
	mov ax, 1	;ERROR: hard drive too busy
        retf         ;First pushad doesn't have to be popped because hdinfo_wait4ready was called before the push...
hdinfo_ready:
	popad
        ret
	;************** Unmask the irq for the hard drive ****************
hdinfo_unmaskirq:
	mov dx, 0a1h	;irq masking register: mask irq so no interrupt generated
	in al, dx
	and al, 0bfh	;10111111xb = unmask irq14
	out dx, al
	ret
	;******* More error handlers: **********
hdinfo_err2:		;Hard drive not ready to transfer data
	jmp hdinfo_err2
	call hdinfo_unmaskirq
        popad           ;pop this from the beginning of hdinfo
	stc
	mov ax, 2
        retf
hdinfo_err3:		;More detailed error occurred with ata
	jmp hdinfo_err3
	popad
	stc
	mov ax, 3
        retf
