mov ax, shared_data_sel
	mov fs, ax
	mov ds, ax

	mov dx, 03f4h
fp_try_again:
	in al, dx
	and al, 0c0h	;=11000000xb=ready for data transfer,I/O direction FPC to CPU
	cmp al, 080h	;when it is ready for data, but direction is not from FPC to CPU (instead CPU to FPC) do it
	jz fp_ready
	mov ecx, 07d00000h
fp_givefpsometime:	loop fp_givefpsometime
	jmp fp_try_again

fp_ready:
	mov dx, 03f2h
	mov al, 01ch	;00011100xb=motor D,C,B off, A on, DMA&I/O, Floppy controller enable, select floppy drive 00 = A
	out dx, al	;turn on floppy A motor
	
	mov ecx, 0fffffffh
fp_time_to_warm_up:	loop fp_time_to_warm_up

	or byte [fs:fp_command], 020h	;set fp_command byte to indicate a seek operation is taking place.

	mov esi, fp_message1	;!!!!!!!!! message1 !!!!!!!!!!!!!!!!!!!!!!!11
	mov al, white
	call sys_print_csel:0

	mov al, 0fh	;seek command
	mov dx, 03f5h
	out dx, al
	pop eax
	mov al, ah	;send head#, floppy drive #
	out dx, al
	pop ecx
	mov al, ch
	out dx, al	;seek should be complete after this

fp_wait_for_seek_ack:
	test byte [fs:fp_command], 20h
	jnz fp_wait_for_seek_ack

	mov esi, fp_message2	;!!!!!!!!! message2 !!!!!!!!!!!!!!!!!!!!!!!11
	mov al, white
	call sys_print_csel:0

	;set DMA up at this point...

	or byte [fs:fp_command], 080h	;set fp_command byte to indicate that a read operation is taking place
	pop eax
	out dx, al	;dx still = 03f5h, so send first byte of command
	mov al, ah
	out dx, al	;send head and floppy drive #
	pop ecx		;get cylinder #
	push eax
	mov al, ch	;get cylinder # into al
	out dx, al
	pop eax		;pop ah b/c head# is needed again
	shr ax, 10	;shift bit2 of ah into bottom of al so that head # alone can be sent
	out dx, al
	mov al, bl
	out dx, al	;send sector #
	;????????????????????????????????
	mov al, 0ffh	;bytes per sector but can't fit 512 so ...
	out dx, al
	;????????????????????????????????
	mov al, 18	;last sector in a track...
	out dx, al
	mov al, 0	;gap 3 length - whatever that means???????????
	out dx, al
	;!!!!!!!At this point it says to send "data length (if cmd byte == 0)", so I hope this means if it wasn't 0
	;then I don't have to send this byte

	mov esi, fp_message3	;!!!!!!!!! message3 !!!!!!!!!!!!!!!!!!!!!!!11
	mov al, white
	call sys_print_csel:0

fp_wait_for_read_ack:
	test byte [fs:fp_command], 080h
	jnz fp_wait_for_read_ack

	mov ecx, 6	;6 status registers: for now we'll just read them, error handling will be done later...
fp_outer_give_time2:
	push ecx
	in al, dx	;get first status register
	mov ecx, 00010000h
fp_givefpsometime2:	loop fp_givefpsometime2
	pop ecx
	loop fp_outer_give_time2

	mov al, 0ch	;00001100xb=set motors for floppy drives D->A not on,DMA&I/O enable,FloppyController enable, select
			;floppy drive 00
	mov dx, 03f2h	;purpose of this command is to shut off floppy motor
	out dx, al