;**************** READ HARD DRIVE SYSTEM CALL *****************
hdread:				;Reads/writes sectors from/to hard disk: cl=#sectors, ax=cylinder #, bl=sector #
				;ch = set bit7=write, bit4 = drive: 0=master, 1=slave <-????, low 4 bits head #
				;bh: bit7: 0=HardDiskController0, 1=HDC1
				;    bit4: 0=master, 1=slave
				;es:edi -> buffer, OR IF writing set: ds:esi as source...
	call hdread_wait4ready
	pushad
	pushfd		;Save the interrupt enable flag and the direction flag
	push fs
	push cx
	push cx		;These are parameters that need to be saved
	push ax
	push bx

	cld			;Clear the direction pointer so the rep commands aren't messed up

	mov ax, shared_data_sel
	mov fs, ax

	mov dx, 0a1h	;irq masking register: mask irq so no interrupt generated
	in al, dx
	test bh, 128
	jz hdread_dohdc0
;		test bh, 010h
;		jz hdread_hdc1_master
;			mov bl, byte [fs:hd3_numheads]
;			jmp hdread_dohdc1or
;hdread_hdc1_master:
;	mov bl, byte [fs:hd2_numheads]
;hdread_dohdc1or:
		or al, 080h
		mov word [fs:temp_data5], 0170h	;Base port for hdc1
		jmp hdread_outmask
hdread_dohdc0:
;	test bh, 010h
;	jz hdread_hdc0_master
;		mov bl, byte [fs:hd1_numheads]
;		jmp hdread_dohdc0or
;hdread_hdc0_master:
;	mov bl, byte [fs:hd0_numheads]
;hdread_dohdc0or:
	or al, 040h	;01000000xb = mask irq14
	mov word [fs:temp_data5], 01f0h		;Base port for hdc0

hdread_outmask:	out dx, al

;	;??????????? Is this chunk necessary??????? - and for that matter, the tests for # heads above ??????????????
;	mov al, bl
;	cmp al, 8
;	jae hdread_changeto8heads
;	xor al, al
;	jmp hdread_outputphysicalheads
;hdread_changeto8heads:	mov al, 8
;hdread_outputphysicalheads:	mov dx, 0376h
;	out dx, al
	;???????????????????????????????????????????

	;If there was a precompensation cylinder, it would go to port baseport + 1 (1f1h for hdc0)
	;but for now keep it simple. (precomp cylinder would be divided by 4)

	mov dx, word [fs:temp_data5]		;Set #sectors
	add dx, 2
	mov al, cl		;cl was passed as a parameter and cx hasn't been altered yet.
	out dx, al
	
	inc dl
	pop bx
	mov al, bl		;sector #
	out dx, al

	inc dl
	pop ax
	out dx, al		;cylinder low

	inc dl
	mov al, ah
	out dx, al		;cylinder high

	mov al, ch
	and al, 0bfh	;10111111xb = clear bit 6 = choose CHS
	or al, 0a0h	;=10100000xb = set bits 7 & 5 = mandatory to be set, no significance...
	inc dl		;bitmap = 1, CHS (LBA = 1), 1, Drive #, Head #
	out dx, al

	inc dl
	pop cx
	mov bh, ch		;DON'T USE BX UNTIL AFTER DATA IS READ/WRITTEN...!!!!!!!!!!!!!!!!!!!
	test ch, 080h
	jnz hdread_writecommand
	mov al, 020h
	or byte [fs:hd0_command], 080h	;set bit7 to indicate a read command is taking place
	jmp hdread_outputcommand
hdread_writecommand:    mov al, 030h    ;write sectors w/ retry command
	or byte [fs:hd0_command], 040h
hdread_outputcommand:   out dx, al
       
hdread_doread:
	call hdread_unmaskirq
	pop cx			;Get # sectors to set # loops
	and ecx, 000000ffh	;only count cl, not ecx b/c only up to 256 at a time
hdread_readingloop:
	push ecx		;Save the loop number

	mov dx, word [fs:temp_data5]
	add dx, 7
	test bh, 080h
	jz hdread_readpause	;If bit 7 isn't set it is a read command so do a pause for read
hdread_writepause:
	mov ecx, 10
	call sys_delay_csel:0
	test al, 1
	jz hdread_dataready	;If no error and delay time is up, continue with write
	jmp hdread_err2		;Hard drive returned an error
hdread_readpause:
	in al, dx
	test al, 08h    ;if 0 then data not ready(=10001000xb = busy&data req)
	jnz hdread_dataready
	test al, 1
	jz hdread_readpause	;If no error yet, continue cycle
	jmp hdread_err2		;Hard drive returned an error

hdread_dataready:
	mov dx, word [fs:temp_data5]	;Data Port
	mov ecx, 256		;256 = # words in a sector

	test bh, 080h		;= 10000000xb : if bit7 set then write, this was originaly in ch, but moved to save it.
	jz hdread_read		;If not set, read
	rep outsw		;Else write
	jmp hdread_wroteasector
hdread_read: rep insw		;Read a sector to es:edi
hdread_wroteasector:

	pop ecx			;Get loop number back
	loop hdread_readingloop

	mov byte [fs:hd0_command], 0	;Now that loop is over, make sure hd is registered as not busy.

	add dx, 7
	in al, dx
	and al, 1		;Check for an error
	jnz hdread_err3		;Some other error occurred

hdread_done:
	pop fs
	popfd
	popad
	clc
	retf
	;*********************** Called procedures ************************

hdread_wait4ready:
	pushad
	mov dx, word [fs:temp_data5]
	add dx, 7
	mov ecx, 40		;Try no more than 40x. (40 x (1/4ms) = 10ms maximum wait)
hdread_waitloop:
	in al, dx
	test al, 040h	;If bit6 is set, drive is ready
	jz hdread_notyet
	test al, 080h
	jz hdread_ready	;If bit6 was set (drive ready) and controller isn't executing a command, it's ready
hdread_notyet:	
	push ecx
	mov ecx, 250
	call sys_delay_csel:0	;delay for 1/4ms
	pop ecx
	loop hdread_waitloop

hdread_err1:		;HARD DRIVE TOO BUSY ERROR: pushad hasn't occurred, it is just popping it from hdread_wait4read
	popad		;remove the data pushed from the beginning of hdread_wait4ready subroutine
	pop eax		;pop called eip for call hdread_wait4ready

	stc		;store carry flag as a return error
	mov ax, 1	;ERROR: hard drive too busy
	retf         ;First pushad & pushfd don't have to be popped because hdread_wait4ready was called before the push...

hdread_ready:
	popad
      ret

	;********* more error handlers **********
hdread_err2:		;Hard drive not ready to transfer data
	call hdread_unmaskirq
	pop ecx		;ecx still hasn't been popped from the transfer loop
	pop fs
	popfd
	popad		;pop this from the beginning of hdread
	stc
	mov ax, 2
        retf
hdread_err3:		;More detailed error occurred with ata
	call hdread_unmaskirq
	pop ecx
	pop fs
	popfd
	popad
	stc
	mov ax, 3
        retf
	;*********** Unmask IRQ **************
hdread_unmaskirq:
	push eax
	in al, 0a1h
	cmp word [fs:temp_data5], 01f0h
	jz hdread_unmaskhdc0
		and al, 07fh
		jmp hdread_dounmask
hdread_unmaskhdc0:
	and al, 0bfh	;and with 10111111xb to clear bit 6
hdread_dounmask:	out 0a1h, al
	pop eax
	ret
end_hdread:
;******************** END OF HARD DISK READING SYSTEM CALL ********************