;************************ Clock the CPU Processor Speed *********************
	;Clocks CPU and returns value in eax as hertz (not Megahertz)
[bits 16]
clockcpu:
	push fs
	push eax
	push ecx
	push ebx

	mov ax, shared_data_sel
	mov fs, ax

	hlt	;halt to wait for an int8 so that this doesn't get interrupted.
	or word [fs:sys_int_mask], 0100h	;0000000100000000xb = set bit8 so that system multitasking knows

	mov ecx, 4	;This sets it up to measure it 4 times to make sure we get an accurate, non-interrupted value
	mov ebx, 0	;this will be used to keep track of the fastest clock speed measured throughout the 4 times
clockcpu_test_again:
	push ecx
	mov ecx, 0
	hlt		;wait for int8 again so that we catch it right at the beginning of an int8
	nop		;when it returns, it will be 6 bytes ahead, so make sure it ends on an instruction...
	nop
	nop
	nop
	nop
	nop
	nop
	nop

cpuclock_countloop:
;	stc
	inc ecx		;increment ecx like mad until int8 jumps it out of the loop
;	clc	
;	db 067h, 233, 251, 255	;067h makes the jmp (233) a 16-bit address jmp back 4 bytes (to inc ecx)
	db 067h
	jmp cpuclock_countloop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	clc

	cmp ecx, ebx	;Int8 has gotten it out, now compare this time's clock count with the highest
	jbe cpuclock_notfaster	;and replace it if we got a higher value.
	mov ebx, ecx
cpuclock_notfaster:
	pop ecx
	loop clockcpu_test_again

	mov dword [fs:cpu_speed], ebx	;save # cycles into mem so we can put it in fpu
	fild dword [fs:cpu_speed]	;load this into the register on top of fpu stack
	mov dword [fs:cpu_speed], 0424228f5h
;        mov dword [fs:cpu_speed], 042119999h    ;36.4 coded in binary dword IEEE real format
;        mov dword [fs:cpu_speed],  041919999h
;	mov dword [fs:cpu_speed], 042919999h
;	mov dword [fs:cpu_speed], 042423333h
;	mov dword [fs:cpu_speed], 042fecccch
;	mov dword [fs:cpu_speed], 042da6666h
	fmul dword [fs:cpu_speed]	;multiply # cycles counted by constant to get the
					;cpu speed in hertz
	fistp dword [fs:cpu_speed]	;save final in regular integer format and pop value from fpu stack

	hlt				;wait for int8 again to catch it right at the beginning of the 1/18.2 of a sec.
	nop		;when it returns, it will be 6 bytes ahead, so make sure it ends on an instruction...
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	mov ecx, 0ffffffffh
cpuclock_clockloop:	loop cpuclock_clockloop
	nop
	nop
	nop
	nop
	nop
	nop			;By here, ecx = 0ffffffffh - # loops.
	nop
	nop

	and word [fs:sys_int_mask], 0feffh	;1111111011111111xb = clear bit 8 to release int8

	mov eax, 0ffffffffh
	sub eax, ecx		;now eax = number of loops were completed in 18.2 sec

	fild dword [fs:cpu_speed]	;load cpu speed
	mov dword [fs:loop_cycles], 041919999h	;binary real encoding for 18.2
	fdiv dword [fs:loop_cycles]	;divide hertz by 18.2 to get cycles per (1/18.2 sec)
	mov dword [fs:loop_cycles], eax	;get ready to divide the processors ^above^ by # times loop opcode executed
	fidiv dword [fs:loop_cycles]	;This should give # cycles for the loop instruction
	fstp dword [fs:loop_cycles]	;Save this number and pop the value from the fpu stack. NOTE: This is not an integer.
					;It will be more accurate to leave it as a 32-bit real.
	mov eax, dword [fs:cpu_speed]	;must return hertz in eax also

	pop ebx		;Pop register values that were altered, but leave the # hertz in eax...
	pop ecx
	pop eax
	pop fs
	retf	
end_clockcpu:
[bits 32]