;------------- THIS CODE SETS UP PROTECTED MODE VGA INTERRUPTS ------------
        push ds               ;This copies image of bios from c000:0000 to
        mov si, 0             ;the end of this.
        mov ax, 0c000h
        mov ds, ax
        mov di, bios_image
        mov cx, 200 ;32768
        rep movsw

mov al, "1"
mov ah, 0eh
xor bx, bx
int 10h

        pop ax
        mov ds, ax
        mov si, bios_image      ;Find Signature of VBE struc for VGA bios
        mov cx, 200
find_signature:
        cmp dword [si], "PMID"
        jz found_signature
        inc si
        loop find_signature
        ;--------- SIGNATURE ERROR CODE ----------
pre_sig_error:        
        mov cx, 22
        mov si, sig_error_msg
        xor bx, bx
        mov ah, 0eh
sig_error:
        lodsb
        int 10h
        loop sig_error
sig_hang:       jmp sig_hang
sig_error_msg   db      "VGA BIOS not supported"
        ;--------- END SIGNATURE ERROR CODE ----------
found_signature:        ;Now set up the VGA table thing
        mov al, "2"
        mov ah, 0eh
        xor bx, bx
        int 10h

        mov dword [shared_data + vgabiosptr], original_offset + bios_image
        mov ax, word [si + 4]
        mov word [shared_data + vgabiosptr + 4], ax
        mov ax, word [si + 6]
        mov word [shared_data + vgabiosptr + 8], ax
        mov word [si + 8], bios_data_sel
        mov word [si + 10], vga_a0000h_sel
        mov word [si + 12], vga_b0000h_sel
        mov word [si + 14], vga_b8000h_sel
        mov word [si + 16], vga_code_as_data
        mov byte [si + 18], 1
        mov al, bios_data_sel + vga_a0000h_sel + vga_b0000h_sel + vga_b8000h_sel + vga_code_as_data + 1
        add al, byte [si]
        add al, byte [si + 1]
        add al, byte [si + 2]
        add al, byte [si + 3]
        add al, byte [si + 4]
        not al
        mov byte [si + 19], al
        
;-------------------- VGA INTERRUPTS DONE SETTING UP ----------------
