.MODEL SMALL
.STACK 20H
.CODE

;This is the main program for HCPOS 0.001 It is loaded a sector
;above the boot sector at 7E00h

;Segments set to 7D0H b/c (offset 7C00h = seg 7C0h) & it's loaded
;200h above hcpos (7C00h), but assembler assembles files w/ an
;extra 100h on all offsets b/c of DOS PSP... our seg & off offset each other...

;Simplified: 7C00h(default) + 200h(boot sec) - 100h(assembler)
;            = 7D00h = seg 7D0h

;NOTE: I removed the commands to move the seg and put them into
;HCPOS

;*****************      MAIN      ***************************
MAIN:     

;****************       DATA      ***************************
        JMP OVERDATA1

PROMPT          DB      "Login Name: ", 0
NAME1           DB      "CRYPTO", 0
PROMPT2         DB      13, 10, "Password: ", 0
PASSWORD1       DB      "CODE0082", 0
COMPLETE        DB      13, 10, "Hit any key to restart...", 0

OVERDATA1:
                      
;***************    REGULAR CODE     *******************
        
ASK_LOGIN:
        MOV SI, OFFSET PROMPT;[7C00H + 512 + 4]  ;[OFFSET PROMPT + 7C00H + 512 - 100H]
        CALL PRINT_MESSAGE
        
        ;******************

RECEIVE_NAME:
        INC SI
        CALL INPUT_COMPARE

        ;******************

ASK_PASS:
        INC SI
        CALL PRINT_MESSAGE

        ;******************

PASS_COMPARE:
        MOV AH, 0
        MOV BH, 0
        INC SI
PASS_CYCLE:
        PUSH AX
        INT 16H          ;GET CHAR

        MOV CH, AL
        ADD CH, BYTE PTR [SI + 1]
        CMP AL, CH
        JZ B_4_DONE
        
        CMP BYTE PTR [SI], AL
        JNZ REBOOT

        MOV AH, 0EH
        PUSH AX
        MOV AL, 42
        INT 10H          ;SHOW '*'
        POP AX
        
        CMP AL, 0
        POP AX
        JZ DONE
      
        INC SI
        JMP PASS_CYCLE

        ;**********************

B_4_DONE:
        POP AX        
DONE:
        INC SI
        CALL PRINT_MESSAGE

        XOR AH, AH
        INT 16H

        JMP REBOOT

;************************   PROCEDURES   ****************************

PRINT_MESSAGE:
        MOV AH, 0EH
        MOV BH, 0
MESSAGE_LP:
        MOV AL, BYTE PTR [SI]       
        INT 10H
        INC SI
        CMP BYTE PTR [SI], 0
        JZ GO_BACK
        JMP MESSAGE_LP
GO_BACK: RET

         ;*****************

INPUT_COMPARE:
        MOV AH, 0
        MOV BH, 0
INPUT_CYCLE:
        PUSH AX
        INT 16H          ;GET CHAR

        MOV AH, 0EH
        INT 10H          ;ECHO

        MOV CH, AL
        ADD CH, BYTE PTR [SI + 1]
        CMP AL, CH
        JZ GO_BACK3

        CMP BYTE PTR [SI], AL
        JNZ REBOOT

        CMP AL, 0
        POP AX
        JZ GO_BACK2
       
        INC SI
        JMP INPUT_CYCLE

GO_BACK3: POP AX
GO_BACK2: RET

;**************************    END METHOD    **************************

REBOOT:         DB      0EAH, 0, 0, 0FFH, 0FFH

