;This code was written in NASM because I needed an Assembler that supports
;almost all 32-bit instructions and now it has become my FAVORITE assembler.
[bits 16]

%include "inc\equates.asm"
original_offset  equ    7e00h   ;8400h ;it would be 85570 if compiled as .com
stack_size      equ     200h    ;without org 100h on the yellow boot disk

start_code:
        xor ax, ax
        int 16h

;        mov ax, 040h
;        mov es, ax
;floppy_wait_b4PM:
;        cmp byte [es:03eh], 0
;        jz floppy_wait_b4PM     ;wait until BIOS gives completion return char (when tested, it was 1, but anything except
;                                ;for 0 should be fine, except for some rare read errors, etc.)
;        mov ecx, 0fffffffh
;waitalittlelonger:      loop waitalittlelonger
;        mov al, 0ch     ;00001100xb=set motors for floppy drives D->A not on,DMA&I/O enable,FloppyController enable, select
;                        ;floppy drive 00
;        mov dx, 03f2h   ;purpose of this command is to shut off floppy motor
;        out dx, al

        ;%include "inc\VGATest.asm"
        %include "inc\PMswitch.asm"
        jmp sys_code_sel:0
[bits 32]
code32:
	mov ax, sys_data_sel
	mov ds, ax
        mov gs, ax

        mov ax, shared_data_sel
        mov fs, ax

        mov ax, linear_data_sel
        mov es, ax

	mov ax, stack_sel
	mov ss, ax
	mov ebp, stack_end - the_stack
	mov esp, ebp

        ;**** This saves data about the hard disk in shared_data_sel

        sti

	mov bx, sp
        call sys_cls_csel:0
	cmp bx, sp
	jz go_on1
	mov esi, stack_fucked - code32
        mov al, white
	call sys_print_csel:0
itsmessedup:	jmp itsmessedup
go_on1:

	mov bx, sp
	call sys_clockcpu_csel:0	;Return clock speed in hertz in eax
	cmp bx, sp
	jz go_on2
	mov esi, stack_fucked - code32
        mov al, white
	call sys_print_csel:0
itsmessedup2:	jmp itsmessedup2
go_on2:
        mov dword [fs:cpu_speed], eax	;Save this value in the shared data selector

        push es				;need to push es, because hdinfo returns a pointer to the data in es
        call sys_hdinfo_csel:0
        mov al, byte [es:temp_numheads]
        mov byte [fs:hd0_numheads], al
        mov ax, word [es:temp_numcylinders]
        mov word [fs:hd0_numcylinders], ax
        mov ax, word [es:temp_numsectors]
        mov word [fs:hd0_numsectors], ax
        pop es

        push es
        mov ax, shared_data_sel
        mov es, ax              ;es will be changed anyway
        mov edi, temp_str
        xor eax, eax
        mov ax, fs
        call lib_bin_dec_csel:0 ;convert fs into a hex string in es:edi

        push ds
        mov ax, shared_data_sel
        mov ds, ax
        mov esi, temp_str
        mov al, white
        call sys_print_csel:0
        pop ds
        pop es

;        mov al, 0aeh   ;don't need this b/c keyboard already enabled
;        out 64h, al    ;When this was used, the cursor call froze the computer
;        xor al, al

;*********** EXCLUDE THIS CODE UNTIL IT HAS BEEN FINISHED *****************
	;test code for reading floppy drive
;	mov ax, 0c6h	;ah=0=bit4: head 0, bits1-0: floppy drive 0; and al=11000110xb=multi-track, MFM encoding,
;			;don't skip deleted sectors, bits4->0 have to be 00110xb
;	mov cx, 1	;cl=#sectors, ch=cylinder #
;	mov bl, 1	;bl=sector #
;        call sys_fdread_csel:0

        mov byte [fs:screen_attribute], white
        mov eax, dword [fs:ycoord]
        mul dword [fs:screen_width]
        add eax, dword [fs:xcoord]
        shl eax, 1              ;account for attribute bytes
        mov edi, eax
        add edi, dword [fs:video_offset]
theloop_withcursor:
       call sys_cursor_csel:0
theloop:
        hlt
        cmp word [fs:keyptr], 0
        jz theloop
        mov esi, shared_data - code32 + keybuffer
        add si, word [fs:keyptr] 
        movsb
        dec word [fs:keyptr]
        mov al, blue
        stosb

	inc dword [fs:xcoord]
	mov eax, dword [fs:xcoord]
        inc eax                 ;line #'s start at 0 instead of 1, so 0-79 not 1-80
        cmp eax, dword [fs:screen_width]
	jna theloop_withcursor		;If it hasn't passed the end of the x coord, loop
	mov dword [fs:xcoord], 0
	inc dword [fs:ycoord]
	mov eax, dword [fs:ycoord]
        inc eax
	cmp eax, dword [fs:screen_height]
	jna theloop_withcursor		;If it isn't off the bottom of the screen continue loop
	call sys_cls_csel:0
        jmp theloop_withcursor

;********** I N T E R R U P T   H A N D L E R S ************
        %include "inc\handlers.asm"
;************** S Y S T E M   C A L L S ***************
        %include "inc\SYSCalls.asm"
;************* L I B R A R Y   C A L L S **************
        %include "inc\LIBCalls.asm"
;******************* D A T A ********************
message1        db      "PROTECTED MODE!"
                TIMES 150 db 0
                db      "Welcome!",0
exc6            db      "Invalid opcode"
excA            db      "invalid TSS   "
excD            db      "Gen protection"
unknown         db      "Unknown Error "

        ;******* GDT ********
gdtr:	dw	gdt_end - gdt_start - 1	;gdt limit
        dd      gdt_start + original_offset

%include "inc\GDT.asm"
gdt_end:

        ;******** I D T ********
idtr:   dw      idt_end - idt_start - 1
        dd      idt_start + original_offset

%include "inc\IDT.asm"
idt_end:
        ;******** S T A C K *******
the_stack:      TIMES    stack_size   db   0
stack_end:

shared_data:
	num_gdt_entries	equ	(gdt_end - gdt_start) / 8
			dw	0
        keyptr          equ     $ - shared_data
                        dw      0
        keybuffer       equ     $ - shared_data
                TIMES   25  db  0
        keyscanbuffer   equ     $ - shared_data
                TIMES   25  db  0
	togglekeys	equ	$ - shared_data		;bits7-0: ctrl,alt,0,0,0,caps lock,num lock,scroll lock
			db	0
        curdir          equ     $ - shared_data
                TIMES   80  db  0
        xcoord          equ     $ - shared_data
                        dd      0
        ycoord          equ     $ - shared_data
                        dd      0
        video_offset	equ	$ - shared_data
                        dd      0b8000h          ;code switches to mode 3 (b800h) early, so enter it now...
	mode_type	equ	$ - shared_data
			db	"text"		;"text" or "grfx"
	screen_width	equ	$ - shared_data
                        dd      80
	screen_height	equ	$ - shared_data
			dd	25
        screen_attribute        equ     $ - shared_data
                        db      blue
	temp_str	equ	$ - shared_data
                        db      0,0,0,0,0,0,0,0,0,0 ;buffer w/ plenty of room to convert fs to hex & display
	;**** This section on will be hardware related info (excluding video) ****

	cpu_type	equ	$ - shared_data
		TIMES 16 db 0	;reserve 16 chars to describe processor type, extra bytes=0, ex: "Pentium III",0,0,0,0,0
	cpu_speed	equ	$ - shared_data
			dd	0
	hd0_numheads	equ	$ - shared_data
                        dw      0
	hd0_numcylinders	equ	$ - shared_data
                        dw      0
	hd0_numsectors	equ	$ - shared_data
                        dw      0
        fd_command      equ     $ - shared_data
			db	0		;If bit7 set=read operation currently active, bit6=write ..., bit5=seek,
						;bit4=scan (When an interrupt has handled it, it will clear the bit)
	fp_message1	equ	$ - shared_data
			db	"Motor on, doing seek",0
	fp_message2	equ	$ - shared_data
			db	"Seek complete, do read",0
	fp_message3	equ	$ - shared_data
			db	"Read commands written, getting status",0
	sys_int_mask	equ	$ - shared_data	;This is used to tell the system that an interrupt will not be available as
			dw	0;it normally is. EX: clockcpu sets bit8 of this word to indicate that interrupt 8 is hooked 
				 ;by it. Interrupt 8 also reads this each time to check which handler it should use.
	stack_fucked	db	"The stack is fucked.",0
right_before_end:
        resb    1024 - right_before_end + shared_data

;***************** End shared_data, BEGIN USER_DATA **********************
user_data:
	user0		equ	$ - user_data
			TIMES 16 db 0	;reserve 16 chars for name, any unused chars will remain nulls
	privelege0	equ	$ - user_data
			db	0	;privelege of user...
	user1		equ	$ - user_data
			TIMES 16 db 0
	privelege1	equ	$ - user_data
			db	0
	user2		equ	$ - user_data
			TIMES 16 db 0
	privelege2	equ	$ - user_data
			db	0
		TIMES (17 * 5) db 0	;17 bytes/user * 5 more users for a total of eight users
	;Will list no more, but to access user5 for example, you could easily do something like:
	;"mov esi, user1 * 5" to get its offset within user_data
end_user_data:
