.MODEL SMALL     
.STACK 100H
.CODE

MAIN:

;************************ DATA ************************
        JMP OVERDATA1
                                                                               
        ;****** HCP COMMANDS ******                   
CD      DB      "CD",0,0,0,0,0,0,0   ;Each command has 8 chars max.                            
DIR     DB      "DIR",0,0,0,0,0,0    ;These are used to test when figuring                          
FIND    DB      "FIND",0,0,0,0,0     ;out which command the user has typed.                        
MEM     DB      "MEM",0,0,0,0,0,0                              
LOGOFF  DB      "LOGOFF",0,0,0
REGS    DB      "REGS",0,0,0,0,0
CLS     DB      "CLS",0,0,0,0,0,0
DAN     DB      "DAN",0,0,0,0,0,0
NUM_TBL_ENTRIES   EQU     8   ;!!!!Counts by 2, starting w/ zero!!!

OVERDATA1:

;********************* MAIN CODE **********************

        MOV BP, OFFSET MY_STACK_PTR
        MOV SP, OFFSET MY_STACK_PTR

OS_CYCLE:
        CALL CLEAR_INPUT

        MOV SI, OFFSET CURDIR
        CALL PRINT_MESSAGE
        MOV AH, 0EH
        XOR BH, BH
        MOV AL, "\"
        INT 10H

        XOR DH, DH
        MOV DI, OFFSET INPUT
        CALL GET_INPUT
        MOV AH, 0EH
        INT 10H
        CALL INTERPRET
        
        JMP OS_CYCLE

;******************* END MAIN CODE ********************

;********************* PROCEDURES *********************
PRINT_MESSAGE:
        MOV AH, 0EH
        MOV BH, 0
        PUSH SI
MESSAGE_LP2:
        LODSB
        CMP AL, 0
        JZ GO_BACK2
        INT 10H
        JMP MESSAGE_LP2
GO_BACK2:
        POP SI
        RET
        ;*************

COM_NUM         DW      0
INTERPRET:
        MOV SI, OFFSET INPUT
        MOV DI, OFFSET CD
        MOV CX, 8
INTER_CYCLE:
        CMP BYTE PTR [DI], 0
        JZ FOUND_ONE
        CMPSB
        JNZ NEXT_ONE
        LOOP INTER_CYCLE
FOUND_ONE:
        
        MOV AX, WORD PTR [COM_NUM]
        MOV WORD PTR [COM_NUM], 0

        CMP AX, 0
        JZ GOTO_CD
        CMP AX, 1
        JZ GOTO_DIR
        CMP AX, 2
        JZ GOTO_FIND
        CMP AX, 3
        JZ GOTO_MEM
        CMP AX, 4
        JZ GOTO_LOGOFF
        CMP AX, 5
        JZ GOTO_REGS
        CMP AX, 6
        JZ GOTO_CLS
        CMP AX, 7
        JZ GOTO_DAN
GOTO_CD: JMP CD_HANDLER
GOTO_DIR: JMP DIR_HANDLER
GOTO_FIND: JMP FIND_HANDLER
GOTO_MEM: JMP MEM_HANDLER
GOTO_LOGOFF: JMP LOGOFF_HANDLER
GOTO_REGS: JMP REGS_HANDLER
GOTO_CLS: JMP CLS_HANDLER
GOTO_DAN: JMP DAN_HANDLER

NEXT_ONE:
        CMP WORD PTR [COM_NUM], NUM_TBL_ENTRIES
        JZ NOT_FOUND
        ADD DI, CX
        INC WORD PTR [COM_NUM]       ;, 2
        MOV CX, 8
        MOV SI, OFFSET INPUT
        JMP INTER_CYCLE
NOT_FOUND:
        MOV WORD PTR [COM_NUM], 0
        JMP RUN_PROGRAM
        ;*************
GET_INPUT:                      ;When GET_INPUT is called, DS:DI has to point
        MOV CX, 100             ;to buffer and DH = 0 if echo char, DH = 1
        MOV BH, 0               ;if echo '*'
THE_CYCLE1:
        XOR AH, AH
        INT 16H
        CMP AH, 59
        JZ GOTO_USER_SWITCH
        CMP AL, 8
        JZ DO_BACKSPACE
        CMP AL, 13
        JZ GO_BACK1
        STOSB
        CMP DH, 0
        JNZ ECHO_AST

ECHOED_AST:
        MOV AH, 0EH
        INT 10H
        LOOP THE_CYCLE1      
GO_BACK1:   RET
ECHO_AST:
        MOV AL, 42
        JMP ECHOED_AST
DO_BACKSPACE:
        CMP DI, OFFSET INPUT
        JZ THE_CYCLE1
        DEC DI
        MOV BYTE [ES:DI], 0
        MOV AH, 0EH
        INT 10H
        XOR AL, AL
        INT 10H
        MOV AL, 8
        INC CX
        INC CX
        JMP ECHOED_AST   ;'ECHOED_AST' is used for two return locations
GOTO_USER_SWITCH:
        JMP USER_SWITCH
        ;****************

CLEAR_INPUT:
        MOV DI, OFFSET INPUT
        MOV CX, 50
        XOR AX, AX
        REP STOSW
        MOV AH, 0EH
        MOV AL, 13
        XOR BH, BH
        INT 10H
        MOV AL, 10
        INT 10H
        RET
        ;*****************

RUN_PROGRAM:
        MOV SI, OFFSET ERROR1
        CALL PRINT_MESSAGE
        
        RET
        ;*****************
               
;*********************** COMMAND HANDLERS ***********************
CD_HANDLER:
        RET
        ;**********
DIR_HANDLER:
        RET
        ;**********
FIND_HANDLER:
        RET
        ;**********
MEM_HANDLER:
        RET
        ;**********
LOGOFF_HANDLER:
        POP BX
        POP BX
        JMP REBOOT
        ;**********

REG_FRAME       DB 13,10,"          AX =           CS =           SI ="
                DB 13,10,"          CX =           DS =           DI ="
                DB 13,10,"          DX =           ES =           BP ="
                DB 13,10,"          BX =           SS =           SP =",13,10,0
ROW     DB      0
COL     DB      0
LAPNUM  DB      1
IN_LAPNUM DB    1

REGS_HANDLER:
        PUSH SP
        PUSH SS
        PUSH BX
        PUSH BP
        PUSH ES
        PUSH DX
        PUSH DI
        PUSH DS
        PUSH CX
        PUSH SI
        PUSH CS
        PUSH AX

        MOV SI, OFFSET REG_FRAME
        CALL PRINT_MESSAGE

        MOV AH, 03H
        XOR BH, BH
        INT 10H
        SUB DH, 4
        MOV BYTE PTR [ROW], DH
        MOV BYTE PTR [COL], DL     
        
        MOV SI, OFFSET CONV_BUFFER
REGS_OUT_LOOP:
        MOV BYTE PTR [IN_LAPNUM], 1
REGS_IN_LOOP:
        POP DX
        XOR AX, AX
        MOV DI, OFFSET CONV_BUFFER
        INT 2EH
        CALL NEXT_COL
        CALL PRINT_MESSAGE
        CMP BYTE PTR [IN_LAPNUM], 3
        JZ IMOUT1
        ADD BYTE PTR [IN_LAPNUM], 1
        JMP REGS_IN_LOOP
IMOUT1:
        CMP BYTE PTR [LAPNUM], 4
        JZ DONE_REGS
        ADD BYTE PTR [LAPNUM], 1
        CALL NEXT_ROW
        JMP REGS_OUT_LOOP

DONE_REGS:
        MOV BYTE PTR [LAPNUM], 1
        RET
        NEXT_ROW:
                INC BYTE PTR [ROW]
                SUB BYTE PTR [COL], 45
                MOV DH, BYTE PTR [ROW]
                MOV DL, BYTE PTR [COL]
                XOR BH, BH
                MOV AH, 2
                INT 10H
                RET
        NEXT_COL:
                ADD BYTE PTR [COL], 15
                MOV DH, BYTE PTR [ROW]
                MOV DL, BYTE PTR [COL]
                XOR BH, BH
                MOV AH, 2
                INT 10H
                RET               
        ;*************

CLS_HANDLER:
        MOV AX, 0003H
        INT 10H
        RET
        ;*************

USER_SWITCH:
        POP BX
        POP BX
        JMP OS_CYCLE
        ;*************

MESSAGE DB 13,10,"Fuck you!",0
DAN_HANDLER:
        MOV SI, OFFSET MESSAGE
        CALL PRINT_MESSAGE
        RET
;************************ FINAL STUFF **************************
REBOOT:  DB      0EAH, 0, 0, 0FFH, 0FFH
ERROR1  DB      13, 10, "Command/File not found", 13, 10, 0
        ;*********
CONV_BUFFER     DB      4 DUP (?)
                DB      "H",0
EXPANSION_SPACE DB    778 DUP (?)
MY_STACK        DB    200H DUP (?)
MY_STACK_PTR:
        ;*********
WORK_SPACE1:    DB      100 DUP (?)
WORK_SPACE2:    DB      100 DUP (?)
WORK_SPACE3:    DB      100 DUP (?)
WORK_SPACE4:    DB      100 DUP (?)
WORK_SPACE5:    DB      112 DUP (?)

        ;*********
COMMUNICATION:
CURDIR          DB      80 DUP (?)
DIR_NUMS        DB      10 DUP (?)
INPUT           DB      100 DUP (?)
USERNAME        DB      16 DUP (?)
ROOT_DIR        DB      "HCPOS"
                DB      11 DUP (?)
ROOT_DRIVE      DB      6  DUP (?)
NOT_DETERMINED  DB      284 DUP (?)

END MAIN
