[bits 16]
org 100h

	call wait4ready
        jnc setCHS_drv_head
        jmp error
setCHS_drv_head:
	mov dx, 01f6h
	mov al, 0a0h   ;10100000xb = CHS, Drive 0, Head 0
	out dx, al
	
	call wait4ready
        jnc maskirq
        jmp error

maskirq:
	mov dx, 0a1h	;irq masking register
	in al, dx
	or al, 040h	;01000000xb = mask irq14
	out dx, al

	mov ah, 8
	mov dl, 80h
	int 13h		;Get drive parameters, return: dh=physical # heads
	cmp dh, 8	;For some reason, if < 8 heads, say 0, if >= say 8
	jae changeto8heads
	xor al, al
	jmp outputphysicalheads
changeto8heads:	mov al, 8
outputphysicalheads:	mov dx, 0376h
	out dx, al
	
	;If there was a precompensation cylinder, it would go to port 01f1h
	;but for now keep it simple. (precomp cylinder would be divided by 4)

	mov dx, 01f2h		;Set #sectors = 1
	mov al, 1
	out dx, al
	
	inc dl
	out dx, al		;sector # = 1

	inc dl
	dec al
	out dx, al		;cylinder low = 0

	inc dl
	out dx, al		;cylinder high = 0

	inc dl
	mov al, 0a0h		;=10100000xb=1,CHS,1,drive 0, head 0000
	out dx, al

	inc dl
        mov al, 020h            ;read sectors w/ retry command
        out dx, al
readpause:
	mov cx, 100h
readpauseloop:	loop readpauseloop
        mov dx, 01f7h
        in al, dx
        test al, 80h
        jnz readpause
        test al, 29h
        jz readpause
	test al, 08h    ;if 0 then data not ready(=10001000xb = busy&data req
        jnz doread
	jmp error
        
doread:
	mov dx, 01f0h
        mov di, buffer
        mov cx, 256
        rep insw
	
	mov dx, 1f7h
	in al, dx
	and al, 1
	jnz error

        mov ah, 9
        mov dx, buffer
        int 21h

        mov dx, 01f7h
        in al, dx
        and al, 1
        jnz error

        mov ax, 0201h   ;ah=2, al=#sectors
        mov cx, 1       ;ch = low 8 bits cylinder#, cl = 2high cyl & sector #
        mov dx, 80h     ;dh = head #, dl = drive # (10000000xb = hd = 80h)
        mov bx, buffer2 ;es:bx -> buffer
        int 13h         ;read sectors

        mov si, buffer
        mov di, buffer2
        mov cx, 256
comparing:
        cmpsw
        jnz error
        loop comparing

        jmp done
;*********************** Called procedures ************************
error:
        mov dx, 01f1h
        in al, dx
        inc al
        inc al
        mov dl, al
        mov ah, 2
        int 21h

        mov dx, err_message
	mov ah, 9
	int 21h
	
done:
	mov dx, 0a1h	;irq masking register
	in al, dx
        and al, 0bfh     ;10111111xb = unmask irq14
	out dx, al

        mov ax, 4c00h
	int 21h
err_message	db	"Error in waiting...$"
	;******************
wait4ready:
	pusha
	mov dx, 01f7h
        mov cx, 0
waitloop:
	in al, dx
        and al, 040h    ;01000000xb = drive ready
        cmp al, 040h
        jz ready
	push cx
	xor cx, cx
pause:	loop pause
	pop cx
	loop waitloop
	stc		;store carry flag as a return error
ready:
	popa
	ret

irq14offset     dw      0
irq14segment    dw      0
buffer	TIMES	512	db 0
endbuffer	db	"$"
buffer2 TIMES   512     db 0
