.MODEL SMALL
.STACK 200H
.CODE

MAIN:

        JMP OVERDATA1

;***************** D A T A *********************
PROMPT1         DB      28, 63, 55, 57, 62, 10, 240, 208 
                       ; L   o   g   i   n   :  [sp] [0]

PROMPT2         DB      221, 218, 32, 49, 67, 67, 71, 63, 66, 52, 10, 240, 208
                       ;[cr] [lf]  P   a   s   s   w   o   r   d   :  [sp] [0]

                        ;*Prompts are messages slightly encoded so that they
                        ;*won't be noticed by a skim over the data
                        ;---encoded by subtracting 48 from each
LOGIN:
        PUSH AX         ;*Login is a data area to store the user's login name
        PUSH BX         ;*This code is just there to fool a hacker/cracker
        PUSH CX         ;*into thinking it's actually code used by the OS...
        PUSH DX
        PUSH SI
        PUSH DI
        MOV AX, WORD PTR [DS:DI]
        DB      90H, 90H, 90H, 90H, 90H, 90H, 0
PASSWORD:
        POP AX
        POP BX          ;Same reasoning as login data area...
        POP CX
        POP DX
        POP SI
        POP DI
        MOV AX, WORD PTR [DS:DI]
        DB      90H, 90H, 90H, 90H, 90H, 90H, 0

BUFFER1         DB      16 DUP (90H)   ;Buffer to scramble the login into...
                DB      0
;*???*BUFFER2         DB      32 DUP (90H)   ;Buffer to load the secret code into...
;*???*                DB      0              
BUFFER3         DB      32 DUP (90H)   ;Buffer to develope the new code
                DB      0

                ;*Commands are done to take the user's input and turn them
                ; into the secret code (into BUFFER2). The secret code in 
                ; the boot sector is also added into BUFFER3. Then the
                ; buffers are compared.
                ;*Finally, the name in LOGIN is looked up in a file in the
                ; root directory to set settings and restrictions.

;**********************  C O D E  *****************************
OVERDATA1:

        MOV SI, OFFSET PROMPT1
        CALL PRINT_MESSAGE_W48  ;Print message w/ adding 48

        ;**************

        MOV DI, OFFSET LOGIN
        XOR DH, DH             ;* If DH = 0 echoes char, if 1 echos "*"
        CALL GET_INPUT

        ;**************

        MOV SI, OFFSET PROMPT2
        CALL PRINT_MESSAGE_W48

        ;**************

        MOV DI, OFFSET PASSWORD
        MOV DH, 1
        CALL GET_INPUT

        ;***************

SCRAMBLE_LOGIN:
        MOV SI, OFFSET LOGIN      ;*Get ready to Move LOGIN name into BUFFER1
        MOV DI, OFFSET BUFFER1    ;*in scrambled order.
                       ;*Clear AX b/c it's used to store the current byte
        XOR AX, AX     ;*and to store the current highest byte
        MOV CX, 16     ;*Fill all 16 positions of the scrambled buffer
        ;PUSH CX        ;*Stack CX b/c of inner loop (need to save outer)
        ;PUSH SI        ;*Keep initial stack position & a reference for where
                       ;*to clear byte at. 

;It makes it to here without freezing...

;        MOV WORD PTR [BUFFER_LOOP], CX
OUTER_LOOP:
        PUSH CX
        PUSH SI
        MOV CX, 16    ;*Get ready for inner loop - each time scans all 16 chars
        ;******
INNER_LOOP:
        LODSB         ;*Load the current byte to be compared (inc SI also)
        CMP AL, AH    ;*Compare it to AH (where highest byte is stored)
        JB HIGHER     ;*If current byte is higher then make changes
BACK_FROM_HIGHER:          ;*Place to come back from changes...
        LOOP INNER_LOOP
        ;******
        POP SI             ;*Find out where highest byte was & DEC it b/c it
        DEC SI             ;*was INC automatically...
        MOV BYTE PTR [SI], 0  ;*Clear position where highest byte b/c it 
                              ;*shouldn't be repeatedly used...
        MOV AL, AH
        STOSB    ;*Stores byte in AL (originally AH where highest byte was)

        ;*Load cycle of outer loop from stack

        XOR AX, AX        ;*Clear so that comparing starts over next outer loop
        MOV SI, OFFSET LOGIN  ;*Start this pointer back at beginning for compare   
        ;PUSH SI           ;*Push it for now (will be changed if there is a
                          ;*higher value left somewhere in the LOGIN mem
        ;MOV CX, 1
        ;CMP WORD PTR [BUFFER_LOOP], CX
        ;JZ PRE_CONVERT
        ;SUB WORD PTR [BUFFER_LOOP], 1
        
        POP CX

        LOOP OUTER_LOOP  ;*Done w/ transfer
        JMP PRE_CONVERT

HIGHER:
        MOV AH, AL
        POP BX            ;This just used to take last SI push off stack...
        PUSH SI
        JMP BACK_FROM_HIGHER
BUFFER_LOOP DW 0

        ;***************

PRE_CONVERT:
        ;POP SI      ;These are left over from usage in the previous code
                    ;(Just get them off the stack)

        ;***************

        MOV BH, 0
        MOV AH, 0
        INT 16H
        MOV AH, 0EH
        INT 10H

        MOV BH, 0
        MOV AH, 0
        INT 16H
        MOV AH, 0EH
        INT 10H

CONVERT_B_2_W:

        MOV SI, OFFSET PASSWORD
        MOV DI, OFFSET BUFFER3
        PUSH DI               ;Push, so can be popped to SI in FIND_CODE

        MOV CX, 16            ;Mov 16 bytes to 16 words
TRANSFER1:
        LODSB                 ;Load from ES:SI (PASSWORD) to AL
        CBW                   ;Convert AL to AX
        STOSW                 ;Store AX (word) into ES:DI (BUFFER3)
        LOOP TRANSFER1
                        
        ;***************

PRE_FIND_CODE:
        POP SI             ;Get beginning of BUFFER3
        MOV DI, OFFSET BUFFER1  ;Store offset BUFFER1 for use in OPTION#s
        MOV CX, 16
        ;PUSH CX
        
FIND_CODE:
        PUSH CX
        MOV BH, 0
        MOV AH, 0
        INT 16H
        MOV AH, 0EH
        INT 10H
        MOV BH, 0
        MOV AH, 0
        INT 16H
        MOV AH, 0EH
        INT 10H
        MOV BH, 0
        MOV AH, 0
        INT 16H
        MOV AH, 0EH
        INT 10H


        LODSW              ;Load next value for coding
        SUB SI, 2

        CMP AX, 136        ;Shorten run-time slightly by decreasing amount
        JA HALF_WAY        ;of comparisons

        CMP AX, 13          ;These jumps were too far to make completely
        JB P_OPTION1        ;b/c they are special ones (<128 bytes)
        CMP AX, 60          ;So it jumps part way, where a full-jump
        JB P_OPTION2        ;takes over...
        CMP AX, 98
        JB P_OPTION5        ;Uses same as 9
        CMP AX, 109
        JB P_OPTION4
        CMP AX, 121
        JB P_OPTION5
        CMP AX, 125
        JB P_OPTION6
        CMP AX, 130
        JB P_OPTION7

FIND_CODE_LOOP: LOOP FIND_CODE   ;This is here b/c the loop couldn't jump
                                 ;far enough. This won't be executed unless
                                 ;(see code 19 lines above & 39 down...)

        JMP COMPARE_CODES        ;If loop is done, it needs to compare...

HALF_WAY:                        
        CMP AX, 137
        JB P_OPTION8
        CMP AX, 149
        JB P_OPTION11
        CMP AX, 156
        JB P_OPTION10
        CMP AX, 161
        JB P_OPTION11
        CMP AX, 165
        JB P_OPTION12
        CMP AX, 175
        JB P_OPTION13
        CMP AX, 186
        JB P_OPTION14
        CMP AX, 201
        JB P_OPTION15
        CMP AX, 240
        JB P_OPTION6
        JMP P_OPTION1

P_OPTION1: JMP OPTION1
P_OPTION2: JMP OPTION2
P_OPTION4: JMP OPTION4
P_OPTION5: JMP OPTION5
P_OPTION6: JMP OPTION6
P_OPTION7: JMP OPTION7
P_OPTION8: JMP OPTION8
P_OPTION10: JMP OPTION10
P_OPTION11: JMP OPTION11
P_OPTION12: JMP OPTION12
P_OPTION13: JMP OPTION13
P_OPTION14: JMP OPTION14
P_OPTION15: JMP OPTION15

RETURN_FROM_MANIPULATION:

        MOV WORD PTR [ES:SI], AX
        ADD SI, 2
        POP CX
        JMP FIND_CODE_LOOP    ;Special jump too far, so had to make closer.      
        
        ;***************

COMPARE_CODES:
       
        MOV AH, 0
        INT 16H
        MOV BH, 0
        MOV AH, 0EH
        INT 10H

        MOV AX, 7C0H     ;Change to read from boot segment
        MOV DS, AX
        MOV SI, 160      ;At offset 160 (password secret #'s hidden)

        MOV CX, 32       ;Check the 32 chars of special code
        MOV DI, OFFSET BUFFER3
CHECK_CHARS:
        MOV AH, BYTE PTR [DI]
        CMP BYTE PTR [DS:SI], AH
        JNZ GOTO_REBOOT
        LOOP CHECK_CHARS

        MOV AX, 7D0H     ; Resets DS segment back
        MOV DS, AX

        JMP CONTINUE_OS

GOTO_REBOOT:
        JMP REBOOT
        ;****************

CONTINUE_OS:
        MOV AH, 0
        INT 16H
        JMP REBOOT

;*******************  P R O C E D U R E S  **************************

PRINT_MESSAGE_W48:
        MOV AH, 0EH
        MOV BH, 0
MESSAGE_LP:
        LODSB
        ADD AL, 48
        CMP AL, 0
        JZ GO_BACK
        INT 10H
        JMP MESSAGE_LP
GO_BACK: RET

        ;***********************

GET_INPUT:
        MOV CX, 16
        MOV BH, 0
THE_CYCLE1:
        XOR AH, AH
        INT 16H

        CMP AL, 13
        JZ GO_BACK1

        STOSB

        MOV AH, 0EH
        CMP DH, 0
        JNZ ECHO_AST

ECHOED_AST:
        INT 10H
        LOOP THE_CYCLE1      
GO_BACK1:   RET
ECHO_AST:
        MOV AL, 42
        JMP ECHOED_AST

        ;*********************

;******************* S P E C I A L * P R O C E D U R E S *****************
OPTION1:
        SUB AX, 40
        JMP OPTION11
OPTION2:
        MOV AX, 10
        JMP RETURN_FROM_MANIPULATION
OPTION4:
        MOV BX, WORD PTR [ES:DI]
        MUL BX
        INC DI
        ADD AX, WORD PTR [ES:DI]
        DEC DI
        JMP RETURN_FROM_MANIPULATION
OPTION5:
        PUSH DI
        ADD DI, 3
        MOV BX, WORD PTR [ES:DI]
        MUL BX
        MOV DI, [OFFSET BUFFER3 + 30]
        SUB AX, WORD PTR [ES:DI]
        POP DI
        JMP RETURN_FROM_MANIPULATION
OPTION6:
        MOV BX, 2
        DIV BX
        PUSH AX
        MOV AL, BYTE PTR [ES:DI + 2]
        CBW
        MOV BX, 103
        MUL BX
        POP BX
        ADD AX, BX
        DEC AX
        JMP RETURN_FROM_MANIPULATION
OPTION7:
        MOV BX, 2
        MUL BX
        PUSH DI
        MOV DI, [OFFSET LOGIN + 14]
        ADD AX, WORD PTR [ES:DI]
        POP DI
        MOV BX, 221
        MUL BX
        JMP RETURN_FROM_MANIPULATION
STORAGE1 DW 0
OPTION8:
        MOV WORD PTR [STORAGE1], AX
        PUSH DI
        PUSH CX
        MOV CX, 16
        MOV BX, 113
CYCLE_O8:
        MOV AL, BYTE PTR [ES:DI]
        INC DI
        CBW
        MUL BX
        ADD WORD PTR [STORAGE1], AX
        SUB BX, 11
        LOOP CYCLE_O8

        MOV AX, WORD PTR [STORAGE1]
        POP CX
        POP DI
        JMP RETURN_FROM_MANIPULATION

OPTION10:
        PUSH DI
        MOV DI, OFFSET PASSWORD
        ADD AX, WORD PTR [ES:DI]
        ADD AX, WORD PTR [ES:DI + 14]
        MUL AX
        ADD AL, BYTE PTR [ES:DI + 1]
        POP DI
        JMP RETURN_FROM_MANIPULATION

OPTION11:
        MOV DX, AX
        PUSH CX
        MOV CX, 16
        
CYCLE_O11:
        MUL DX
        MOV BX, 17
        SUB BX, CX
        ADD BX, 100
        DIV BX
        LOOP CYCLE_O11
        POP CX

        MOV BX, WORD PTR [ES:DI + 2]
        DIV BX
        ADD AX, 50000
        JMP RETURN_FROM_MANIPULATION
OPTION12:
        MUL AX
        MOV BX, AX
        PUSH DI
        MOV DI, 81
        MOV AL, BYTE PTR [DS:DI]
        POP DI
        CBW
        MUL BX
        PUSH AX
        MOV AL, BYTE PTR [ES:DI + 1]
        CBW
        POP BX
        MUL BX
        JMP RETURN_FROM_MANIPULATION
OPTION13:
        ADD AX, 10
        JMP OPTION11

OPTION14:
        SUB AX, 7
        JMP OPTION7

OPTION15:       
        ADD AX, 154
        PUSH AX
        MOV AL, BYTE PTR [ES:DI + 1]
        CBW
        MOV BX, AX
        POP AX
        DIV BX

        PUSH AX
        MOV AL, BYTE PTR [ES:DI + 3]
        CBW
        MOV BX, AX
        POP AX
        MUL BX
        JMP RETURN_FROM_MANIPULATION       

;************* E N D *  S P E C I A L * P R O C E D U R E S **************    

REBOOT:         DB 0EAH, 0, 0, 0FFH, 0FFH
END MAIN

