	gdt_size	equ	$ - shared_data
			dd	gdt_end - gdt_start
	gdt_free_entries	equ	$ - shared_data
			dd	8191 - ((gdt_end - gdt_start) / 8)
	last_mem_alloc	equ	$ - shared_data
			dd	0		;Offset into mem_data_sel of last entry created. This is used so that if mem
			;is allocated for something and then a selector for it is failed to be created, it can remove the
			;memory allocation without having to know the selector.
	device_sel	equ	$ - shared_data
			dw	0		;Because the devices, task data, and user selectors are dynamically
	task_sel	equ	$ - shared_data	;created, it is necessary to place them into a know location so that they
			dw	0		;may be accessed by syscalls.
	user_sel	equ	$ - shared_data
			dw	0
	num_irq0s	equ	$ - shared_data
			dd	0		;number of irq0's since boot
        keyptr          equ     $ - shared_data
                        dw      0
        keybaseptr      equ     $ - shared_data
                        dw      0
	numkeys		equ	$ - shared_data
			dw	0		;#keys currently being stored in buffer
        keybuffer       equ     $ - shared_data
                TIMES   25  db  0
        keyscanbuffer   equ     $ - shared_data
                TIMES   25  db  0
	togglekeys	equ	$ - shared_data		;bits7-0: ctrl,alt,0,0,0,caps lock,num lock,scroll lock
			db	0
	tab_length	equ	$ - shared_data
			dd	5			;tab length default is 5 spaces
        curdir          equ     $ - shared_data
                TIMES   80  db  0
        xcoord          equ     $ - shared_data
                        dd      0
        ycoord          equ     $ - shared_data
                        dd      0
        video_offset	equ	$ - shared_data
                        dd      0b8000h          ;code switches to mode 3 (b800h) early, so enter it now...
	mode_type	equ	$ - shared_data
			db	"text"		;"text" or "grfx"
	screen_width	equ	$ - shared_data
                        dd      80
	screen_height	equ	$ - shared_data
			dd	25
        screen_attribute        equ     $ - shared_data
                        db      blue
	temp_mask	equ	$ - shared_data
			db	03h		;00000011xb = temps 0&1 masked (below)
	temp_data1	equ	$ - shared_data
			db	13,10,"CPU Speed: ",0,0,0	;buffer w/ plenty of room to convert fs to hex & display
        temp_data2	equ     $ - shared_data
                        db      13,10,"Memory: ",0,0,0,0,0,0
	temp_data3	equ	$ - shared_data
			times 16 db 0
	temp_data4	equ	$ - shared_data
			db	" hertz",0,0,0,0,0,0,0,0,0,0
	temp_data5	equ	$ - shared_data
			times 16 db 0
	temp_data6	equ	$ - shared_data
			times 16 db 0
	temp_data7	equ	$ - shared_data
			times 16 db 0
	temp_data8	equ	$ - shared_data
			db	"Processor Brand: ",0
	;**** This section on will be hardware related info (excluding video) ****

	cpu_type	equ	$ - shared_data
		TIMES 16 db 0	;reserve 16 chars to describe processor type, extra bytes=0, ex: "Pentium III",0,0,0,0,0
	cpu_speed	equ	$ - shared_data
			dd	0
	loop_cycles	equ	$ - shared_data
			dd	0
	memory_count	equ	$ - shared_data		;In MegaBytes
			dd	0
	lpt1_baseaddr	equ	$ - shared_data
			dw	0
	lpt2_baseaddr	equ	$ - shared_data
			dw	0
	lpt3_baseaddr	equ	$ - shared_data
			dw	0
;************ NOTE: IT IS VERY CRITICAL TO KEEP THESE IN THIS ORDER BECAUSE SOME SYSCALLS RELY ON THIS ORDER!!! ******
	hd0_command	equ	$ - shared_data
			db	0			;If bit7 set read operation taking place, bit6 = write operation
	hd0_numheads	equ	$ - shared_data
                        dw      0
	hd0_numcylinders	equ	$ - shared_data
                        dw      0
	hd0_numsectors	equ	$ - shared_data
                        dw      0
	hd1_command	equ	$ - shared_data
			db	0
	hd1_numheads	equ	$ - shared_data
			dw	0
	hd1_numcylinders	equ	$ - shared_data
			dw	0
	hd1_numsectors	equ	$ - shared_data
			dw	0
	hd2_command	equ	$ - shared_data
			db	0
	hd2_numheads	equ	$ - shared_data
			dw	0
	hd2_numcylinders	equ	$ - shared_data
			dw	0
	hd2_numsectors	equ	$ - shared_data
			dw	0
	hd3_command	equ	$ - shared_data
			db	0
	hd3_numheads	equ	$ - shared_data
			dw	0
	hd3_numcylinders	equ	$ - shared_data
			dw	0
	hd3_numsectors	equ	$ - shared_data
			dw	0
	hd_strings	equ	$ - shared_data
			db	" Hard disks were found on your computer:",0
			db	13,10,9,"HD",0
			db	9, "Heads: ",0,9,"Cylinders: ",0,9,"Sectors/Head: ",0
;**********--------------------------------------------************
        fd_command      equ     $ - shared_data
			db	0		;If bit7 set=read operation currently active, bit6=write ..., bit5=seek,
						;bit4=scan (When an interrupt has handled it, it will clear the bit)
	fd_motors	equ	$ - shared_data
			db	0		;if bit4 set fd0 motor is on, if bit5 set fd1 motor is on, etc. to fd4 (low nibble not used)
	fp_message1	equ	$ - shared_data
			db	"Motor on, doing seek",0
	fp_message2	equ	$ - shared_data
			db	"Seek complete, do read",0
	fp_message3	equ	$ - shared_data
			db	"Read commands written, getting status",0
	need_swap	equ	$ - shared_data					;Used in sys_alloc_mem syscall!!!
			db	"You need to create the swapping syscall!",0
	sys_int_mask	equ	$ - shared_data	;This is used to tell the system that an interrupt will not be available as
			dw	0;it normally is. EX: clockcpu sets bit8 of this word to indicate that interrupt 8 is hooked 
				 ;by it. Interrupt 8 also reads this each time to check which handler it should use.
	mount_usernum	equ	$ - shared_data
			dw	0
	mount_flags	equ	$ - shared_data
			db	0
	mount_err	equ	$ - shared_data
			dd	0	;only first byte is for an error, late word is used to temporarily save a selector
	mount_str_offset	equ	$ - shared_data
			dd	0
	mount_entry_offset	equ	$ - shared_data
			dd	0
	test_mount	equ	$ - shared_data
			db	"/fd0/",0,"myfd",0
right_before_end:
        resb    1024 - right_before_end + shared_data
