;Each selector's first word is an offset to a handler. To view this handler,
;look at "inc\handlers.asm".
;Also, for those of you who don't know much about irq's, this is how they work:
;	When the PIC (Programmable Interrupt Controller) is initialized, one of the registers that is output to it
;	is called ICW2 and contains the high 5 bits of the interrupt #. When the PIC receives an IRQ from a hardware device,
;	it takes the IRQ # (3 bits) and puts them after the 5 bits entered in ICW2 when the PIC was initialized.
;	This gives the interrupt number. Some of you are probably saying, "But there are 16 irqs (0-15) and 3 bits is only
;	enough for 8 irqs." Solution: there are two PICs. PIC1 has its ports at 020h and 021h and PIC2 has its ports at
;	0a0h and 0a1h. When PIC2 gets an irq (8-15 where 8's bits would be 000 and 15's 111) it combines the irq's 3 bits
;	with the 5 bits entered in its ICW2 register to get the interrupt #. NOTE: There are two ICW2's, one for each PIC.
;	And both PIC's have to be initialized.
;	But this is only enough info. to get you started. I suggest you look up these port numbers or the
;	PIC in a more thorough source.

idt_start:

	;Interrupts 0-5
%rep 6
        dw unhand               ; entry point 15:0
        dw interrupt_sel        ; selector
        db 0                    ; word count
        db 0x8E                 ; type (32-bit Ring 0 interrupt gate)
        dw 0                    ; entry point 31:16 (XXX - unhand >> 16)
%endrep

	dw exception6
        dw interrupt_sel
        db 0
        db 0x8E
        dw 0

        dw unhand
        dw interrupt_sel
        db 0
        db 0x8E
        dw 0

        dw exception8
        dw interrupt_sel
        db 0
        db 0x8E
        dw 0

        dw unhand               ; entry point 15:0
        dw interrupt_sel        ; selector
        db 0                    ; word count
        db 0x8E                 ; type (32-bit Ring 0 interrupt gate)
        dw 0                    ; entry point 31:16 (XXX - unhand >> 16)
        
        dw exceptionA
        dw interrupt_sel
        db 0
        db 0x8E
        dw 0

	;interrupts 0bh and 0ch
%rep 2
        dw unhand
        dw interrupt_sel
        db 0
        db 0x8E
        dw 0
%endrep

        dw exceptionD
        dw interrupt_sel
        db 0
        db 0x8E
        dw 0

        dw exceptionE
        dw interrupt_sel
        db 0
        db 0x8E
        dw 0

	;interrupts 0fh - 01fh
%rep 17
        dw unhand
        dw interrupt_sel
        db 0
        db 0x8E
        dw 0
%endrep

	dw irq0		;AKA interrupt 32 = 20h
	dw interrupt_sel
	db 0
	db 08eh
	dw 0

        dw key		;irq1 AKA keyboard AKA interrupt 21h in my operating system
        dw interrupt_sel
        db 0
        db 0x8e
        dw 0

%rep 3			;irqs 2-4 = video irq, serial port2 irq, serial port1 irq AKA ints 22h-24h
	dw unhand
	dw interrupt_sel
	db 0
	db 08eh
	dw 0
%endrep

        dw primary_hd	;Going to be the hard disk interrupt = irq5 (It might be this or irq14 ????) AKA int25h
        dw interrupt_sel
        db 0
        db 0x8E
        dw 0

	dw floppy_irq6	;AKA int26h
	dw interrupt_sel
	db 0
	db 08eh
	dw 0

%rep 7		;irqs 7-13 = printer port irq, CMOS irq, and various other things that
		;probably aren't the same on all computers as they are on my laptop, but here:
		;irq9=PCI IRQ Steering,Trident CyberBlade,Lucent PCI DF Modem, and TI PCI-1211 CardBus Controller
		;irq10 = SCI IRQ for ACPI bus, irq11=ACPI IRQ holder for PCI IRQ Steering, VIA PCI Audio Controller,
		;VIA Tech 3038 PCI to USB Universal Host Controller, irq12=Synaptics PS/2 Touchpad,
		;irq13=Numeric data processor
		;AKA ints 27h-33h
        dw unhand
        dw interrupt_sel
        db 0
        db 0x8E
        dw 0
%endrep

	;IRQ14 (On my laptop) = Primary IDE controller (dual fifo) & VIA BUS Master PCI IDE Controller
        dw primary_hd	;Going to be the hard disk interrupt = irq5 (It might be this or irq14 ????) AKA int34h
        dw interrupt_sel
        db 0
        db 0x8E
        dw 0

	;irq15=Secondary IDE controller (dual fifo). Also VIA Bus Master PCI IDE controller on my laptop...
	;AKA int35h
        dw primary_hd	;It's going to share interrupts with the primary one...
        dw interrupt_sel
        db 0
        db 0x8E
        dw 0