[bits 32]
;NOTE: this is included in os.asm and code32 is the offset that this segment
;       based on, but the actual os.asm starts before this segment, so to
;       get the offset from code32, you must subtract code32 from each offset.
;ALSO: exc?'s are messages from the data section of os.asm. This data section
;       is also based on code32.
;************** I N T E R R U P T   H A N D L E R S ****************

handlers:
unhand	equ	$ - handlers
        pushad
	pushfd
	cld
        mov ecx, 14
        mov esi, exc6 - code32
        mov al, blue
theloop_unhand:
        movsb
        stosb
        loop theloop_unhand

        mov al, 20h
        out 20h, al
	popfd
        popad
        iret

exception6      equ     $ - handlers
        pushad
	pushfd
	cld
        mov ecx, 14
        mov esi, exc6 - code32
        mov al, 1
theloop_exc6:
        movsb
        stosb
        loop theloop_exc6

        mov al, 20h
        out 20h, al
	popfd
        popad
        iret
        
exception8      equ     $ - handlers
	push eax
        mov al, 20h			;Send the EOI command
        out 20h, al
        pop eax				;Get the old ax back
        iret

exceptionA      equ     $ - handlers
        pushad
	pushfd
	cld
        mov ecx, 14
        mov esi, excA - code32
        mov al, 1
theloop_excA:
        movsb
        stosb
        loop theloop_excA

        mov al, 20h
        out 20h, al
	popfd
        popad
        iret
        
exceptionD      equ     $ - handlers
        pushad
	pushfd
	cld
        mov ecx, 14
        mov esi, excD - code32
        mov al, 1
theloop_excD:
        movsb
        stosb
        loop theloop_excD

        pop esi
        pop ax
        mov ds, ax
        mov ecx, 5
        rep movsb

        mov al, 20h
        out 20h, al
	popfd
        popad
        iret

exceptionE	equ	$ - handlers	;This exception is called when there is an error with an instruction. It currently
					;does nothing but restart. But when it comes time to add on it will be nice to know
					;that the return pointer on the stack points to the instruction with the error.
	push eax
	mov al, 20h
        out 20h, al
        pop eax
	call sys_restart_csel:0
        iret

;********************** IRQ0 = timer = int20h***********************
irq0	equ	$ - handlers
	push ebx
	mov ebx, esp
	push eax
	push fs

	mov ax, shared_data_sel
	mov fs, ax

	inc dword [fs:num_irq0s]
	
	test word [fs:sys_int_mask], 0100h	;See if exc8 is being used by the processor clocking routine...
	jz irq0_regular_routine
	
	;If it gets to this point, the cpu clocking procedure or a similar one must be in progress...
	add dword [ss:ebx + 4], 8	;after eax and 32bit fs have been pushed, eip of return pointer will be at esp + 8
			;increment eip by 6 so that it skips ahead in the code. This is necessary so additional instructions
			;like cmp's don't need to be added (these will complicate the necessity of keeping track of the
			;# of cycles different processors need for different instructions. INC and JMP instructions are
			;both only 1 cycle instructions and they are the only ones used.
	jmp irq0_finishup	

irq0_regular_routine:
			;for now, just finishup
irq0_finishup:
	pop fs
        mov al, 20h			;Send the EOI command
        out 20h, al
        pop eax				;Get the old ax back
	pop ebx
        iret

;************************* IRQ1 = keyboard = int21h ****************************
key     equ     $ - handlers
        ;mov al, 0aeh     program must do this to enable keyboard to call
        ;out 64h, al      interrupt 9. It must also make a loop to catch the
        ;                 key(s) it is waiting for. The int stores the ascii
        ;                 byte at es:di if dx = 1 and increments di. It also
        ;                 returns the ascii value in al and the scan code in
        ;                 ah. Value of bx is unreliable.
        ;mov al, 0adh     and this to disable it from being called
        ;out 64h, al

        lshift  equ     42
        rshift  equ     54
        ctrl    equ     29
        alt     equ     56
        caps    equ     58
	del	equ	83
	num	equ	69
	scroll	equ	70

	setctrlmask	equ	080h	;10000000xb	;to save the state of these keys to set, do:
	clrctrlmask	equ	07fh	;01111111xb	;"or byte [fs:togglekeys], setctrlmask"
	setaltmask	equ	040h	;01000000xb	;to clear the state of ctrl in memory:
	clraltmask	equ	0bfh	;10111111xb	;"and byte [fs:togglekeys], clrctrlmask"
	setshiftmask	equ	020h	;00100000xb	;notice setting equates are prefixed with "set" and clear w/ "clr"
	clrshiftmask	equ	0dfh	;11011111xb
	setcapsmask	equ	04h	;00000100xb
	clrcapsmask	equ	0fbh	;11111011xb
	setnummask	equ	02h	;00000010xb
	clrnummask	equ	0fdh	;11111101xb
	setscrollmask	equ	01h	;00000001xb
	clrscrollmask	equ	0feh	;11111110xb

        buffersize      equ     25              ;Number of bytes long keybuffer is

        pushad
	push ds
        push es
	push fs
	mov ax, shared_data_sel
	mov fs, ax
        mov ax, linear_data_sel
        mov es, ax
	mov ax, sys_data_sel
	mov ds, ax

        in al, 60h        ;get the key scan value
        
	;*************  Special Key Checker  ***************
	cmp al, rshift + 128
        jnz not_shift_handler
	test byte [fs:togglekeys], setshiftmask
        jz not_shift_handler_but_shift    ;only accept the key release if shift is currently registered as being down.
        jmp shift_handler
not_shift_handler_but_shift:
        jmp do_nothing
not_shift_handler:
	cmp al, lshift + 128
        jnz not_shift_handler2
	test byte [fs:togglekeys], setshiftmask
        jz not_shift_handler2_but_shift
        jmp shift_handler
not_shift_handler2_but_shift:
        jmp do_nothing
not_shift_handler2:
	cmp al, ctrl + 128
        jnz not_ctrl_handler
	test byte [fs:togglekeys], setctrlmask
        jz not_ctrl_handler_but_ctrl
        jmp ctrl_handler
not_ctrl_handler_but_ctrl:
        jmp do_nothing
not_ctrl_handler:
	cmp al, alt + 128
        jnz not_alt_handler
	test byte [fs:togglekeys], setaltmask
        jz not_alt_handler_but_alt
        jmp alt_handler
not_alt_handler_but_alt:
        jmp do_nothing
not_alt_handler:

        cmp al, lshift
        jnz not_shiftdown_handler
	test byte [fs:togglekeys], setshiftmask
        jnz not_shiftdown_handler_but_shift     ;only accept a shift keypress if it is currently registered as not down
	jmp shift_handler
not_shiftdown_handler_but_shift:
        jmp do_nothing
not_shiftdown_handler:
        cmp al, rshift
        jnz not_shiftdown_handler2
	test byte [fs:togglekeys], setshiftmask
        jnz not_shiftdown_handler2_but_shift
	jmp shift_handler
not_shiftdown_handler2_but_shift:
        jmp do_nothing
not_shiftdown_handler2:
        cmp al, ctrl
        jnz not_ctrldown_handler
	test byte [fs:togglekeys], setctrlmask
        jnz not_ctrldown_handler_but_ctrl
	jmp ctrl_handler
not_ctrldown_handler_but_ctrl:
        jmp do_nothing
not_ctrldown_handler:
        cmp al, alt
        jnz not_altdown_handler
	test byte [fs:togglekeys], setaltmask
        jnz not_altdown_handler_but_alt
	jmp alt_handler
not_altdown_handler_but_alt:
        jmp do_nothing
not_altdown_handler:
        cmp al, caps
        jnz not_caps_handler
	jmp caps_handler
not_caps_handler:
	cmp al, scroll
        jnz not_scroll_handler
        jmp scroll_handler
not_scroll_handler:
	cmp al, num
	jnz not_num_handler
	jmp num_handler
not_num_handler:

	;***** If it gets to this point, it must NOT be A SPECIAL KEY...

	cmp al, 128
	jb normal_key
	jmp do_nothing	;Do nothing if it is a release of a key

normal_key:
        mov ah, al        ;store it in ah so the program can access the scan code

	test byte [fs:togglekeys], setctrlmask
	jnz ctrlpluskey
	test byte [fs:togglekeys], setaltmask
        jz not_altpluskey
        jmp altpluskey
not_altpluskey:
        test byte [fs:togglekeys], setnummask
        jnz change_to_num
past_check_normal_key:
        test byte [fs:togglekeys], setcapsmask
        jnz change_case
	test byte [fs:togglekeys], setshiftmask
	jnz change_case
		;**** Don't change case
        mov ebx, scan_to_ascii - 1 - code32   ;set address of xlat table
        xlatb
	jmp finish_up
		;**** If it goes here, Case needs to be changed
change_case:
        mov ebx, shift_scan_to_ascii - 1 - code32   ;set address of xlat table
        xlatb
        jmp finish_up

change_to_num:
        push ax         ;save just in case its not one of the num keys...
        mov edi, convert_numlock + original_offset      ;numlock equivalent
        mov ecx, 15     ;edi is an offset from 0 b/c it uses es (linear_data_sel)
num_scanning_loop:
        cmp byte [es:edi], al
        jz num_foundit
        inc edi
        inc edi
        loop num_scanning_loop

        pop ax          ;get old ax back
        jmp past_check_normal_key

num_foundit:
        inc edi
        mov al, byte [es:edi]
        pop bx          ;get the old ax off the stack 
        jmp finish_up

		;**************** Key Pressed While Ctrl Was Held Down ****************
ctrlpluskey:
	test byte [fs:togglekeys], setaltmask
	jnz ctrlplusalt
	jmp do_nothing
ctrlplusalt:
	cmp ah, del
        jnz not_ctrl_alt_del_handler
        jmp ctrl_alt_del_handler
not_ctrl_alt_del_handler:
	jmp do_nothing
		;**************** Key Pressed While Alt Was Held Down
altpluskey:
	jmp do_nothing
                ;******************  SHIFT  ********************
shift_handler:
	mov ax, clrshiftmask * 256 + setshiftmask	;get clrshiftmask in ah and setshiftmask in al
	call toggle_change
        jmp do_nothing
                ;******************  CTRL  *********************
ctrl_handler:
	mov ax, clrctrlmask * 256 + setctrlmask
	call toggle_change
        jmp do_nothing
		;******************  ALT  *********************
alt_handler:
        mov ax, clraltmask * 256 + setaltmask
	call toggle_change
        jmp do_nothing
                ;******************  CAPS LOCK  ******************
caps_handler:
	mov ax, clrcapsmask * 256 + setcapsmask
	call toggle_change
	call writeLEDs
        jmp do_nothing
                ;***************** NUM HANDLER *****************
num_handler:
        mov ax, clrnummask * 256 + setnummask
        call toggle_change
        call writeLEDs

        jmp do_nothing
                ;***************** SCROLL HANDLER ****************
scroll_handler:
        mov ax, clrscrollmask * 256 + setscrollmask
        call toggle_change
        call writeLEDs
        jmp do_nothing
		;***************** DEL w/ ctrl & alt *************
ctrl_alt_del_handler:
	mov al, 0feh	;reboot
        out 64h, al
	hlt
		;***************** TOGGLE CHANGE *****************
toggle_change:		;Takes the setmask byte as a param in al and the clrmask in ah and sets the flags accordingly
	test byte [fs:togglekeys], al
	jz turn_on
	and byte [fs:togglekeys], ah
	ret
turn_on:
	or byte [fs:togglekeys], al
	ret
		;***************** Write LEDs to Keyboard *************
writeLEDs:		;Upon starting this subroutine, I already knew a decent amount about various hardware and my
			;kernel (os.com) compiled to arount 8KB and included hard drive and floppy read/write support
			;along with a ton of other minor stuff. And yet this was the most challenging of hardware for me
			;to program so far! - the little lights! I originally had a routine that worked fine on my desktop, 
			;but upon testing it on my laptop and other comps, I realized it didn't even work on many other
			;computers! So I made another, which worked on my laptop but not on my desktop... To make a long
			;story short I attempted to copy this routine from other OS's and tried dozens of my own - all not
			;being completely successful before I finally created this one - VICTORY!!!!
	push eax
	push ecx
	cli

;	call leds_wait2write
	call sys_keyboard_csel:keyboard_wait2write

	mov al, 0edh
	out 060h, al

;	call leds_wait2write
	call sys_keyboard_csel:keyboard_wait2write
	mov al, byte [fs:togglekeys]
	and al, 7
	out 060h, al

	sti
	pop ecx
	pop eax
	ret

;leds_wait2write:
;	out 0edh, al			;This port is a delay port
;	in al, 064h			
;	test al, 1
;	jz leds_not_waiting4read
;	in al, 060h
;	mov ecx, 0fffh
;	leds_pausing1:	out 0edh, al
;			loop leds_pausing1
;	jmp leds_wait2write
;leds_not_waiting4read:
;	out 0edh, al
;	in al, 064h
;	test al, 2
;	jz leds_not_busy
;	mov ecx, 0fffh
;	leds_pausing2:	out 0edh, al
;			loop leds_pausing2
;	jmp leds_not_waiting4read
;leds_not_busy:
;	mov ecx, 0ffffh
;	pausing3:	loop pausing3
;	ret

        ;****************** END SPECIAL KEY HANDLERS *************
finish_up:
        cmp byte [fs:numkeys], buffersize ;If buffer is full already, just exit
        jae do_nothing

        inc word [fs:numkeys]
        mov si, word [fs:keybaseptr]
        mov byte [fs:si + keyscanbuffer], ah
        mov byte [fs:si + keybuffer], al
        cmp word [fs:keybaseptr], 24    ;See if in last place of keybuffer
        je wrap_around_buffer
        inc word [fs:keybaseptr]
        jmp do_nothing                  ;Did the stuff, now we can leave
wrap_around_buffer:
        mov word [fs:keybaseptr], 0

do_nothing:
        mov al, 20h          ;Because it is a hardware int, this has to tell
        out 20h, al          ;computer it is end of interrupt.
	pop fs
        pop es
	pop ds
        popad
	sti
        iret

;**** REGULAR ****
scan_to_ascii:
;scans:  1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25
db      27,49,50,51,52,53,54,55,56,57,48,45,61, 8, 9,113,119,101,114,116,121,117,105,111,112
;scans: 26,27,28,29,30, 31, 32, 33, 34, 35, 36, 37, 38,39,40,41,42,43, 44, 45,46, 47,48, 49, 50 
db      91,93,13, 0,97,115,100,102,103,104,106,107,108,59,39,96, 0,92,122,120,99,118,98,110,109
                 ;^ctrl                                left shift^
;scans: 51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68
db      44,46,47, 0, 0, 0,32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
;      right shift^  ^  ^alt  ^  ^-these are F1 through F10-^
; ?print screen or *?^        ^caps lock
db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
;these 15 0's are the following: Numlock, Scroll Lock, Home or 7, Up or 8,
;Page Up or 9, Gray -, Left or 4, Center or 5, Right or 6, Gray +, End or 1,
;Down or 2, Page Down or 3, Ins or 0, Del or .
TIMES  49  db  0;reserve 49 bytes between 83 and 133 for unused scan codes
db      133,134  ;F11 and F12
db        0,  0
TIMES  121  db  0   ; cover to end = 255

;**** SHIFTED SCAN TO ASCII ****
shift_scan_to_ascii:
;scans:  1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25
db      27,33,64,35,36,37,94,38,42,40,41,95,43, 8, 9,81,87,69,82,84,89,85,73,79,80
;scans:  26, 27,28,29,30,31,32,33,34,35,36,37,38,39,40, 41,42, 43,44,45,46,47,48,49,50 
db      123,125,13, 0,65,83,68,70,71,72,74,75,76,58,34,126, 0,124,90,88,67,86,66,78,77
                   ;^ctrl                         left shift^
;scans: 51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68
db      60,62,63, 0, 0, 0,32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
;      right shift^  ^  ^alt  ^  ^-these are F1 through F10-^
; ?print screen or *?^        ^caps lock
db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
;these 15 0's are the following: Numlock, Scroll Lock, Home or 7, Up or 8,
;Page Up or 9, Gray -, Left or 4, Center or 5, Right or 6, Gray +, End or 1,
;Down or 2, Page Down or 3, Ins or 0, Del or .
TIMES  49  db  0  ;reserve 49 bytes between 83 and 133 for unused scan codes
db      133,134  ;F11 and F12
db        0,  0
TIMES  121  db  0   ; cover to end = 255
;!!! For a more detailed scan to ascii chart, view c:\assembly\progs\cool\source\keyboard.asm
;****** Convert a char into its numlock char *****
convert_numlock         db      "G7H8I97*K4L5M6J-O1P2Q3N+R0S.5/"
        ;When numlock is down, keyboard seems to automatically alter keys, so
        ;we'll make a table for converting. To use this compare the given
        ;char with every other char: G, H, etc. and when you find it, the
        ;translated char is the next one: 7, 8, etc. respectively...
;******************** END OF IRQ1 keyboard HANDLER *****************

;**************** IRQ6 = floppy IRQ = int 26h *****************
floppy_irq6		equ	$ - handlers
	push eax
	push fs
	mov ax, shared_data_sel
	mov fs, ax

	and byte [fs:fd_command], 0
	jmp floppy_irq6_done

floppy_irq6_done:
        mov al, 20h
        out 20h, al
	pop fs
        pop eax
        iret

;*************** Hard Disk: my irq14 = int2eh *************************
primary_hd	equ	$ - handlers	;What the heck... Primary will shared with secondary...
	push eax
	mov al, 20h
	out 0a0h, al	;end of interrupt command to second programmable interrupt controller (first would be out 020h, al)
	pop eax
	iret
end_handlers: