;All GDT entries have the equate "$ - gdt_start". This is because when you
;subtract the current offset($) from the beginning of the table, you get
;the number of bytes the selector is from the beginning of the table. This
;is what is used to put into a segment selector register, thus making it
;easy to do a command like: "mov ds, sys_data_sel".

;Changing the 09ah's in code segments offset 6 to 09eh will make them
;conforming: Is this necessary to call from a lower privelege code seg?
;Also, consider changing the code segments to non-readable.

gdt_start:      dw      0       ;**** #1
		dw	0
                TIMES 4 db      0
        ;**** #2
gdt_image       equ     $ - gdt_start
        dw      0ffffh		;segment length = 64k = max (not filled yet, but has the ability to be filled.)
        dw      original_offset + gdt_start
        db      0
        db      092h		;=10010010xb=present,DPL=00,type:application,not exe, not expand down,writeable,not accessed
        db      040h		;=01000000xb=not len x 4096, default op 32bit, 00; bits19-16 seg len = 0
        db      0
        ;**** #3
idt_image	equ	$ - gdt_start
	dw	0ffffh
	dw	original_offset + idt_start
	db	0
	db	092h
	db	040h
	db	0
	;**** #4
ldt_image	equ	$ - shared_data
	dw	0		;This will be dynamically created...
	dw	0
	db	0
	db	0
	db	0
	db	0
	;**** #5
linear_data_sel	equ	$ - gdt_start
        dw      0ffffh ;limit
	dw	0	;low word base
	db	0	;low byte of high word base
        db      092h   ;seg type and access flags
        db      0cfh   ;flags, high nibble limit
	db	0	;base 31:24
        ;**** #6
interrupt_sel   equ     $ - gdt_start
        dw      end_handlers - handlers - 1
        dw      original_offset + handlers
        db      0
        db      09eh		;=10011110xb=present,DPL 00, type:application,exe,conforming,writeable,not accessed
        db      040h		;not granular, 32bit, 00 in the "Available for System" spot - what???
        db      0
        ;**** #7
stack_sel	equ	$ - gdt_start
        dw      stack_end - the_stack - 1
        dw      original_offset + the_stack
	db	0
        db      092h		
        db      0c0h
	db	0
        ;**** #8
vga_a0000h_sel  equ     $ - gdt_start
        dw      0ffffh
        dw      0
        db      0ah     ;low byte of high word: 0ah && 0000 = 0a0000h
        db      0f2h	;set to a DPL 3 so that programs can write to it...
        db      0
        db      0
        ;**** #9
vga_b0000h_sel  equ     $ - gdt_start
        dw      0ffffh
        dw      0
        db      0bh
        db      0f2h
        db      0
        db      0
        ;**** #10
vga_b8000h_sel  equ     $ - gdt_start
        dw      32767   ; = 7fffh?
        dw      08000h
        db      0bh
        db      0f2h
        db      0
        db      0
        ;**** #11
sys_code_sel	equ	$ - gdt_start
        dw      0ffffh
	dw	original_offset + code32
	db	0
        db      09ah
        db      0cfh
	db	0
        ;**** #12
sys_data_sel	equ	$ - gdt_start
        dw      0ffffh
	dw	original_offset + code32
	db	0
        db      092h
        db      0cfh
	db	0
        ;**** #13
shared_data_sel equ     $ - gdt_start
        dw      1024
        dw      original_offset + shared_data
        db      0
        db      092h
        db      040h
        db      0
	;**** #14
shared_readonly_sel	equ	$ - gdt_start
	dw	1024
	dw	original_offset + shared_data
	db	0
	db	0f0h	;DPL 11 & read-only
	db	040h
	db	0
	;**** #15
mem_data_sel	equ	$ - gdt_start
	dw	0ffffh			;(8192 descriptors/table * 2 tables) * 4 bytes each - 1 (limit = # + 1) = 65535 = 0ffffh
	dw	original_offset + gdt_start	;Put right after the GDT (leave enough room to fill GDT)
	db	1	;= 1 x 65536 = 10000h (added to offset word above = original_offset + gdt_start + 010000h)
	db	092h
	db	040h
	db	0
	;**** #16
gdt_free_sel	equ	$ - gdt_start	;As segments are deallocated, we want to be able to reuse their place in the GDT.
	dw	07fffh				;This segment is simply a list of segment selectors that are no longer being used.
	dw	original_offset + gdt_start	;It's size = 8192 descriptors * 2 bytes per selector = 04000h.
	db	2	;<- low byte high word base	;But because there is no entry for the # selectors here, it
	db	092h					;must be ended with a zero and therefore should have the whole segment
	db	040h					;initialized to 0's
	db	0
	;**** #17
sys_print_csel	equ	$ - gdt_start
	dw	end_print - print
	dw	original_offset + print
	db	0
	db	09ah
	db	040h
	db	0
	;**** #18
sys_cls_csel	equ	$ - gdt_start
	dw	end_cls - cls
	dw	original_offset + cls
	db	0
	db	9ah
	db	040h
	db	0
	;**** #19
sys_setchar_edi_csel	equ	$ - gdt_start
	dw	end_setchar_edi - setchar_edi
	dw	original_offset + setchar_edi
	db	0
	db	09ah
	db	040h
	db	0
	;**** #20
sys_cursor_csel		equ	$ - gdt_start
	dw	end_cursor - cursor
	dw	original_offset + cursor
	db	0
	db	9ah
	db	040h
	db	0
	;**** #21
sys_checkcoords_csel	equ	$ - gdt_start
	dw	end_checkcoords - checkcoords
	dw	original_offset + checkcoords
	db	0
	db	09ah
	db	040h
	db	0
	;**** #22
sys_hdread_csel	equ	$ - gdt_start
	dw	end_hdread - hdread
	dw	original_offset + hdread
	db	0
	db	9ah
	db	040h
	db	0
	;**** #23
sys_hdinfo_csel	equ	$ - gdt_start
	dw	end_hdinfo - hdinfo
	dw	original_offset + hdinfo
	db	0
	db	9ah
	db	040h
	db	0
	;**** #24
sys_hdinfo_dsel	equ	$ - gdt_start
	dw	end_hdinfo_data - hdinfo_data
	dw	original_offset + hdinfo_data
	db	0
	db	0f2h	;present,DPL=3,AppDesc, not: executable,expand down, write, accessed
	db	040h	;not granular x 4096, default op size 32bit
	db	0
	;**** #25
sys_fd_rw_csel	equ	$ - gdt_start
	dw	end_fd_rw - fd_rw
	dw	original_offset + fd_rw
	db	0
	db	09ah
	db	040h
	db	0
	;**** #26
sys_dma_xfer_csel	equ	$ - gdt_start
	dw	end_dma_xfer - dma_xfer
	dw	original_offset + dma_xfer
	db	0
	db	09ah
	db	040h
	db	0
	;**** #27
sys_mem_count_csel	equ	$ - gdt_start
	dw	end_mem_count - mem_count
	dw	original_offset + mem_count
	db	0
	db	09ah
	db	040h
	db	0
	;**** #28
sys_delay_csel		equ	$ - gdt_start
	dw	end_delay - delay
	dw	original_offset + delay
	db	0
	db	09ah
	db	040h
	db	0
	;**** #29
sys_restart_csel	equ	$ - gdt_start
	dw	end_restart - restart
	dw	original_offset + restart
	db	0
	db	9ah
	db	040h
	db	0
	;**** #30
sys_alloc_mem_csel	equ	$ - gdt_start
	dw	end_alloc_mem - alloc_mem
	dw	original_offset + alloc_mem
	db	0
	db	09ah
	db	040h
	db	0
	;**** #31
sys_dealloc_mem_csel	equ	$ - gdt_start
	dw	end_dealloc_mem - dealloc_mem
	dw	original_offset + dealloc_mem
	db	0
	db	09ah
	db	040h
	db	0
	;**** #32
sys_create_sel_csel	equ	$ - gdt_start
	dw	end_create_sel - create_sel
	dw	original_offset + create_sel
	db	0
	db	09ah
	db	040h
	db	0
	;**** #33
sys_authorize_csel	equ	$ - gdt_start
	dw	end_authorize - authorize
	dw	original_offset + authorize
	db	0
	db	09ah
	db	040h
	db	0
	;**** #34
sys_keyboard_csel	equ	$ - gdt_start
	dw	end_keyboard - keyboard
	dw	original_offset + keyboard
	db	0
	db	09ah
	db	040h
	db	0
	;**** #35
sys_create_file_csel	equ	$ - gdt_start
	dw	end_create_file - create_file
	dw	original_offset + create_file
	db	0
	db	09ah
	db	040h
	db	0
	;**** #36
sys_mount_dev_csel	equ	$ - gdt_start
	dw	end_mount_dev - mount_dev
	dw	original_offset + mount_dev
	db	0
	db	09ah
	db	040h
	db	0
	;**** #37
sys_LBA_CHS_csel	equ	$ - gdt_start
	dw	end_LBA_CHS - LBA_CHS
	dw	original_offset + LBA_CHS
	db	0
	db	09ah
	db	40h
	db	0
	;**** #38
sys_getuser_csel	equ	$ - gdt_start
	dw	end_getuser - getuser
	dw	original_offset + getuser
	db	0
	db	09ah
	db	040h
	db	0
	;**** #39
sys_get_mnt_type_csel	equ	$ - gdt_start
	dw	end_get_mnt_type - get_mnt_type
	dw	original_offset + get_mnt_type
	db	0
	db	09ah
	db	040h
	db	0
	;**** #40
sys_mount_net_csel	equ	$ - gdt_start
	dw	end_mount_net - mount_net
	dw	original_offset + mount_net
	db	0
	db	09ah
	db	040h
	db	0
	;**** #41
sys_md_nextentry_csel	equ	$ - gdt_start
	dw	end_md_nextentry - md_nextentry
	dw	original_offset + md_nextentry
	db	0
	db	09ah
	db	40h
	db	0
	;**** #42
sys_ID_partition_csel	equ	$ - gdt_start
	dw	end_ID_partition - ID_partition
	dw	original_offset + ID_partition
	db	0
	db	9ah
	db	40h
	db	0

        ;********* L I B R A R Y   C A L L S *********
	;**** #43
lib_bin_dec_csel	equ	$ - gdt_start
	dw	end_bin_dec - bin_dec
	dw	original_offset + bin_dec
	db	0
	db	09ah
	db	040h
	db	0
	;**** #44
lib_instr_csel  equ     $ - gdt_start
        dw      end_instr - instr
        dw      original_offset + instr
        db      0
        db      09ah	; Will be DPL 11 once a stack for ring3 is set up
        db      040h
        db      0
	;**** #45
lib_bin_hex_csel	equ	$ - gdt_start
	dw	end_bin_hex - bin_hex
	dw	original_offset + bin_hex
	db	0
	db	09ah
	db	040h
	db	0
	;**** #46
lib_dec_bin_csel	equ	$ - gdt_start
	dw	end_dec_bin - dec_bin
	dw	original_offset + dec_bin
	db	0
	db	09ah
	db	040h
	db	0
	;**** #47
lib_hex_bin_csel	equ	$ - gdt_start
	dw	end_hex_bin - hex_bin
	dw	original_offset + hex_bin
	db	0
	db	09ah
	db	040h
	db	0
	;**** #48
lib_getchar_csel	equ	$ - gdt_start
	dw	end_getchar - getchar
	dw	original_offset + getchar
	db	0
	db	09ah
	db	040h
	db	0
	;**** #49
lib_putchar_csel	equ	$ - gdt_start
	dw	end_putchar - putchar
	dw	original_offset + putchar
	db	0
	db	09ah
	db	040h
	db	0
gdt_end: