;******************* PRINT SYSTEM CALL ******************
print:			;This subroutine takes ds:esi -> asciiz message, & al = attribute & prints to screen @ current
			;ycoord & xcoord in shared data segment. All registers are returned unchanged.
	pushad
	pushfd
	push es
	push fs
	cld

	mov bl, al		;Save attribute

	mov ax, shared_data_sel
	mov fs, ax
	mov ax, linear_data_sel
	mov es, ax

	mov eax, dword [fs:mode_type]
	cmp eax, "text"
	jz print_outer_loop		;not a text mode... *** Soon replace w/ a graphics routine ***
	jmp print_err1

print_outer_loop:
	call sys_checkcoords_csel:0
	call sys_setchar_edi_csel:0
	mov ecx, dword [fs:screen_width]
	dec ecx
	sub ecx, dword [fs:xcoord]
	mov al, bl
print_loop:
	cmp byte [esi], 0
	jz done_printing
	cmp byte [esi], 13		;Check for carriage return
	jz print_cr
	cmp byte [esi], 10		;Check for line feed
	jnz print_not_lf
		inc esi
		mov dword [fs:xcoord], 0
		jmp print_outer_loop
print_not_lf:
	cmp byte [esi], 9		;Check for tab
	jnz print_not_tab
		inc esi
		cmp ecx, dword [fs:tab_length]		;If not enough room left, print a carriage return
		jb print_cr
		mov ecx, dword [fs:tab_length]
		add dword [fs:xcoord], ecx
		shl eax, 8			;Shift attribute to high byte
		mov al, 020h			;Put a space in the low byte
		rep stosw			;Print [fs:tab_length] spaces
		jmp print_outer_loop
print_not_tab:
	movsb
	stosb
	inc dword [fs:xcoord]
	loop print_loop

	mov dword [fs:xcoord], 0
	jmp print_over_cr
print_cr:
	inc esi
print_over_cr:
	inc dword [fs:ycoord]
	jmp print_outer_loop

done_printing:
	call sys_cursor_csel:0
	pop fs
	pop es
	popfd
	popad
	clc
        retf
end_print:

print_err1:
	call sys_cursor_csel:0
	pop fs
	pop es
	popfd
	popad
	mov ax, 1		;Non-text mode error code = 1
	stc
        retf
;************** END OF PRINT SYSTEM CALL *****************

;**************** CLEAR SCREEN CALL **********************
cls:				;Clears the current screen if in text mode.
	pushad
	pushfd		;push flags so direction pointer is restored
	push es
	push fs
	cld			;Don't want to have the rep command go backwards...
	mov ax, shared_data_sel
	mov fs, ax
	mov ax, linear_data_sel
	mov es, ax
	mov eax, dword [fs:mode_type]
	cmp eax, "text"
	jnz cls_err1                    ;not a text mode... *** Soon replace w/ a graphics routine ***

	mov dword [fs:xcoord], 0
	mov dword [fs:ycoord], 0
	mov ecx, dword [fs:screen_height]
	mov ah, byte [fs:screen_attribute] ;screen filled with current attrib
	mov al, 20h     ;screen will be filled with spaces
	;This ax word will be used to fill the screen...
	mov edi, dword [fs:video_offset]
cls_outer_loop:
	push ecx
	mov ecx, dword [fs:screen_width]
	rep stosw
	pop ecx
	loop cls_outer_loop

	pop fs
	pop es
	popfd
	popad
	clc
	retf

cls_err1:
	pop fs
	pop es
	popfd
	popad
	mov ax, 1		;Non-text mode error code = 1
	stc
	retf
end_cls:

;****************** Put physical location of next screen char into edi ********************
setchar_edi:		;in: nothing
				;out: edi = physical location of next screen char in memory
	push eax
	push edx	;save so it doesn't get overwritten with the remainder
	push fs

	mov ax, shared_data_sel
	mov fs, ax

	mov eax, dword [fs:screen_width]
	mul dword [fs:ycoord]
	add eax, dword [fs:xcoord]
	shl eax, 1
	add eax, dword [fs:video_offset]
	mov edi, eax

	pop fs
	pop edx
	pop eax
	retf
end_setchar_edi:

;************************** Place Cursor Subroutine *************************
cursor:		;Places cursor at coordinates found at shared_data_sel:xcoord and ycoord
	push eax	;Returns carry flag set if error & error code in al
	push ecx        ;Else, returns al = 0 and carry cleared
	push edx
	push edi
	pushfd		;Push eflags to recover from cli - when restored interrupt enable flag will be restored
	push es
	push fs

	mov ax, shared_data_sel
	mov fs, ax
	mov ax, linear_data_sel
	mov es, ax

	cmp dword [fs:mode_type], "text"
	jz not_cursor_err1
	jmp cursor_err1

not_cursor_err1:
        cli                     ;Critical region, no ints now.
        ; Wait until the 8042 is done processing the current command.
        mov ecx, 65536          ;Allow 65,536 times thru loop.
Wait4Empty:     in      al, 64h         ;Read keyboard status register.
                test    al, 2           ;Input buffer full?
                loopnz  Wait4Empty      ;If so, wait until empty.

; Okay, send the command to the 8042:
	mov al, 0adh
	out     64h, al

	mov eax, dword [fs:ycoord]
	mov edx, dword [fs:screen_width]
	mul edx
	add eax, dword [fs:xcoord]      ;will give coord for next char, so don't
	push eax                        ;       need to increment it.

	shl eax, 1      ;multiply by two to account for attribute bytes
	inc eax
	mov edi, dword [fs:video_offset]
	add edi, eax    ;add offset of attribute from within the video seg
	mov al, byte [fs:screen_attribute]
	and al, 0fh     ;AND with the color to avoid other attribute stuff
	mov byte [es:edi], al   ;write attribute

	; Wait until the 8042 is done processing the current command.
	mov ecx, 65536          ;Allow 65,536 times thru loop.
Wait4Empty2:     in      al, 64h         ;Read keyboard status register.
                test    al, 2           ;Input buffer full?
                loopnz  Wait4Empty2      ;If so, wait until empty.

; Okay, send the command to the 8042:

	mov dx, 03d4h	;command port for cursor
	mov al, 0fh
	out dx, al	;command to write low byte of cursor location (cursor location is straight through: no X and Y)
	inc dx		;port to write value of low byte to
	pop eax         ;pop coordinate value
	out dx, al
	mov al, 0eh	;command to write high byte
	dec dx		;go back to command port
	out dx, al
	inc dx
	mov al, ah
	out dx, al

        ; Wait until the 8042 is done processing the current command.
        mov ecx, 65536          ;Allow 65,536 times thru loop.
Wait4Empty3:     in      al, 64h         ;Read keyboard status register.
                test    al, 2           ;Input buffer full?
                loopnz  Wait4Empty3      ;If so, wait until empty.

; Okay, send the command to the 8042:
        mov al, 0aeh
        out     64h, al

	pop fs
	pop es
	popfd
	pop edi
	pop edx
	pop ecx
	pop eax
	xor al, al
	clc
	retf
	
cursor_err1:
	pop fs
	pop es
	popfd
	pop edi
	pop edx
	pop ecx
	pop eax
	mov ax, 1
	stc
	retf

end_cursor:

;***************** Checks the xcoord and ycoord in shared_data_sel ***********************
checkcoords:		;in: nothing
	push eax		;out: valid x and y coords in the shared_data_sel and screen adjusted if necessary
	push edx		;save so it doesn't get overwritten as the remainder in mul opcodes
	push fs

	mov ax, shared_data_sel
	mov fs, ax

	mov eax, dword [fs:xcoord]
	cmp eax, dword [fs:screen_width]
	jb checkcoords_check_y		;If xcoord was OK, check ycoord

	inc dword [fs:ycoord]		;If xcoord wasn't OK, increment ycoord, set xcoord to 0, and check ycoord
	mov dword [fs:xcoord], 0
checkcoords_check_y:
	mov eax, dword [fs:ycoord]
	cmp eax, dword [fs:screen_height]
	jb checkcoords_done		;If ycoord is OK, we're done

	push ecx				;If ycoord wasn't OK we have to scroll down.
	push esi				;This does this by copying the second row on the screen to the first, the
	push edi				;third to the second and so on...
	push ds
	push es
	pushfd
	cld
	mov ax, linear_data_sel
	mov ds, ax
	mov es, ax
	mov esi, dword [fs:video_offset]
	mov edi, esi
	mov ecx, dword [fs:screen_width]
	shl ecx, 1
	add esi, ecx				;Add 1 row to the source character (one row ahead of the destination)
	mov eax, dword [fs:screen_height]
	dec eax
	mul ecx					;There is more than one row to move, so multiply by number of rows
	mov ecx, eax				;Get this number into the number of times it will loop
	rep movsb
	mov ah, byte [fs:screen_attribute]
	mov al, " "
	mov ecx, dword [fs:screen_width]
	rep stosw
	popfd
	pop es
	pop ds
	pop edi
	pop esi
	pop ecx
	mov eax, dword [fs:screen_height]
	dec eax
	mov dword [fs:ycoord], eax

checkcoords_done:
	pop fs
	pop edx
	pop eax
	retf
end_checkcoords:
