;*********************** Count amount of memory *************************
mem_count:		;Returns # of kbytes in ecx
	push eax
	push ebx
	push esi
	pushfd		;Push flags so this can restore the interrupt enable flag to what it was before cli opcode
	push es
	cli

	mov cx, linear_data_sel
	mov es, cx
;	mov esi, 1048572		;end of 1st mb location
	mov esi, 2097148

	mov eax, cr0
	push eax			;save a copy of cr0
	wbinvd				;write back and invalidate the cache
	mov eax, 060000001h
	mov cr0, eax			;=0110 ... 0001xb = cache disable, no writeback, Protected mode

	mov ecx, 1			;start amount of mem at 1 because it starts checking at the end of the second MB
mem_counting:
	mov eax, dword [es:esi]		;save the bytes here
	mov ebx, "tESt"
	mov dword [es:esi], ebx		;write to mem
	cmp dword [es:esi], ebx		;check to see that write was accurate
	jnz mem_done_counting		;If its not accurate, exit b/c we are done
	mov dword [es:esi], eax		;restore old value here
	inc ecx				;increment the number of mbytes
	add esi, 1048576		;add a mbyte
	jmp mem_counting

mem_done_counting:
	mov dword [es:esi], eax		;now that we're done, restore the final memory spot used.

	pop eax
	mov cr0, eax

	pop es
	popfd
	pop esi
	pop ebx
	pop eax
	clc
	retf
end_mem_count:

;************************ Allocate memory for program/data seg ***************************
	;This is fairly complicated stuff. Read "MemMgr.txt" before trying to understand the idea behind what's going on
alloc_mem:		;Allocate memory and initiate task if executable
			;in:	ecx = # bytes desired
			;	ah  bit 7 = 0
			;	    bit 6 = 32-bit if set 
			;	    bit 5 = 0
			;	    bit 4 = LDT if set, GDT if clear
			;	    bit 3 = 1 if a twin segment is to be made. (MAKE SURE TO SEE MEMMGR.txt to get this right!!!)
			;	    bit 2 = IF a twin segment is being made this is the conforming bit. Else, set to 0.
			;	    bits 1-0 = 0
			;	al  bit 7 = 0
			;	    bits 6-5 = Requested Privelege Level (RPL)
			;	    bits 4-3: 10=regular data seg, 11=executable seg, 01=system seg (TSS, etc.)
			;	    bit 2 = if set: expandable downward if data, conforming if executable
			;	    bits 1 = if set: writable if data, readable if code
			;	    bit 0 = 0
			;out:	Not twin: segment selector in ax (high word eax undefined), # bytes allocated in ecx
			;	If twin: data selector in dx and code selector in ax (high words eax,edx undefined), ecx
			;		 will still equal the # bytes allocated
			;	If ERROR: carry set, ah = error code, al = sub error code (if applicable), ebx and ecx
			;		  will be returned invalid (unpredictable)
	pushfd
;	push ebx	;ebx will return the base address
	push esi
	push edi
	push ds
	push es
	push fs
	push edx			;It is important that this remains last!!!! Because of reasons to do with making
					;twin segments with sys_create_sel_csel

	test ax, 0a381h			;All of these bits must be 0
	jz alloc_mem_valid
	jmp alloc_mem_err3		;An invalid ax value was passed to the procedure
alloc_mem_valid:

	test al, 040h			;If bit6 isn't set, the RPL is 00 or 01 so check authorization for high privelege
	jnz alloc_mem_no_authorize
	call sys_authorize_csel:0	;Calling procedure is responsible for putting certain data into its
	jnc alloc_mem_no_authorize
	jmp alloc_mem_err1
alloc_mem_no_authorize: 	

	mov bx, mem_data_sel
	mov ds, bx
	mov es, bx
	mov bx, shared_data_sel
	mov fs, bx

	dec ecx				;Decrement ecx while deciding if granular b/c limit will be size - 1
	cmp ecx, 0100000h		;If there is 1 MB or less (max 20-bit), continue normal. Otherwise, shift ecx 12
	jb alloc_mem_not_granular	;and set the granularity bit for calling create_sel_csel.
	or ah, 080h		;Set granularity bit for call to create_sel_csel
	shr ecx, 12		;shift to the left 12 to account for granularity for the call
	push eax		;push the values that are going to the call
	push ecx
	shl ecx, 12		;Now restore the values for the search for memory allocation.
	or ecx, 0fffh		;Set the low 12 bits because when granular the processor will assume these are 1's
	jmp alloc_mem_look_for_room	;Now look to allocate the memory
alloc_mem_not_granular:
	and ah, 07fh		;If not granular, clear granularity bit
	push eax		;Save the eax and ecx that will be sent to sys_create_sel
	push ecx
	;***** Find out if there is enough free memory
alloc_mem_look_for_room:
	mov eax, ecx			;Get requested limit into eax for comparing soon
	inc eax				;Convert limit to a length.
	mov ecx, dword [ds:0]		;Get # mem_data entries into ecx
	dec ecx				;Subtract 1 from ecx b/c procedure compares with next entry and last one will have
					;no next entry.
	mov esi, 8		;Offset of 1st entry's end point
	mov edi, 12		;Offset of 2nd entry
alloc_mem_looking:	;eax will hold requested memory amount, ebx holds the pointer to the entry that has had the largest space
			;edx will be used to perform calculations on the amounts of memory, esi will hold current offset into
			;mem_data_sel
	mov edx, dword [es:edi]
	sub edx, dword [ds:esi]
	cmp edx, eax
	jae alloc_mem_found_one
	add esi, 8	;Point to next entry's endpoint
	add edi, 8	;Point to next next entry's offset
	loop alloc_mem_looking
		;**** If it ends the loop, there is no room between entries so we must look for room at the end of all the
		;	segments in memory
	mov edx, dword [fs:memory_count]
	shl edx, 20	;Convert #MB to # bytes
	sub edx, dword [ds:esi]
	cmp edx, eax
	jae alloc_mem_write_entry	;If there was enough, continue normally, if not try to swap.

	;;;;;;;;;;; need SWAP code here instead of hang code !*!*!*!*!*!*!*!*!*!*!*!*!*!
	;NOTE: When this code is replaced with valid code, make sure to check bits in al and ah if a call to sys_create_sel
	;	is made. EX: clear bit7 of al to indicate not present in mem.
	mov ax, shared_data_sel
	mov ds, ax
	mov esi, need_swap
	mov al, brightwhite
	call sys_print_csel:0
	needswap:	jmp needswap
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

alloc_mem_found_one:		;When (if) it gets to here, edi will point to place to insert another entry and ecx
				;will tell #entries that need to be moved.
	push edi		;Save the location of the new entry
	std			;We can't shift memory in normal direction because it will write over top of itself. (Back
	shl ecx, 3		; will overlap front as we progress through memory)
	add edi, ecx		;Add 8 to edi for every entry that needs to be moved
	shr ecx, 2		;Put ecx back but we need to take #entries x 2 b/c there are 2 dwords per entry, so only shift 2
	mov esi, edi		;Prepare to shift all other entries
	sub esi, 4
	add edi, 4		;Mov offset + length entry of last entry to offset + length entry of next entry (2 dwords over)
	rep movsd		;Shift all other entries
	cld
	pop edi			;Pop place where next entry will go

alloc_mem_write_entry:
	inc dword [ds:0]
	pop ecx			;Pop the ecx from before the loop
	pop eax
	push eax
	push ecx
	test ah, 080h
	jz alloc_mem_not_granular2
		shl ecx, 12
		add ecx, 01000h
alloc_mem_not_granular2:
	mov dword [fs:last_mem_alloc], edi	;Save location in mem_data_sel of last memory allocation so that if
						;call create_sel_csel:0 returns an error, the mem can be deallocated without
						;a selector...
	mov eax, dword [ds:esi]
	mov dword [es:edi], eax		;Offset of next entry will equal the limit of last entry (b/c limit was end offset + 1)
	mov ebx, eax			;Save offset of new segment for the "call sys_create_sel_csel:0"
	add eax, ecx			;Add number of bytes to get the limit.
	inc eax				;Convert limit to get the first free byte after this segment (standard in mem_data)
	mov dword [es:edi + 4], eax
	pop ecx
	pop eax				;Pop the old eax for creation of the GDT/LDT entry

	;At this point, ecx already contains limit and ebx has the base address for the segment, now adjust eax flags
	and eax, 0ffffdcfeh	;set bit7 al b/c present in mem, clear bit0 in al because it has to be 0
	or al, 080h
	pop edx			;Get original value in edx. If a twin segment is being made, create_sel will return edx
				;with the data selector. If no twin segment is being made, it will return this value of edx
	call sys_create_sel_csel:0
	push edx		;Repush this for compatibility with any present/future error handlers here
	jc emergency_dealloc	;Error in creating the segment

alloc_mem_done:
	pop edx
	pop fs
	pop es
	pop ds
	pop edi
	pop esi
	popfd
	clc
	retf
alloc_mem_err3:		;An invalid parameter was passed in ax
	mov ah, 3
	mov al, 0
	jmp alloc_mem_finisherr
alloc_mem_err1:		;Authorization to create high privelege (00 or 01) segment denied!
	mov ah, 1
	mov al, 0
	jmp alloc_mem_finisherr
alloc_mem_err2:		;Error in allocating the segment, ah will equal error code = 2. al will equal the suberror which
			;will be the error returned from create_sel. At this point, the last entry should be deallocated...
	mov ah, 2
alloc_mem_finisherr:
	pop edx
	pop fs
	pop es
	pop ds
	pop edi
	pop esi
	popfd
	stc
	retf
emergency_dealloc:	;This is used if the create_sel call returned an error. In which case, this would use the dword
			;last_mem_alloc in the shared_data_sel to deallocate the last memory location.
	mov ax, mem_data_sel
	mov es, ax
	mov eax, dword [fs:last_mem_alloc]
	push cs			;Push the return segment padded with a 0
	push word 0
	push dword emergency_return	;Push return EIP
	pushad
	push ds
	push es
	push fs
	pushfd
	jmp sys_dealloc_mem_csel:emergency_entry
emergency_return        equ     $ - alloc_mem
	mov ah, 2
	jmp alloc_mem_finisherr
end_alloc_mem:

;******************************* Deallocate memory ***************************************
dealloc_mem:		;in:	ax = selector to deallocate
			;out:	corresponding memory free & selector available for reuse
	pushad
	push ds
	push es
	push fs
	pushfd

	rol eax, 16	;Use the other word
	mov ax, shared_data_sel
	mov fs, ax
	mov ax, gdt_image
	mov ds, ax
	mov bx, gdt_free_sel
	mov es, ax

	test eax, 040000h	;remember: selector is now in high word eax, and bit2 of this high word can be tested to see
				;if the selector is in the gdt or ldt
	jz dealloc_mem_noerr1	;If it is an ldt entry then it can't deallocate it. When a task is done, its whole ldt and
	jmp dealloc_mem_err1	;entries are deallocated all at once.
dealloc_mem_noerr1:
	test eax, 020000h
	jnz dealloc_mem_nocheck
		call dealloc_mem_check_authorization
dealloc_mem_nocheck:
	shr eax, 16		;Put selector back into ax
	push eax		;Save selector
	mov ecx, 02000h		;8192 possible entries = 02000h
	cld			;Search starting from front
	xor edi, edi
	repnz scasw		;Check to see that the selector isn't already listed
	cmp ecx, 0
	jz dealloc_mem_good
		pop eax
		jmp dealloc_mem_listed	;It is already listed, so just see if it is still taking up memory
dealloc_mem_good:
	mov ecx, 02000h
	xor edi, edi
	xor eax, eax
	repnz scasw		;Search through selectors in gdt_free_sel until we come to a blank entry. Add this selector
	sub edi, 2		;Go back 1 entry b/c after it hit a 0, it added an additional word length before quitting
	pop eax
	mov word [es:edi], ax	;Put the deallocated selector into this blank spot so that the OS knows it can reuse it.

dealloc_mem_listed:
	mov bx, mem_data_sel
	mov es, bx		;We're going to try to match the selector's base address with a base address in mem_data
	and eax, 0fff8h		;only need offset into gdt_image for looking up segment's info.
	mov edi, eax
	mov ax, word [edi + 2]
	shl eax, 16
	mov al, byte [edi + 4]
	mov ah, byte [edi + 7]
	mov dword [edi], 0	;Completely clear the GDT entry
	mov dword [edi + 4], 0	
	rol eax, 16		;Now eax holds base of this selectors memory
	cmp eax, 0
	jz dealloc_mem_done	;Base address given was 0 = already deallocated/never allocated, so don't try to free up any
				;memory at memory location 0!!!!
emergency_entry equ $ - dealloc_mem	;This is an emergency entry point from alloc_mem's emergency_dealloc. It is called in a weird manor
					;if memory was allocated but there was an error creating a selector for that memory...
	mov ecx, dword [es:0]	;Number of allocated memory entries (first dword in mem_data_sel)
	cmp ecx, 2		;If only the 2 original entries are present, forget it...
	jz dealloc_mem_done
	dec ecx			;Start at first entry AFTER kernel and video/memory mapped devices entries (entry 3)
	dec ecx
	mov edi, 20		;The first entry AFTER kernel and video/memory mapped devices entries is at offset 20.
				;Then each next entry is 8 bytes later (2 dwords: 1 for base, 1 for end)
dealloc_mem_searching:
	scasd			;Compare the base from the selector with the base at the current position.
	jz dealloc_mem_foundit
	inc edi
	inc edi			;Skip over the "end" dword entries in each
	loop dealloc_mem_searching

	jmp dealloc_mem_done	;Either the segment being deallocated had a twin segment or it was already deallocated
				;NOTE: twin segments are two segments with the same base and limit but one is executable and
				;      one is data.
dealloc_mem_foundit:
	inc dword [fs:gdt_free_entries]	;Increment the # of free entries
	;Now we have to shift all entries in mem_data_sel after the dead entry to the left so that we overlap the dead entry
	; and contract the mem_data_sel
	mov esi, edi		;Have esi point to the end of the now dead entry.
	add esi, 4		;Add 4 to it so it points to the first entry after the dead one, so we can move it
	sub edi, 4		;edi pointed to the end of the now dead entry in the mem_data_sel, now point it to the beginning
	mov ecx, dword [es:0]	;get the number of allocated memory entries in the mem_data_sel
	mov ebx, esi
	shr ebx, 3		;Convert the offset of the entry after the dead entry to an entry #. Then we can subtract
				;its entry number from the number of entries to get how far it is from the end
	sub ecx, ebx		;Do that now...
	jz dealloc_mem_prettydone	;If it is 0, then we are already at the end and none need to be moved
		shl ecx, 1	;Otherwise, multiply by 2 (2 dwords/entry) and shift the number of entries over
		cld		;Clear direction pointer because the destination (edi) is less than the source, so we won't
		rep movsd	;overwrite anything

dealloc_mem_prettydone:
	dec dword [es:0]	;Decrement the number of allocated memory entries that are supposed to be in the mem_data_sel		
dealloc_mem_done:
	popfd
	clc
dealloc_mem_noflags
	pop fs
	pop es
	pop ds
	popad
	retf
dealloc_mem_err1:
	popfd
	stc
	mov al, 1
dealloc_mem_check_authorization:
	ret	
end_dealloc_mem:

;*************************** Create a Segment Selector ****************************
create_sel:		;in:	ecx = limit (an 800h byte segment will have a limit of 7ffh)
			;	ALSO NOTE: if granular, ecx equals number of bytes shifted right 12 already.
			;	Example: if size = 100fffh (1MB + 1KB) then ecx = 1 and granularity bit set.
			;	ALSO NOTE: When granular, 12 low bits are assumed to be 1's not 0's!!!!!!!
			;	ah  bit 7 = granular length if set
			;	    bit 6 = 32-bit if set 
			;	    bits 5 = 0
			;	    bit 4 = LDT if set, GDT if clear
			;	    bit 3 = 1 if a twin segment is to be made. (MAKE SURE TO SEE MEMMGR.txt to get this right!!!)
			;	    bit 2 = IF a twin segment is being made this is the conforming bit. Else, set to 0.
			;	    bits 1-0 = 0
			;	al  bit 7 = set if present in memory
			;	    bits 6-5 = Requested Privelege Level (RPL)
			;	    bits 4-3: 10=regular data seg, 11=executable seg, 01=system seg (TSS, etc.)
			;	    bit 2 = if set: expandable downward if data, conforming if executable
			;	    bits 1 = if set: writable if data, readable if code
			;	    bit 0 = 0
			;	ebx = base address
			;out:	Carry flag set if error and error code in al
			;	If no error, ax = segment selector

;NOTE: Don't push the flags because the error handlers share a set of pop instructions with the regular code. The carry flag
;	will fail to be returned correctly if flags are pushed!!!!!!!!!!
	push ecx
	push edi
	push es
	push fs
	push edx

	mov dx, shared_data_sel
	mov fs, dx

create_sel_another:
	test ah, 010h
	jz create_sel_gdt
		xor edx, edx		
		mov dx, ldt_image
		mov es, dx
		lsl edx, edx		;Load the segment limit for the current ldt
		cmp edx, 00f8h		;If it is less than 0f8h (enough room for one more, continue). 0ffh is the max. limit
					;because this leaves enough room for 254 selectors - plenty for any task (254=
					;256 - 1 for a null selector - 1 for an ldtr)
		jb create_sel_ldtnew
		jmp create_sel_err1	;LDT entries cannot be reused.
create_sel_ldtnew:
                xor edi, edi
                mov di, word [es:4]    ;This contains the limit of the current ldt (1 less than the offset of the next entry)
		inc edi			;Now it points to the offset of the next entry.
		add word [es:4], 4	;Add 4 to the limit of the ldt. NOTE:In all ldts, its 2nd entry (after the null
					;selector) will always be a copy of the ldtr and then two null bytes.
		lldt [es:4]		;Reload the ldt
		jmp create_sel_now
create_sel_gdt:
	mov dx, gdt_image
	mov es, dx
	cmp dword [fs:gdt_size], 65528		;8191 possible entries (in my OS this is max.) * 8 bytes each
	jb create_sel_dontreplace_old		;If all the entries are taken up, replace one of the old ones listed in
		jmp create_sel_replace_old	;gdt_free_sel
create_sel_dontreplace_old:
	mov edi, dword [fs:gdt_size]
	dec dword [fs:gdt_free_entries]		;Decrement number of gdt entries left to be used
	add dword [fs:gdt_size], 8
create_sel_now:
	mov word [es:edi], cx	;Low word limit
	inc edi
	inc edi
	mov word [es:edi], bx	;Low word base address
	inc edi
	inc edi
	ror ebx, 16		;Shift high word base address into bx
	mov byte [es:edi], bl	;Low byte of high word of base address
	inc edi
	push eax		;Save eax before any changes are made to it - this is just in case a twin seg has to be made
	mov byte [es:edi], al	;Segment type and miscellaneous other flags
	inc edi
	ror ecx, 16
	and cl, 0fh		;Only need low nibble cl
	and ah, 0c0h		;Only need bits 7 and 6
	or ah, cl		;Combine the bits
	mov byte [es:edi], ah	;Highes nibble of segment limit and access flags
	inc edi
	mov byte [es:edi], bh	;highest byte of base address
	sub edi, 7		;Now that edi has been incremented 7 times, subtract that to get the offset of the segment
				;into the gdt/ldt
	shr eax, 5		;Get DPL bits to low bits
	and eax, 03h
	or edi, eax		;Set these bits accordingly in edi
	mov ax, es
	cmp ax, gdt_image
	je create_sel_setbit	;If it is ldt is being added to, set bit2, otherwise, leave it clear
		or edi, 4
create_sel_setbit:
	mov eax, edi
	pop edx			;This is really popping the old eax from above about 20 lines. (edx isn't needed for
				; anything specific yet)
	clc			;No error at this point
	test dh, 8		;See if twin segment bit was set in ah
	jz create_sel_done	;If it wasn't, exit normally
		ror ebx, 16
		ror ecx, 16	;These were rolled earlier to access the high word, now put them back to the original...
		test dh, 4	;See if conforming bit was set
		jz create_sel_noconform 
			or dl, 4;Set bit2 if conforming
create_sel_noconform:
		and dl, 0fbh	;Clear bit2 if not conforming
create_sel_dotwin:		;Do twin
		and dh, 0d0h	;Make sure to clear bits 3-2 of dh so that it doesn't make another twin...
		or dl, 8	;Make sure it is executable
		mov dword [ss:esp], eax	;esp should now point to the top of the ending stack (edx), Put the data selector into
					;it...
		mov eax, edx		;Now make another segment with eax - the code segment
		jmp create_sel_another
create_sel_done:
	pop edx
	pop fs
	pop es
	pop edi
	pop ecx
	retf
create_sel_replace_old:		;Replace an old gdt entry that is no longer in use
	push eax
	push ecx
	push es
	mov ax, gdt_free_sel
	mov es, ax
	mov ecx, 02000h		;Possible 8192 entries = 2000h
	cld
	xor eax, eax
	mov edi, eax		;Compare all entries in gdt_free_sel until we get a non-zero entry.
	repz scasw		;word long entries, continue until we hit a non-zero one.
	dec edi
	dec edi			;Take back the last word increment to get the non-zero entry
	xor eax, eax
	mov eax, dword [es:edi]
	and ax, 0f8h		;Clear the low 3 bits b/c this will be the offset into gdt_image, not a selector
	mov edi, eax		;Mov it into edi to prepare to return
	pop es
	pop ecx
	pop eax
	dec dword [fs:gdt_free_entries]		;Make sure to decrement the number of gdt entries that will be available
						;after this syscall
	jmp create_sel_now
create_sel_remove_old:

create_sel_err1:			;LDT entries cannot be reused
	stc
	mov al, 1
	jmp create_sel_done
end_create_sel:

;*************************** AUTHORIZE A CODE SEGMENT FOR A HIGH PRIVELEGE ACTION *********************************
authorize:
	clc	;For now, automatically authorize
	retf
end_authorize:
