instr:          ;Takes memory at location es:esi and searches for string
                ;that matches the string at ds:edi. Number of bytes to
                ;search is set in ecx. Length of string to be searched for
                ;in edx. If bit0 of al = 1 then case doesn't matter.
                ;Returns: If found, al=0 & es:esi-->string match.
                ;       Else, al<>0.
                ;Example: To search for "poop":
                ;segment & offset of "poop" --> ds:edi, 4 --> edx (poop = 4 chars)
                ;place to search at --> es:esi, ecx=number of bytes to look through
                ;al=0 because we want case to matter.
        push eax ;<<\
        push ecx ;   \ This is for preserving only... sort of like pushad
        push edx ;   /
        push ebx ;<</
        mov bl, al      ;save al because it will be used

	add ecx, esi	;Add 
instr_scanning:
	push ecx
        mov ecx, edx
        push edi
instr_checking:
        lodsb
        cmp al, byte [ds:edi]
        jz instr_sofargood
        test bl, 1
        jz instr_not_yet        ;65-90, 97-122 are alphabet characters
        cmp al, 64
        jb instr_not_yet        ;below 65 so not alphabetic
        cmp al, 122
        ja instr_not_yet
        cmp al, 91
        jnb instr_not_uppercase
        add al, 22              ;convert to lowercase
        jmp instr_other_case
instr_not_uppercase:
        cmp al, 97
        jb instr_not_yet        ;must be < 97 but > 90, so not alphabetic.
        sub al, 22              ;convert to uppercase
instr_other_case:
        cmp al, byte [ds:edi]
        jnz instr_not_yet
instr_sofargood:
        inc edi
        loop instr_checking
        jmp instr_found_one
instr_not_yet:
	push edx	;save edx
	sub edx, ecx	;find how many characters it scanned before it determined it was not a match
	sub esi, edx	;subtract this to get the position of the first char that matched
	inc esi		;but we don't want to rescan the same char so inc by it and look for new possible matches.
	pop edx		;get edx back from before this fiasco
        pop edi
        pop ecx
	cmp esi, ecx
	jae instr_notfound	;check to see if esi has covered the whole search area (start(esi) + #(ecx)) = final
        jmp instr_scanning	;byte offset to be covered. This was determined right before instr_scanning.

instr_notfound:
        pop ebx
        pop edx
        pop ecx
        pop eax

        mov al, 1       ;not found code
        retf
instr_found_one:
	pop edi
	pop ecx

        pop ebx
        pop edx
        pop ecx
        pop eax

	sub esi, edx	;at this point, it points to the end of the string, subtract the length to get the beginning.
        xor al, al
        retf
end_instr:

;*************************** Convert Binary to Decimal String ***********************
	;Takes # in eax and converts it to a decimal string terminated with a null at es:edi
	;eax and es:edi are passed to this procedure...

	;Basic principal: The highest number possible in 32bit is 4billion some, so a max of 10 digits is possible.
	;The one's place is treated specially and the others are taken care of in the ecx=9 loop. It loops consecutively
	;comparing the number to 1 billion, then 100 million, then 10 million, etc., until it has found the place value
	;at which the number will have its most significant digit. At that point, ecx has been decremented so that it
	;gives the # of place values of the number - 1 (the one's place is treated separately) and it branches a new loop
	;with that value in ecx and it continues subtracting the largest # starting with a 1 and ending with all 0's it can.
	;As it does this, it increments the corresponding place value.

bin_dec:
	push eax
        push ecx
        push edx
        push edi

        push dword          1
        push dword         10
        push dword        100
        push dword       1000
        push dword      10000
        push dword     100000
        push dword    1000000
        push dword   10000000
        push dword  100000000

	mov ecx, 9
        mov edx, 1000000000
bin_dec_findplace:
	cmp eax, edx
        jae bin_dec_foundit
	pop edx
	loop bin_dec_findplace

	add al, "0"
        mov byte [es:edi], al
        jmp bin_dec_done

bin_dec_foundit:
        mov byte [es:edi], "0"
bin_dec_still_bigger:
	sub eax, edx
	inc byte [es:edi]
	cmp eax, edx
	jae bin_dec_still_bigger

bin_dec_another_place:
        cmp ecx, 0
        jz bin_dec_dofinal
        dec ecx

        inc edi
        mov byte [es:edi], "0"
	pop edx
	cmp eax, edx
	jb bin_dec_another_place
        jmp bin_dec_still_bigger

bin_dec_dofinal:
        add byte [es:edi], al

bin_dec_done:
        inc edi
        mov byte [es:edi], 0

        pop edi
        pop edx
        pop ecx
	pop eax
	retf
end_bin_dec:

;************************ Convert Binary to Hexadecimal String ********************
	
bin_hex:		;eax = number to convert, es:edi = string destination
	push eax
	push ecx
	push ebx

        mov ecx, 8
bin_hex_convert_loop:
        rol eax, 4	;A roll first to get the highest byte first instead of lowest byte...
        mov ebx, eax
        and bl, 0fh
        add bl, 030h    ;48 or "0"
        cmp bl, 58
        jb bin_hex_go_on        ;if below ascii 58 then is a digit 0 to 9
        add bl, 7       ;else, its a letter
bin_hex_go_on:
        mov byte [es:edi], bl
        inc edi
        loop bin_hex_convert_loop

	pop ebx
	pop ecx
	pop eax
	retf
end_bin_hex:

;************************ Convert decimal string to binary ***********************

dec_bin:	;in: ds:esi -> decimal ascii string terminated with a 0
		;	buffer must have all ascii decimal digits for accurate results (obviously)
		;out: eax = binary conversion
	push ecx
	push edx
	push ebx
	push esi

	mov ecx, 10	;maximum of 10 digits
dec_bin_find_place:
	cmp byte [ds:esi], 0
	jz dec_bin_found_place
	inc esi
	loop dec_bin_find_place

dec_bin_found_place:
	dec esi
	xchg eax, ecx
	mov ecx, 10
	sub ecx, eax
	cmp ecx, 0
	jz dec_bin_zero

	mov eax, 1	;eax will be the place value multiplier
	mov ebx, 0
	jmp dec_bin_calc_enter	;must enter after the multiply place by 10 b/c first place is 1 not 10
				;couldn't go at end of loop b/c there would be a chance of 1000000000 x 10 = 10,000,000,000
				;which would be an overflow.
dec_bin_calc_loop:
	mov edx, 10
	mul edx			;advance place value
dec_bin_calc_enter:
	mov edx, 0		;restore this to zero so the "mul ebx" isn't off
	mov dl, byte [ds:esi]
	sub dl, 48		;subtract ascii char "0"
	push eax

	mul edx			;multiply new digit by place value
	push ebx		;save what running total was
	add ebx, eax
	pop eax			;pop old running total
	cmp eax, ebx		;if total overran a gig, then the value overflowed and will be less than before
	ja dec_bin_overflow	;and we'll handle the overflow
	pop eax
	dec esi
	loop dec_bin_calc_loop
	mov eax, ebx		;eax was used as the multiplier so edx was used to keep the running total...
dec_bin_done:
	pop esi
	pop ebx
	pop edx
	pop ecx
	clc
	retf
dec_bin_zero:
	mov eax, 0
	jmp dec_bin_done
dec_bin_overflow:
	pop eax			;popped from push right before the "jo dec_bin_overflow" instruction
	mov eax, 0ffffffffh
	jmp dec_bin_done
end_dec_bin:

;************************** Convert hexadecimal string to binary # *************************

hex_bin:
	retf
end_hex_bin:

;********************************* Get a Char from User *******************************
getchar:			;Waits for a key to be pressed and returns ascii in al, scan code in ah
	push esi
	pushfd
	push fs

	mov ax, shared_data_sel
	mov fs, ax

	sti			;make sure interrupts are enabled (int status will be returned to the calling procedure
                                ;in the same state they were in upon entry b/c of the pushfd and popfd instructions)
getchar_waiting:
        cmp byte [fs:numkeys], 0
	jz getchar_waiting

	mov esi, keybuffer
	add si, word [fs:keyptr]
	mov al, byte [fs:esi]

	mov esi, keyscanbuffer
	add si, word [fs:keyptr]
	mov ah, byte [fs:esi]

        cmp word [fs:keyptr], 24        ;See if at end of buffer space
        jae getchar_wrap_around
        inc word [fs:keyptr]
        jmp getchar_nowrap
getchar_wrap_around:
        mov word [fs:keyptr], 0
getchar_nowrap:
        dec byte [fs:numkeys]

	pop fs
	popfd
	pop esi
	retf
end_getchar:

;******************************** Print a Single Character to the Screen ******************
putchar:			;in: char in al, attribute in ah
	push eax		;out: char to next spot on screen & cursor adjusted
	push ecx
	push edi
	push es
	push fs
	push eax		;save char

        mov ax, shared_data_sel
        mov fs, ax
	mov ax, linear_data_sel
	mov es, ax

	mov eax, dword [fs:mode_type]
	cmp eax, "text"
        jz not_putchar_err1       ;not a text mode... *** Soon replace w/ a graphics routine ***
        jmp putchar_err1
not_putchar_err1:			;If it got here it's a text mode

	pop eax
	cmp al, 0
        jnz putchar_notzero
                jmp putchar_done
putchar_notzero:
	cmp al, 13
        jz putchar_cr
	cmp al, 10
	jz putchar_lf
	cmp al, 9
	jz putchar_tab
	cmp al, 8
	jz putchar_bs

	call sys_setchar_edi_csel:0
	mov word [es:edi], ax
	inc dword [fs:xcoord]
	jmp putchar_done

putchar_cr:
	inc dword [fs:ycoord]
	call sys_checkcoords_csel:0
	jmp putchar_done
putchar_lf:
	mov dword [fs:xcoord], 0
	jmp putchar_done
putchar_tab:
	mov ecx, dword [fs:tab_length]
	push eax
	mov eax, dword [fs:screen_width]
	sub eax, dword [fs:xcoord]
	cmp ecx, eax
	pop eax
	jb putchar_tab_not_at_end
	mov al, 13
	call lib_putchar_csel:0
	jmp putchar_lf
putchar_tab_not_at_end:
	mov al, " "			;attribute is already int ah, now just put a space as the char
	putchar_tab_loop:
		call lib_putchar_csel:0
		loop putchar_tab_loop
	jmp putchar_done
putchar_bs:
	cmp dword [fs:xcoord], 0
	jnz putchar_not_at_end
	cmp dword [fs:ycoord], 0
	jz putchar_done
	dec dword [fs:ycoord]
	mov eax, dword [fs:screen_width]
	dec eax
	mov dword [fs:xcoord], eax
	jmp putchar_bs_done
putchar_not_at_end:
	dec dword [fs:xcoord]
putchar_bs_done:
	call sys_setchar_edi_csel:0
	mov byte [es:edi], " "

putchar_done:
	call sys_checkcoords_csel:0
	call sys_cursor_csel:0
	pop fs
	pop es
	pop edi
	pop ecx
	pop eax
	clc
	retf

putchar_err1:
	pop eax
	pop fs
	pop es
	pop edi
	pop ecx
	pop eax
	stc
	mov al, 1
	retf
end_putchar:
