;********************************* Create a File *******************************
create_file:		;in:	ds:esi -> asciiz string = mount name & directory & filename
			;		EX: "/hd0/user/usernames.inf",0
			;	FLAGS in AX:
			;		bits15-14 - If executable, these are DPL of this file's Code segments. This may
			;	     		    require a privelege check at runtime.
			;		bits13-8 = 000000xb
			;		bit7 - es:edi pointer points to a wordlist of privelege levels not usernames
			;		bit6 - User protection exists (Also see bits2&1)
			;		bit5 - file requires system encryption/decryption
			;		bit4 - file is executable
			;		bit3 = 0
			;		bit2 - If this and bit6 are set, the list in es:edi is a list of users/user
			;			priveleges that CANNOT access this file.
			;		bit1 - The es:edi list (if necessary) is a list of privelege levels, not a user# list.
			;		bit0 = 0xb
			;	IF BIT6 AX is set, es:edi -> asciiz string/wordlist (explained slightly near bits6,2&1,
			;		but in more detail in BigLink.txt and FileFrmt.txt.
	retf
end_create_file:

;*********************************** Mount Device *********************************
mount_dev:		;in:	ds:esi -> ascii string = standard device name,0,reference name,0
			;	EX: "/hd0/",0,"/MyHardDrive/",0
			;out:	device mounted
			;	IF ERROR: Carry set, error in al, device NOT mounted
	pushad
	pushfd
	push es
	push fs

	mov ax, linear_data_sel
	mov es, ax
	mov ax, shared_data_sel
	mov fs, ax
	cld

	mov dword [fs:mount_str_offset], esi
	mov byte [fs:mount_flags], 0
	;******************** Check to See that Root User isn't protecting this Device *******************
	call sys_getuser_csel:0
	mov word [fs:mount_usernum], ax
	cmp ax, 0
	jnz mount_dev_nrml_user
		;**** ANY SPECIAL CODE FOR ROOT USER CREATING A MOUNT GOES HERE...
	;*************************************

	;************* Make sure the Mount Device Exists/Is supported and Decide What Type of Entry to Make **************
		;If this device hasn't been mounted in some way yet, it requires a long entry, otherwise the new mount
		;will be a small one so it can share such things as the directory listing (if present) to save tons of space.
mount_dev_nrml_user:
	call sys_get_mnt_type_csel:0	;Returns al=0 if make a long entry, al=1 if make a short entry, carry if make none
	jnc mount_dev_valid
		mov byte [fs:mount_err], 1
		jmp mount_dev_err	;Device not supported/isn't a recognized device
mount_dev_valid:
	cmp al, 0
	jz mount_dev_long
		jmp mount_dev_short
	;*************************************

	;******************* Determine the Device Type and Create a Long Entry for it *********************
mount_dev_long:
	inc esi
	cmp word [esi], "hd"
	jnz not_mount_dev_hd
		jmp mount_dev_hd
not_mount_dev_hd:	cmp word [esi], "fd"
			jnz not_mount_dev_fd
			jmp mount_dev_fd
not_mount_dev_fd:	cmp word [esi], "LP"
			jnz not_mount_dev_LPT
		dec esi
		call sys_mount_net_csel:0
		jnc md_net_success
			mov byte [fs:mount_err], al
			jmp mount_dev_err
		md_net_success:	jmp mount_dev_done
not_mount_dev_LPT:
	mov byte [fs:mount_err], 1
	jmp mount_dev_err	;Device not supported.

	;************************ Mount a Hard Disk ***************************
mount_dev_hd:
	xor eax, eax
	mov edi, eax
	mov bx, 1
	mov cx, 1

	inc esi
	inc esi
	cmp byte [esi], "0"
	je md_hd0
	cmp byte [esi], "1"
	je md_hd1
	cmp byte [esi], "2"
	je md_hd2
	cmp byte [esi], "3"
	je md_hd3
		mov byte [fs:mount_err], 1
		jmp mount_dev_err
md_hd2:
	or bh, 80h
	jmp md_hd0
md_hd3:
	or bh, 80h
md_hd1:
	or ch, 10h
	or bh, 10h
	jmp md_hd0
md_hd0:
	cmp byte [esi + 1], "/"
	jz md_hd_read1st
		mov byte [fs:mount_err], 1
		jmp mount_dev_err
md_hd_read1st:
	call sys_hdread_csel:0
	jnc md_hd_exists
		mov byte [fs:mount_err], 1
		jmp mount_dev_err	;Device doesn't exist/gave a general error
md_hd_exists:
	shl ecx, 16	;Save the master slave bits in ch and bh and the hdc0/hdc1 bits in bh into ecx
	mov cx, bx	;DON'T ALTER ECX UNTIL AFTER THE STUFF IS FIGURED OUT!!!!
	push ecx
	call md_find_partition	;At this point, eax = LBA base

	pop ecx
	mov bx, cx
	shr ecx, 16
	mov si, word [es:22]	;Get # sectors/fat into si
	and esi, 0ffffh
	call sys_md_nextentry_csel:0	;This will return the offset of the next open device entry into the device_sel and check to
				;make sure that there is enough room left. In: si = sectors/fat
	jnc md_hd_enoughroom
		mov byte [fs:mount_err], 3
		jmp mount_dev_err
md_hd_enoughroom:
	mov dword [fs:mount_entry_offset], edi	;Save offset of new entry
	mov dl, 0e0h
	or dl, byte [fs:mount_flags]
	mov byte [es:edi + 4], dl
	mov dx, word [fs:mount_usernum]
	mov word [es:edi + 9], dx
	mov word [es:edi + 11], 1
	add edi, 17	;Get offset of asciiz string from there
	push esi	;Save # sectors/fat
	mov esi, dword [fs:mount_str_offset]	;Get offset of the two asciiz strings
md_hd_writename:		;Move the first one into its place
	movsb
	cmp byte [esi], 0
	jnz md_hd_writename
md_hd_writeother:		;Now move the null byte and the second asciiz string immediately after it.
	movsb
	cmp byte [esi], 0
	jnz md_hd_writeother
	movsb			;Move last null byte
	pop esi			;Now that we're done, edi points to where the FAT copy will go and esi is restored to hold
				;the # sectors/FAT...
	push word 0
	push word [fs:device_sel]
	pop es
md_hd_readloop:
	push eax		;Save LBA base

	call sys_LBA_CHS_csel:0

	mov dl, bl	;bl=starting sector & cl=#sectors until a head boundary is reached (max. read/written at once)
	add dl, cl	;Now dl = #sectors/head
	cmp dl, 64
	jb md_hd_doread
		mov dl, 64	;If the number of sectors that is going to be read is > 63 then make it 63 b/c 63 is the
		sub dl, bl	;max. that hdread will support
		mov cl, dl
md_hd_doread:
	mov dl, cl
	and dx, 0ffh
	cmp dx, si
	jna md_hd_continue	;If #sectors about to be read is > than the number that need to be, subtract the difference
		mov dx, si
		mov cl, dl
md_hd_continue:
	pop edx		;Pop the eax into edx (LBA base of next read)
	push ecx
	and ecx, 0ffh
	add edx, ecx	;Add the number of sectors being read to get the LBA base of the next sector after that
			;that needs to be read.
	pop ecx
	push edx	;Repush it so that eax can pop it right before it translates the LBA again
	mov dl, cl
	and edx, 0ffh
	sub si, dx	;si = number of sectors to read, so subtract the number being read from it...	
	push edi
	call sys_hdread_csel:0
	pop edi
	jnc md_hd_noerr4
		mov byte [fs:mount_err], 4
		pop eax		;Pop the last pushed LBA base
		jmp mount_dev_err
md_hd_noerr4:
	shl edx, 9	;Convert # sectors read into bytes
	add edi, edx
	pop eax			;Pop the LBA base
	cmp si, 0
	jnz md_hd_readloop
		sub edi, dword [fs:mount_entry_offset]
		mov esi, dword [fs:mount_entry_offset]
		mov dword [es:esi], edi
	jmp mount_dev_done
	;**************** End of Mount a Hard Drive

	;********** Mount a floppy drive ******
mount_dev_fd:
	inc esi
	inc esi
	mov ah, byte [esi]
	sub ah, "0"
	cmp ah, 3
	jna md_supported_floppy
		mov byte [fs:mount_err], 1
		jmp mount_dev_err
md_supported_floppy:
	inc esi
	cmp byte [esi], "/"
	jz md_good_stdname
		mov byte [fs:mount_err], 1
		jmp mount_dev_err
md_good_stdname:
	mov al, 0e6h
	mov cx, 1
	mov bl, cl
	call sys_fd_rw_csel:0
	jnc md_nofderr
		mov byte [fs:mount_err], 1
		jmp mount_dev_err
md_nofderr:
	mov eax, 1
	call sys_ID_partition_csel:0		;This is just sort of used to read the first sector...

;	push eax
;	shr eax, 8
;	mov ah, green
;	call lib_putchar_csel:0
;	mov ah, yellow
;	mov al, cl
;	call lib_putchar_csel:0
;	mov ah, blue
;	mov al, ch
;	call lib_putchar_csel:0
;	mov ah, red
;	mov al, bl
;	call lib_putchar_csel:0
;	pop eax
	push eax
	mov ax, magneta * 256 + "Y"
	call lib_putchar_csel:0
	pop eax
	here:	jmp here

	mov esi, 450
	mov ecx, 4
md_findHCP:
	cmp byte [es:esi], HCP_partition_ID
	jz md_foundHCP
	add esi, 16
	loop md_findHCP
		jmp mount_dev_err2_2
md_foundHCP:
	sub esi, 3	;hsc
	mov ah, byte [es:esi]		;Head # of HCP partition
	shl ah, 2
	inc esi
	mov bl, byte [es:esi]		;Sector #

	xor ecx, ecx
	mov cx, word [es:22]		;Get FAT length
	inc esi
	mov ch, byte [es:esi]		;Cylinder #
	mov si, cx
	and si, 0ffh
	call sys_md_nextentry_csel:0
	mov dword [fs:mount_entry_offset], edi
	jnc md_enoughroom
		mov byte [fs:mount_err], 3
		jmp mount_dev_err
md_enoughroom:
	mov dl, 0e0h
	or dl, byte [fs:mount_flags]
	mov byte [es:edi + 4], dl
	mov dx, word [fs:mount_usernum]
	mov word [es:edi + 9], dx
	mov word [es:edi + 11], 0

	add edi, 17
	push esi
	mov esi, dword [fs:mount_str_offset]
md_fd_wrname:
	movsb
	cmp byte [esi], 0
	jnz md_fd_wrname
md_fd_wrname2:
	movsb
	cmp byte [esi], 0
	jnz md_fd_wrname2
	movsb		;Move last null byte
	pop esi

	mov dx, linear_data_sel
	mov ds, dx
	xor edx, edx
	mov dl, bl
	add esi, edx
	xor edx, edx
	cmp esi, 20
	jb md_fdreading
		mov edx, esi
		sub edx, 19
		add dl, bl
md_fdreading:
	push ecx
	mov al, 0e6h
	call sys_fd_rw_csel:0
	pop ecx
	push ecx
	and ecx, 0ffh		;Save # sectors
	shl ecx, 9		;Multiply by 512 to get # bytes
	xor esi, esi
	rep movsb
	pop ecx
	jnc md_noreaderr
		mov byte [fs:mount_err], 1
		jmp mount_dev_err
md_noreaderr:
	cmp edx, 0
	jz md_fd_done
		test ah, 4
		jz md_justchghead
		inc ch
md_justchghead:
		btc eax, 2
		mov cl, 18
		mov bl, 1
		mov esi, edx
		jmp md_fdreading
md_fd_done:
	mov esi, dword [fs:mount_entry_offset]
	mov dword [es:esi], edi
	jmp mount_dev_done
		;in:    al bits: bit7 set if Multi-track, MFM encoding, skip deleted data address mark, bits4->0 are:
		;		read: al will probably be 0e6h=11100110xb
		;		write: al will probably be 0e5h=11100101xb
		;	ah bits: 00000, bit2=head #, bits1-0 = floppy drive #
		;	cl = # sectors (!!!cannot be > 63 b/c 63=7e00h / 512(original_offset / 512)), ch=cylinder#, bl=sector#
		;	out: transfer & ecx = number of sectors actually transferred.
	;******* End of Mount a floppy Drive ******

mount_dev_done:
	pop fs
	pop es
	popfd
	popad
	retf
	;**** Error1: Device not supported/doesn't exist/or there was an error reading
	;**** Error3: Not enough device memory to mount this device
	;**** Error4: Error reading FAT from device
mount_dev_err:
	pop eax					;was actually an fs push...
	mov word [fs:mount_err + 2], ax		;Save this selector
	pop es
	popfd
	popad
	mov al, byte [fs:mount_err]		;Put error code into al
	push word 0
	push word [fs:mount_err + 2]
	pop fs					;Restore fs
	stc
	retf
	;**** Error2: Device does not contain valid HCP file system.
mount_dev_err2:
	pop eax		;Pop the "push edi"
	pop eax		;Pop the eip from calling md_find_partition
	pop eax		;Pop the ecx that was pushed just before md_find_partition was called
mount_dev_err2_2:
	pop fs		;Pop the rest of the stuff
	pop es
	popfd
	popad
	stc
	mov al, 2
	retf

	;**** Once boot sector of device is loaded here, This scans for an HCP partition
md_find_partition:	;Returns LBA base of HCP partition in eax
	push edi	;in:	es:0 -> boot sector of corresponding device
;	mov edi, 46
;	cmp word [es:edi], "HC"
;	jnz mount_dev_err2
;	inc edi
;	inc edi
;	cmp byte [es:edi], "P"
;	jnz mount_dev_err2
	mov edi, 450	;offset of first Partition type byte
	mov ecx, 4	;Because HCP isn't one of the first standard OS's there is no partition type # for it, so we'll just
md_find_partition_loop:	;use 0 for now... If there are no partition entries with zeroes, 
	cmp byte [es:edi], HCP_partition_ID
	jz md_hcp
	add edi, 16	;Look at next partition entry
	loop md_find_partition_loop
		jmp mount_dev_err2
md_hcp:
	add edi, 4	;this is the LBA starting sector entry (4bytes after the partition type byte)
	mov eax, dword [es:edi]	;Put starting sector into eax
	cmp eax, 0
	jz mount_dev_err2
	pop edi
	ret
	;*********************** Remount a Device with A Second Name Using Short format ****************************
		;For questions see "BigLink.txt"
mount_dev_short:

end_mount_dev:

;********** Get offset of next open entry into the device_sel ***********
md_nextentry:		;In:	si = # sectors that need to be written to it
			;Out:	edi = offset into device_sel of next open entry
			;	If not enough room, carry set and edi invalid
	push eax
	push ds
	push fs
	push si

	mov ax, word [fs:device_sel]
	mov ds, ax
	push dword shared_data_sel
	pop fs

	xor esi, esi
md_nextentry_loop:
	cmp dword [esi], 0		;This looks through the device entries for the next open one
	jz md_nextentry_found
	add esi, dword [esi]
	cmp esi, device_data_size	;Make sure it isn't too big
	jb md_nextentry_loop
	jmp md_nextentry_noroom
md_nextentry_found:
	mov eax, esi
	pop si
	and esi, 0ffffh
	add eax, esi
	cmp eax, device_data_size
	jna md_nextentry_done
md_nextentry_noroom:
		pop fs
		pop ds
		pop eax
		stc
		ret
md_nextentry_done:
	sub eax, esi
	mov edi, eax
	pop fs
	pop ds
	pop eax
	clc
	ret
end_md_nextentry:

	;****************************
get_mnt_type:		;In:	ds:esi -> asciiz string = standard device name
			;Out:	al = 0 If a long entry needs to be made, al = 1 if a short entry needs to be made
			;	IF STANDARD DEVICE NAME ISN'T RECOGNIZED, CARRY SET & al invalid
	cmp byte [esi], "/"	;All mount entries must start with a "/"
	jnz get_mnt_type_invalid

	push ecx
	push esi
	push edi
	push es
	push fs

	mov ax, shared_data_sel
	mov fs, ax
	mov ax, word [fs:device_sel]
	mov es, ax

	xor ecx, ecx
	push esi
get_mnt_lengthloop:
	inc esi
	inc ecx
	cmp byte [esi], "/"
	jnz get_mnt_lengthloop

	pop esi
	xor edi, edi
get_mnt_testanother:
	mov eax, dword [es:edi]
	test byte [es:edi + 4], 20h	;See if this is a long entry
	jnz get_mnt_longentry		;If it isn't, skip it
		add edi, eax
		cmp eax, 0		;If length of last dev entry was 0, it must not have been an entry and we are
		jz get_mnt_type_done	;done so leave al=0 and return
		cmp edi, device_data_size
		jb get_mnt_testanother
		mov al, 0
		jmp get_mnt_type_done
get_mnt_longentry:
	push esi
	push edi
	push ecx	;Save the length that must be compared
	add edi, 17	;Point to asciiz string of standard device name
	repz cmpsb
	cmp ecx, 0
	jnz get_mnt_longentry_notdone
		pop ecx
		pop edi
		pop esi
		mov al, 0
		jmp get_mnt_type_done
get_mnt_longentry_notdone:
	pop ecx
	pop edi
	pop esi
	add edi, eax
	jmp get_mnt_testanother

get_mnt_type_done:
	pop fs
	pop es
	pop edi
	pop esi
	pop ecx
	clc
	retf
get_mnt_type_invalid:
	stc
	retf
end_get_mnt_type:

;*************************** Identify Primary Partitions on a Hard Drive ***********************
ID_partition:		;in:	If a hard drive, al = 0, If a floppy drive, al = 1
			;		Floppy drive: ah = floppy drive # (0-3)
			;		Hard Disk:
			;			If hd1 or hd3 set bit4 of ch AND bh, ELSE BOTH CLEAR
			;			If hd2 or hd3 set bit7 of bh, ELSE CLEAR
			;	NOTE: Only worry about the bits mentioned (watch bit6 bh), other bits will be set accordingly.
			;out:	al=ID # of 1st partition, ah=ID # of 2nd, low byte of high word eax = ID # of 3rd, etc.
			;	bl: bit0 set if first partition active, bit1 set if 2nd active, etc.
			;Additional Info:00h=unknown,01h=DOS2(12bit),04h=DOS3(16bit,<32MB),05h=DOS Extended,
			;		06h=DOS4(16bit,>=32MB),0bh=DOS32(32-bit,up to 2047GB),0ch=DOS32X (same as 0bh except uses
			;		LBA int13h extensions),0eh=DOSX13(Same as DOS4, but uses LBA...),0fh=DOSX13X (same as DOS
			;		extended, but uses LBA...)
			;		*** If it's an HCP partition, for now it will return 80h. This is subject to change
			;		    but I will keep it as an equate in my inc\equates.asm file
	push ecx
	push ebx
	push edi
	push es

	push word 0
	push word linear_data_sel
	pop es

	cmp al, 0
	jnz IDp_floppy

	;**** Read 1st sector of hard drive
	and ch, 010h		;Clear everything but bit4 (param): read, head 0000xb
	and bh, 060h
	mov cl, 1
	xor eax, eax
	mov bl, cl
	xor edi, edi
	call sys_hdread_csel:0
	jmp IDp_analyze

	;**** Read 1st sector of floppy drive
IDp_floppy:
	mov al, 0e6h
	and ah, 3
	mov cx, 1
	mov bl, cl
	call sys_fd_rw_csel:0

IDp_analyze:
	xor eax, eax
	mov ebx, eax
	mov edi, 446
	mov ecx, 4
IDp_loop:
	test byte [es:edi], 080h
	jz IDp_dont_inc
		inc bh
IDp_dont_inc:
	shr ebx, 1
	add edi, 4
	mov al, byte [es:edi]
	ror eax, 8
	add edi, 12
	loop IDp_loop

	shr ebx, 4	;Get bits from active partitions into low nibble bl

	pop es
	pop edi
	pop ebx
	pop ecx
	retf
end_ID_partition: