" Vim syntax file
" Language:    Funes
" Maintainer:  Pablo Barenbaum <pablob@starlinux.net>
" Last Change: Jul 08, 2004
" Version:     0.01

" For version 5.x: Clear all syntax items
" For version 6.x: Quit when a syntax file was already loaded
if version < 600
  syntax clear
elseif exists("b:current_syntax")
  finish
endif

if version >= 600
 setlocal iskeyword=35,36,37,38,42,43,45,47-57,60-62,64-90,97-122,_
 "   # $ % & * + - / alfanumericos < = >     : es el 58
else
 set iskeyword=35,36,37,38,42,43,45,47-57,60-62,64-90,97-122,_
endif

" Clusters
syn cluster	fuAtomCluster	contains=fuAtomBarSymbol,fuAtomList,fuAtomNmbr0,fuComment,fuDecl,fuFunc,fuLeadWhite,fuKword,fuArgset,fuKey
syn cluster	fuListCluster	contains=fuAtom,fuAtomBarSymbol,fuAtomMark,fuBQList,fuBarSymbol,fuComment,fuConcat,fuDecl,fuFunc,fuKey,fuList,fuNumber,fuSpecial,fuSymbol,fuKword,fuArgset,fuVar,fuLeadWhite

" Listas
syn match	fuSymbol	contained	![^():'`,"; \t]\+!
syn match	fuBarSymbol	contained	!|..\{-}|!
syn region	fuList	matchgroup=Delimiter start="(" skip="|.\{-}|"	matchgroup=Delimiter end=")" contains=@fuListCluster,fuString
syn region	fuList	matchgroup=Delimiter start=":" skip="|.\{-}|"	matchgroup=Delimiter end="\_^" contains=@fuListCluster,fuString
syn region	fuBQList	matchgroup=PreProc   start="`("	skip="|.\{-}|"	matchgroup=PreProc   end=")" contains=@fuListCluster,fuString
syn region	fuBQList	matchgroup=PreProc start="`:" skip="|.\{-}|"	matchgroup=PreProc end="\_^" contains=@fuListCluster,fuString

" Atomos
syn match	fuAtomMark	"'"
syn match	fuAtom	"'("me=e-1	contains=fuAtomMark	nextgroup=fuAtomList
syn match	fuAtom	"'[^ \t()]\+"	contains=fuAtomMark
syn match	fuAtomBarSymbol	!'|..\{-}|!	contains=fuAtomMark
syn region	fuAtom	start=+'"+	skip=+\\"+ end=+"+
syn region	fuAtomList	contained	matchgroup=Special start="("	skip="|.\{-}|" matchgroup=Special end=")"	contains=@fuAtomCluster,fuString
syn match	fuAtomNmbr	contained	"\<\d\+"
syn match	fuLeadWhite	contained	"^\s\+"
syn match	fuKword	contained !=[^()'`,"; \t]\+!
syn match	fuArgset	contained !--[^()'`,"; \t]\+!

" Interpolados
"syn region	fuInterList	contained matchgroup=Delimiter start="\($(\|$@(\)" skip="|.\{-}|"	matchgroup=Delimiter end=")" contains=@fuListCluster,fuString
syn region	fuInterList	contained matchgroup=Delimiter start="$(" skip="|.\{-}|"	matchgroup=Delimiter end=")" contains=@fuListCluster,fuString
syn region	fuInterList	contained matchgroup=Delimiter start=/$@"[^"]*"(/ skip="|.\{-}|"	matchgroup=Delimiter end=")" contains=@fuListCluster,fuString
syn region	fuInterBQList	matchgroup=PreProc   start="$`("	skip="|.\{-}|"	matchgroup=PreProc   end=")" contains=@fuListCluster,fuString
syn match	fuInterSymbol	contained !$[^():'`,";@ \t]\+!

" Formateo y escapes
syn match	fuFormateo contained !%[sSibBoOxX]\+!
syn match	fuFormateo contained +\\[nt'"\\]+
syn match	fuFormateo contained "\\$"

" Funciones y Macros
syn keyword fuFunc * + - 1+ 1- ++ -- < > % quotient
syn keyword fuFunc car cdr cons acons push eq
syn keyword fuFunc quote if fun do def set let nlet while to
syn keyword fuFunc read eval map mapc maplist mapl each
syn keyword fuFunc err handle try catch gensym rev xrev
syn keyword fuFunc list list* vec len macro consp cat join
syn keyword fuFunc elt copy index member assoc call
syn keyword fuFunc ord chr fread flines load import use run get hget fget
syn keyword fuFunc last range iota and or not null die exit
syn keyword fuFunc mkdb mkvec mklist hget setter defset
syn keyword fuFunc db data
syn keyword fuFunc stread defun defdyn dyn str fmt num->str
syn keyword fuFunc pr pr1 wr wr1 out prf wrf outf cr lf crlf
syn keyword fuFunc nth ntl vref typep type deftype
syn keyword fuFunc check sys
syn keyword fuFunc pack module env dir
syn keyword fuFunc mkstype stype-accessor stype-constructor
syn keyword fuFunc mkstruct struct-data struct-copy defstruct

" Excepciones
syn keyword fuKey &missing-expression &bad-argument &wrong-type-arg
syn keyword fuKey &parse-error &read-error &wrong-type &misc-error
syn keyword fuKey &internal-error &index-error &unbound-variable
syn keyword fuKey &arity-error &out-of-range &system-error &key-error
syn keyword fuKey &slot-error
syn keyword fuKey #t #f

" Tipos
syn keyword fuKey <sym> <vec> <proc> <special-form> <closure> <port>
syn keyword fuKey <reader> <type> <int> <cons> <char> <null> <t> <eof> <undef>
syn keyword fuKey <str> <hash> <macro> <any>
syn keyword fuKey <list> <seq> <function>
syn keyword fuFunc union intersection satisfies

" Standard Lisp Variables

" Strings
syn region fuString contains=fuInterList,fuInterSymbol,fuInterBQList,fuFormateo start=+"+ skip=+\\\\\|\\"+ end=+"+

" Numbers: supporting integers and floating point numbers
syn match fuNumber	"-\=\(\.\d\+\|\d\+\(\.\d*\)\=\)\(e[-+]\=\d\+\)\="

syn match fuSpecial	"\*[a-zA-Z_][a-zA-Z_0-9-]*\*"
syn match fuSpecial	!#|[^():'`,"; \t]\+|#!
syn match fuSpecial	!#x[0-9a-fA-F]\+!
syn match fuSpecial	!#o[0-7]\+!
syn match fuSpecial	!#b[01]\+!
syn match fuSpecial	!#\\[ -\~]!
syn match fuSpecial	!#[':][^():'`,"; \t]\+!
syn match fuSpecial	!#([^():'`,"; \t]\+)!

syn match fuConcat	"\s\.\s"
syn match fuParenError	")"

" Comments
syn cluster fuCommentGroup	contains=fuTodo
syn match   fuComment	";.*$"	contains=@fuCommentGroup
syn case ignore
syn keyword fuTodo	contained	combak	combak:	todo	todo:
syn case match

" synchronization
syn sync lines=100

" Define the default highlighting.
" For version 5.7 and earlier: only when not done already
" For version 5.8 and later: only when an item doesn't have highlighting yet
if version >= 508 || !exists("did_fu_syntax_inits")
  if version < 508
    let did_fu_syntax_inits = 1
    command -nargs=+ HiLink hi link <args>
  else
    command -nargs=+ HiLink hi def link <args>
  endif

  HiLink fuAtomNmbr	fuNumber
  HiLink fuAtomMark	fuMark
  HiLink fuInStringString	fuString

  HiLink fuAtom	Identifier
  HiLink fuAtomBarSymbol	Special
  HiLink fuBarSymbol	Special
  HiLink fuComment	Comment
  HiLink fuConcat	Statement
  HiLink fuDecl	Statement
  HiLink fuFunc	Statement
  HiLink fuKey	Type
  HiLink fuMark	Delimiter
  HiLink fuNumber	Number
  HiLink fuParenError	Error
  HiLink fuSpecial	Type
  HiLink fuFormateo	Special
  HiLink fuInterSymbol	Identifier
  HiLink fuString	String
  HiLink fuTodo	Todo
  HiLink fuVar	Statement
  HiLink fuKword	Function
  HiLink fuArgset	Preproc

  delcommand HiLink
endif

let b:current_syntax = "funes"

" vim: ts=33 nowrap
