#include "Fu.h"

BCODE *
fu_make_bcode(opcode, opt)
	char opcode;
	int opt;
{
	BCODE *c;

	c = NEW(BCODE);
	BCODE_OPCODE(c) = opcode;
	BCODE_OPT(c) = opt;
	return c;
}

BCONS *
fu_make_bcons(code, next)
	BCODE *code;
	BCONS *next;
{
	BCONS *bc;

	bc = NEW(BCONS);
	BCONS_CODE(bc) = code;
	BCONS_NEXT(bc) = next;
	return bc;
}

BLIST *
fu_make_blist(first)
	BCONS *first;
{
	BLIST *bl;
	bl = NEW(BLIST);
	BLIST_LAST(bl) = BLIST_FIRST(bl) = first;
	return bl;
}

RES *
fu_closure_copy(clos)
		RES *clos;
{
		RES *p = NEW(RES);
		CLOSURE *d = NEW(CLOSURE), *o = VAL_CLOSURE(clos);

		TIPO(p) = tipo_closure;
		CLOSURE_CODEVEC(d) = CLOSURE_CODEVEC(o);
		CLOSURE_LENGTH(d) = CLOSURE_LENGTH(o);
		CLOSURE_CONSTANTS(d) = CLOSURE_CONSTANTS(o);
		CLOSURE_ARGLIST(d) = CLOSURE_ARGLIST(o);
		CLOSURE_FLAGS(d) = CLOSURE_FLAGS(o);
		CLOSURE_ENVPADRE(d) = CLOSURE_ENVPADRE(o);
		VAL_CLOSURE(p) = (void *) d;
		return p;
}

#define STACK_PUSH(X) (stack = fu_cons((X), stack))
#define STACK_POP(X) {	X = CAR(stack);\
						stack = CDR(stack); }
RES *
fu_interpret(c, args)
	RES *c, *args;
{

	CLOSURE *clos;
	/* codigo */
	BCODE **code;
 	/* tabla de constantes */
	RES **consts;
	/* argumentos formales */
	RES *formal_args;

	register unsigned pc;
	unsigned length;

	register RES *val;	/* val -- registro de la vm */
	RES *stack;			/* la pila */

	RES *prev_env_padre;

	prev_env_padre = fu_env();

principio_interpret:
	clos = VAL_CLOSURE(c);
	code = CLOSURE_CODEVEC(clos);
	consts = VECTOR_TABLA(VAL_VECTOR(CLOSURE_CONSTANTS(clos)));
	formal_args = CLOSURE_ARGLIST(clos);
	length = CLOSURE_LENGTH(clos);
	val = NIL;

	if (!CLOSURE_DYN(clos))
		fu_with_env(CLOSURE_ENVPADRE(clos));
	if (CLOSURE_NEWENV(clos))
		fu_push_env();

	/* bindea los argumentos formales a los
	 * argumentos reales
	 */
#if 0
	{
		RES *p, *f;

		for ( f = formal_args, p = args; ; f = CDR(f), p = CDR(p)) {
			if ( CONS_P(f) ) {
				if ( CONS_P(p)) {
					/* argumento normal */
					fu_def_env(CAR(f), CAR(p));
				} else {
					/* pasaron pocos parametros */
					fu_throw(fu_symbol("&arity-error"),
						fu_str("interpret -- no coinciden las aridades"));
				}
			} else if ( f == NIL ) {
				if ( p == NIL ) {
					/* termina bien */
					break;
				} else {
					/* pasaron demasiados parametros */
					fu_throw(fu_symbol("&arity-error"),
						fu_str("interpret -- no coinciden las aridades"));
				}
			} else {
				/* f no es un cons ni NIL */
				/* argumentos rest y termina */
				fu_def_env(f, p);
				break;
			}
		}
	}
#endif

	{
		RES *opts;
		RES *p, *f;

		//opts = fu_make_hash(fu_int(7));

#define SET_K(K, V)	fu_def_env(K, V)
#define GET_K(K)	fu_get_env(K)
#define KWARGP(E)	(CONS_P(E) && CAR(E) == ARGSET && CONS_P(CDR(E)) && CONS_P(CDDR(E)))
#define KEY(E)		CADR(E)
/* KWARGP2 & KEY2 :: el formal no tiene simbolo sino (quote simbolo)
 * como clave */
#define KWARGP2(E)	(KWARGP(E) && CONS_P(KEY(E)) && CONS_P(CDR(KEY(E))))
#define KEY2(E)		CADR(KEY(E))
#define VALUE(E)	CADDR(E)
		for ( f = formal_args, p = args; ;  ) {
			if ( CONS_P(f) ) {
				if (CONS_P(p)) {
					/* argumento normal */
					if (KWARGP(CAR(p))) {
						/* el real es un kwarg */
						SET_K(KEY(CAR(p)), VALUE(CAR(p)));
						/* avanzo el real pero NO el formal */
						p = CDR(p);
						continue;
					} else if (KWARGP2(CAR(f))) {
						/* el formal es un kwarg */
						RES *a = CAR(f), *kv, *clave;
						clave = KEY2(a);
						kv = GET_K(clave);
						if (kv == NIL)
							/* no tenia binding previo */
							SET_K(clave, CAR(p));
					} else {
						fu_def_env(CAR(f), CAR(p));
					}
				} else {
					/* pasaron pocos parametros */
					while (TRUE) {
						if (CONS_P(f)) {
							RES *a = CAR(f);
							if (KWARGP2(a)) {
								RES *kv, *clave = KEY2(a);
								kv = GET_K(clave);
								if (kv == NIL)
									/* no tenia binding previo */
									SET_K(clave, fu_eval(VALUE(a)));
							} else
								fu_throw(fu_symbol("&arity-error"),
									fu_str("interpret -- no coinciden las aridades"));
						} else if (f == NIL) {
							goto fin_for;
						} else {
							goto fin_for;
						}
						f = CDR(f);
					}
				}
			} else if ( f == NIL ) {
				if ( p == NIL ) {
					/* termina bien */
					break;
				} else {
					/* pasaron demasiados parametros */
					fu_throw(fu_symbol("&arity-error"),
						fu_str("interpret -- no coinciden las aridades"));
				}
			} else {
				/* f no es un cons ni NIL */
				/* argumentos rest y termina */
				fu_def_env(f, p);
				break;
			}
			f = CDR(f);
			p = CDR(p);
		}
fin_for:
#undef KEY
#undef KEY2
#undef VALUE
#undef GET_K
#undef SET_K
	}

	/* interpreta el codigo */
	for ( pc = 0; pc < length; pc++) {
		char op = BCODE_OPCODE(code[pc]);
		int opt = BCODE_OPT(code[pc]);

		switch (op) {
		case NOP:
			break;
		case RET:
			goto fin_interpret;
		case CONST:
			val = consts[opt];
			break;
		case PUSH:
			STACK_PUSH(val);
			break;
		case CONST_PUSH:
			val = consts[opt];
			STACK_PUSH(val);
			break;
		case APPLY:
		{
			unsigned i;
			RES *arg, *largs;

			largs = NIL;
			for ( i = 0; i < opt; i++ ) {
				STACK_POP(arg);
				largs = fu_cons(arg, largs);
			}
			val = fu_apply(val, largs);
			break;
		}
		case TAIL_APPLY:
		{
			int i;
			RES *arg, *largs;

			largs = NIL;
			for ( i = 0; i < opt; i++ ) {
				STACK_POP(arg);
				largs = fu_cons(arg, largs);
			}
			if (TIPO_P(tipo_closure, val) && !CLOSURE_DYN(VAL_CLOSURE(val))) {
				/* puedo usar tail recursion solo
				 * si llamo a una _closure_ _no dinmica_
				 */
				c = val;
				args = largs;
				/* saco el entorno actual */
				if (CLOSURE_NEWENV(clos))
					fu_pop_env();
				goto principio_interpret;
			} else
				val = fu_apply(val, largs);
			break;
		}
		case JMP:
		{
			pc = opt;
			break;
		}
		case JNF:
		{
			if ( val != NIL )
				pc = opt;
			break;
		}
		case JF:
		{
			if ( val == NIL )
				pc = opt;
			break;
		}
		case DEF:
		{
			RES *ident;

			ident = consts[opt];
			STACK_POP(val);
			fu_def_env(ident, val);
			break;
		}
		case SET:
		{
			RES *ident;

			ident = consts[opt];
			STACK_POP(val);
			fu_set_env(ident, val);
			break;
		}
		case GET:
		{
			RES *ident, *r;

			ident = consts[opt];
			val = fu_get_env(ident);
			if ( val == NIL ) {
				fu_throw(fu_symbol("&unbound-variable"),
					fu_str_cat(
						fu_str_cat(fu_str("get -- `"),
							fu_str(VAL_SYMNAME(ident))),
						fu_str("' simbolo no bindeado")));
			} else
				val = CDR(val);
			break;
		}
		case CLOSE:
		{
			/* cierra la closure en un entorno (generando una copia) */
			RES *clos;

			clos = fu_closure_copy(val);
			CLOSURE_ENVPADRE(VAL_CLOSURE(clos)) = fu_env();
			val = clos;
			break;
		}
		case PUSH_ENV:
			fu_push_env();
			break;
		case POP_ENV:
			fu_pop_env();
			break;
		case ENV:
			val = fu_dir();
			break;
		case SETTER:
			val = fu_setter(val);
			break;
		case NOT:
			val = (val == NIL)? T : NIL;
			break;
		case EQ: {
			RES *p;

			STACK_POP(p);
			val = (val == p) ? T : NIL;
			break;
		}
		case OP_CAR:
			val = fu_car(val);
			break;
		case OP_CDR:
			val = fu_cdr(val);
			break;
		case PRINT:
			fu_print(val);
			printf("\n");
			break;
		}
	}
fin_interpret:
	if (CLOSURE_NEWENV(clos))
		fu_pop_env();
	if (!CLOSURE_DYN(clos))
		fu_with_env(prev_env_padre);
	return val;
}
#undef STACK_PUSH
#undef STACK_POP

void
fu_closure_print(c)
	RES *c;
{
	CLOSURE *clos = VAL_CLOSURE(c);
	/* codigo */
	BCODE **code = CLOSURE_CODEVEC(clos);
	unsigned pc;
	unsigned length = CLOSURE_LENGTH(clos);

	char *opcodes[] = {
		"NOP",
		"RET",
		"CONST",
		"PUSH",
		"CONST_PUSH",
		"APPLY",
		"TAIL_APPLY",
		"JMP",
		"JNF",
		"JF",
		"DEF",
		"SET",
		"GET",
		"JMP_LABEL",
		"JNF_LABEL",
		"JF_LABEL",
		"LABEL",
		"CLOSE",
		"PUSH_ENV",
		"POP_ENV",
		"ENV",
		"SETTER",
		"NOT",
		"EQ",
		"OP_CAR",
		"OP_CDR",
		"PRINT",
	};
 	/* tabla de constantes */
	printf("#<closure\n");
	printf("\targumentos: ");
	fu_print(CLOSURE_ARGLIST(clos));
	printf("\n");
	printf("\tconstantes: ");
	fu_print(CLOSURE_CONSTANTS(clos));
	printf("\n");

	for ( pc = 0; pc < length; pc++) {
		char op = BCODE_OPCODE(code[pc]);
		int opt = BCODE_OPT(code[pc]);

		printf("%i\t%s %i\n", pc, opcodes[op], opt);
	}
	printf(">\n");
}

RES *
fu_eval(expr)
	RES *expr;
{
	return fu_interpret(FU_COMPILE(expr), NIL);
}
