#include "Fu.h"

#define MK_BUILTIN(X,TB,NOMBRE)	 {\
	TIPO *t = NEW(TIPO);\
	(X) = NEW(RES);\
	TIPO(X) = tipo_tipo;\
	TIPO_NOMBRE(t) = NOMBRE;\
	TIPO_DES(t) = (RES *) ((TB << 2) | 1);\
	VAL_TIPO(X) = (void *) t;\
}
#define MK_COMPUESTO(X,DES) {\
	TIPO *t = NEW(TIPO);\
	(X) = NEW(RES);\
	TIPO(X) = tipo_tipo;\
	TIPO_DES(t) = DES;\
	VAL_TIPO(X) = (void *) t;\
}
#define TBUILT(N, Y) {\
	RES *__p;\
	MK_BUILTIN(__p, Y, N);\
	BIND(N, __p);\
}
#define TCOMPU(N, Y) {\
	RES *__p;\
	MK_COMPUESTO(__p, Y);\
	BIND(N, __p);\
}
#define BIND(SYMB, COSA) fu_def_env(fu_symbol(SYMB), COSA)
#define TI(SYMB) CDR(fu_get_env(fu_symbol(SYMB)))
void
fu_init_tipos()
{
	TBUILT("<sym>", tipo_sym);
	TBUILT("<vec>", tipo_vector);
	TBUILT("<special-form>", tipo_special_form);
	TBUILT("<proc>", tipo_proc);
	TBUILT("<closure>", tipo_closure);
	TBUILT("<port>", tipo_port);
	TBUILT("<reader>", tipo_reader);
	TBUILT("<type>", tipo_tipo);

	/* tipos magicos (ningun objeto tiene realmente
	 * ese tipo, sino que esta taggeado de otra manera)
	 */
	TBUILT("<int>", tipo_magic_int);
	TBUILT("<char>", tipo_magic_char);
	TBUILT("<cons>", tipo_magic_cons);
	TBUILT("<null>", tipo_magic_null);
	TBUILT("<t>", tipo_magic_t);
	TBUILT("<eof>", tipo_magic_eof);
	TBUILT("<undef>", tipo_magic_undef);
	TBUILT("<macro>", tipo_magic_macro);
	TBUILT("<str>", tipo_magic_str);
	TBUILT("<hash>", tipo_magic_hash);
	TBUILT("<any>", tipo_magic_any);

	/*tipo_str,*/

	TCOMPU("<list>", fu_make_list("xxx",
				fu_symbol("union"),
				TI("<cons>"),
				TI("<null>")));
	TCOMPU("<seq>", fu_make_list("xxxx",
				fu_symbol("union"),
				TI("<cons>"),
				TI("<null>"),
				TI("<vec>")));
	TCOMPU("<function>", fu_make_list("xxx",
				fu_symbol("union"),
				TI("<cons>"),
				TI("<null>")));
}

RES *
fu_type(des)
	RES *des;
{
	RES *p;
	MK_COMPUESTO(p, des);
	return p;
}
#undef TI
#undef BIND
#undef MK_BUILTIN
#undef MK_COMPUESTO
#undef TBUILT
#undef TCOMPU

RES *
fu_typep(tipo, expr)
	RES *tipo, *expr;
{
	TIPO *t;

	if (!TIPO_P(tipo_tipo, tipo))	
		fu_throw(fu_symbol("&wrong-type-arg"),
			fu_str("typep -- el primer argumento debe ser un tipo"));

	t = VAL_TIPO(tipo);

	if (TIPO_BUILTIN_P(t)) {
		int tag = TIPO_BUILT(t);

		switch (tag) {
		case tipo_magic_int:
			return INT_P(expr) ? T : NIL;
		case tipo_magic_char:
			return CHAR_P(expr) ? T : NIL;
		case tipo_magic_cons:
			return CONS_P(expr) ? T : NIL;
		case tipo_magic_null:
			return (expr == NIL) ? T : NIL;
		case tipo_magic_t:
			return (expr == T) ? T : NIL;
		case tipo_magic_eof:
			return (expr == EOF_OBJECT) ? T : NIL;
		case tipo_magic_undef:
			return (expr == UNDEF) ? T : NIL;
		case tipo_magic_macro:
			return MACROP(expr) ? T : NIL;
		case tipo_magic_str:
			return STR_P(expr) ? T : NIL;
		case tipo_magic_hash:
			return HASH_P(expr) ? T : NIL;
		case tipo_magic_any:
			return T;
		default:
			return (TIPO_P(TIPO_BUILT(t), expr)) ? T : NIL;
		}
	} else {
		RES *des = TIPO_DES(t);
		RES *op;

		if (!CONS_P(des))
			fu_throw(fu_symbol("&wrong-type-arg"),
				fu_str("typep -- no es un tipo valido"));

		op = CAR(des);
		if ( op == fu_symbol("union") ) {
			RES *p;
			/* or */
			for (p = CDR(des); CONS_P(p); p = CDR(p) )
				if (fu_typep(CAR(p), expr) != NIL) return T;
			return NIL;
		}
		else if ( op == fu_symbol("intersection") ) {
			RES *p;
			/* and */
			for (p = CDR(des); CONS_P(p); p = CDR(p) )
				if (fu_typep(CAR(p), expr) == NIL) return NIL;
			return T;
		}
		else if ( op == fu_symbol("satisfies") ) {
			RES *p;
			if (!CONS_P(CDR(des)))
				fu_throw(fu_symbol("&wrong-type"),
					fu_str("typep -- tipo deforme"));
			p = CADR(des);
			return (fu_apply(p, fu_cons(expr, NIL)) != NIL) ? T : NIL;
		}
	}
}

RES *
fu_check(tipo, expr)
	RES *tipo, *expr;
{
	if (fu_typep(tipo, expr) == NIL)
		fu_throw(fu_symbol("&wrong-type"),
			fu_str("check -- la expresion no es del tipo esperado"));
	return expr;
}
