#include "Fu.h"

/* algunas funciones comunes */

RES *
fu_eq(v,w)
		RES *v, *w;
{
	return ( v == w ) ? T : NIL;
}

RES *
fu_null(v)
		RES *v;
{
	return ( v == NIL ) ? T : NIL;
}

RES *
map_seq(f, ls, guardap, car_cdr)
	RES *f, *ls;
	unsigned char guardap, car_cdr;
{
	unsigned i = 0;
	unsigned char macrop = MACROP(f);
	RES *resultado = NIL, *tmp, *args, *p;
	RES *listas = fu_copy_shallow(ls);

	if (!CONS_P(listas)) return NIL;
	while (TRUE) {
		args = NIL;
		for ( p = listas; CONS_P(p); p = CDR(p) ) {
			RES *v = CAR(p);
			if ( CONS_P(v) ) {
				args = fu_cons((car_cdr ? CAR(v) : CDR(v)), args);
				CAR(p) = CDR(v);
			} else if (NINMEDIATO_P(v)) {
				switch ( TIPO(v) ) {
					case tipo_vector:
					{
						VECTOR *w = VAL_VECTOR(v);
						unsigned l = VECTOR_LENGTH(w);

						if ( i >= l )
							goto fin_map;
						switch (VECTOR_TIPO(w)) {
						case vector_no_uniforme:
							args = fu_cons(VECTOR_ELEMENTO(w,i), args);
							break;
						case vector_uniforme_char:
							args = fu_cons(fu_char(VAL_STR(v)[i]), args);
							break;
						default:
							fu_throw(fu_symbol("&wrong-type-arg"),
								fu_str("map -- no es una secuencia"));
							break;
						}
						break;
					}
					default:
						fu_throw(fu_symbol("&wrong-type-arg"),
							fu_str("map -- no es una secuencia"));
						break;
				}
			} else {
				goto fin_map;
			}
		}
		tmp = fu_apply(f, fu_xrev(args));
		if (macrop)
			tmp = fu_eval(tmp);
		if (guardap)
			resultado = fu_cons(tmp, resultado);
		i++;
	}
fin_map:
	if (guardap)
		return fu_xrev(resultado);
	else
		return CAR(ls);
}

RES *
fu_map(f,ls)
	RES *f, *ls;
{
	return map_seq(f, ls, TRUE, TRUE);
}

RES *
fu_mapc(f,ls)
	RES *f, *ls;
{
	return map_seq(f, ls, FALSE, TRUE);
}

RES *
fu_maplist(f,ls)
	RES *f, *ls;
{
	return map_seq(f, ls, TRUE, FALSE);
}

RES *
fu_mapl(f,ls)
	RES *f, *ls;
{
	return map_seq(f, ls, FALSE, FALSE);
}

RES *
fu_length(v)
		RES *v;
{
	if (NULL_P(v)) {
			return fu_int(0);
	} else if (CONS_P(v)) {
			unsigned l = 0;
			RES *p;

			for (p = v; CONS_P(p); p = CDR(p)) l++;
			return fu_int(l);
	} else if (NINMEDIATO_P(v)) {
		switch ( TIPO(v) ) {
			case tipo_vector:
			{
				return fu_int(VECTOR_LENGTH(VAL_VECTOR(v)));
				break;
			}
		}
	}
	fu_throw(fu_symbol("&wrong-type-arg"),
		fu_str("len -- no es una secuencia"));
}

RES *
fu_xrev(v)
	RES *v;
{
	if (NULL_P(v)) {
			return NIL;
	} else if (CONS_P(v)) {
			RES *p = v, *anterior = NIL, *siguiente;

			while (TRUE) {
				siguiente = CDR(p);
				CDR(p) = anterior;
				anterior = p;
				if (!CONS_P(siguiente)) break;
				p = siguiente;
			}
			return p;
	} else if (NINMEDIATO_P(v)) {
		switch ( TIPO(v) ) {
			case tipo_vector:
			{
				VECTOR *w;

				w = VAL_VECTOR(v);
				switch (VECTOR_TIPO(w)) {
				case vector_no_uniforme: {
					unsigned i, l;
					RES **tabla = VECTOR_TABLA(w);
					RES *t;

					l = VECTOR_LENGTH(w) - 1;
					for ( i = 0; i < l; i++, l--) {
						t = tabla[l];
						tabla[l] = tabla[i];
						tabla[i] = t;
					}
					return v;
				}
				case vector_uniforme_char: {
					unsigned i, l;
					char *p = VAL_STR(v), *q, c;

					q = p + VECTOR_LENGTH(w) - 1;
					for ( ; p < q; p++, q--) {
						c = *p;
						*p = *q;
						*q = c;
					}
					return v;
				}
				}
				break;
			}
		}
	}
	fu_throw(fu_symbol("&wrong-type-arg"),
		fu_str("xrev -- no es una secuencia"));
}

RES *
fu_rev(v)
	RES *v;
{
	if (NULL_P(v)) {
			return NIL;
	} else if (CONS_P(v)) {
			RES *p, *final = NIL;

			for ( p = v; CONS_P(p); p = CDR(p))
				final = fu_cons(CAR(p), final);
			return final;
	} else if (NINMEDIATO_P(v)) {
		switch ( TIPO(v) ) {
			case tipo_vector:
			{
				VECTOR *w;

				w = VAL_VECTOR(v);
				switch (VECTOR_TIPO(w)) {
				case vector_no_uniforme: {
					unsigned i, l;
					RES **copia, *resultado;

					l = VECTOR_LENGTH(w);
					copia = NEWQ(RES *, l);
					for ( i = 0; i < l; i++ )
						copia[i] = VECTOR_ELEMENTO(w, l-i-1);
					resultado = fu_empty_vector(l);
					VECTOR_TABLA(VAL_VECTOR(resultado)) = copia;
					VECTOR_TIPO(VAL_VECTOR(resultado)) = vector_no_uniforme;
					return resultado;
				}
				case vector_uniforme_char: {
					unsigned i, l;
					char *original = VAL_STR(v), *copia;

					l = VECTOR_LENGTH(w);
					copia = NEWQ(char, l);
					for ( i = 0; i < l; i++)
						copia[i] = original[l-i-1];
					return fu_str(copia);
				}
				}
				break;
			}
		}
	}
	fu_throw(fu_symbol("&wrong-type-arg"),
		fu_str("xrev -- no es una secuencia"));
}

RES *
fu_elt(idx, v)
	RES *idx, *v;
{
	if ( NULL_P(v) || CONS_P(v)) {
		return fu_nth(v, idx);
	} else if (NINMEDIATO_P(v)) {
		switch ( TIPO(v) ) {
			case tipo_vector:
			{
				switch (VECTOR_TIPO(VAL_VECTOR(v))) {
				case vector_uniforme_char:
				case vector_no_uniforme:
					return fu_get_vector(v, idx);
				case vector_hash: {
					RES *r;
					
					r = fu_get_hash_eq(v, idx);
					if (CONS_P(r))
						return CDR(r);
					else
						fu_throw(fu_symbol("&key-error"),
							fu_str("elt -- el hash no contiene esa clave"));
				}
				}
				break;
			}
		}
	}
	fu_throw(fu_symbol("&wrong-type-arg"),
		fu_str("elt -- no es una secuencia"));
}

RES *
fu_elt_set(idx, v, valor)
	RES *idx, *v, *valor;
{
	if ( NULL_P(v) || CONS_P(v) ) {
		return fu_nth_set(v, idx, valor);
	} else if (NINMEDIATO_P(v)) {
		switch ( TIPO(v) ) {
			case tipo_vector:
			{
				switch (VECTOR_TIPO(VAL_VECTOR(v))) {
				case vector_uniforme_char:
				case vector_no_uniforme:
					fu_set_vector(v, idx, valor);
					return valor;
				case vector_hash:
					fu_set_hash_eq(v, idx, valor);
					return valor;
				}
				break;
			}
		}
	}
	fu_throw(fu_symbol("&wrong-type-arg"),
		fu_str("elt_set -- no es una secuencia"));
}

RES *
fu_copy_shallow(v)
		RES *v;
{
	if (NULL_P(v)) {
			return NIL;
	} else if (CONS_P(v)) {
			RES *p, *final = NIL, *ultimo;

			for ( p = v; CONS_P(p); p = CDR(p) ) {
				final = fu_cons(CAR(p), final);
			}
			ultimo = final;
			final = fu_xrev(final);
			CDR(ultimo) = p;
			return final;
	} else if (NINMEDIATO_P(v)) {
		switch ( TIPO(v) ) {
			case tipo_vector:
			{
				VECTOR *w;

				w = VAL_VECTOR(v);
				switch (VECTOR_TIPO(w)) {
				case vector_no_uniforme: {
					RES *p;
					unsigned l;
					RES **copia;

					l = VECTOR_LENGTH(w);
					p = fu_empty_vector(l);
					copia = NEWQ(RES *, l);
					memcpy(copia, VECTOR_TABLA(w), sizeof(RES *) * l);
					VECTOR_TABLA(VAL_VECTOR(p)) = copia;
					VECTOR_TIPO(VAL_VECTOR(p)) = vector_no_uniforme;
					return p;
				}
				case vector_uniforme_char: {
					RES *p;
					unsigned l;
					char *copia;

					l = VECTOR_LENGTH(w);
					p = fu_empty_vector(l);
					copia = NEWQ(char, l+1);
					strncpy(copia, VAL_STR(v), l);
					copia[l] = '\0';
					VECTOR_TABLA(VAL_VECTOR(p)) = (RES **) copia;
					VECTOR_TIPO(VAL_VECTOR(p)) = vector_uniforme_char;
					return p;
				}
				}
				break;
			}
		}
	}
	fu_throw(fu_symbol("&wrong-type-arg"),
		fu_str("copy -- no es una secuencia"));
}

RES *
fu_cat(seqs)
		RES *seqs;
{
	/* el tipo de la primera secuencia determina el tipo
	 * que deben tener las restantes y el tipo del resultado
	 */
	RES *v = CAR(seqs);

	if (NULL_P(v) || CONS_P(v)) {
		RES *l, *p, *final = NIL;

		for ( l = seqs; CONS_P(l); l = CDR(l) ) {
			if (!CONS_P(CAR(l)) && !NULL_P(CAR(l)))
				fu_throw(fu_symbol("&wrong-type-arg"),
					fu_str("cat -- secuencias de distintos tipos"));
			for ( p = CAR(l); CONS_P(p); p = CDR(p) ) {
				final = fu_cons(CAR(p), final);
			}
		}
		return fu_xrev(final);
	} else if (NINMEDIATO_P(v)) {
		switch ( TIPO(v) ) {
			case tipo_vector:
			{
				VECTOR *w;

				switch (VECTOR_TIPO(VAL_VECTOR(v))) {
				case vector_no_uniforme: {
					RES *v1, *p;
					unsigned l = 0;
					RES **datos, **actual;

					for ( v1 = seqs; CONS_P(v1); v1 = CDR(v1)) {
						if (!VECTOR_NO_UNIFORME_P(CAR(v1)))
							fu_throw(fu_symbol("&wrong-type-arg"),
								fu_str("cat -- secuencias de distintos tipos"));
						l += VECTOR_LENGTH(VAL_VECTOR(CAR(v1)));
					}
					p = fu_empty_vector(l);
					actual = datos = NEWQ(RES *, l);
					for ( v1 = seqs; CONS_P(v1); v1 = CDR(v1)) {
						VECTOR *w1 = VAL_VECTOR(CAR(v1));
						unsigned l1 = VECTOR_LENGTH(w1);

						memcpy(actual,
								VECTOR_TABLA(w1),
								sizeof(RES *) * l1);
						actual += l1;
					}
					VECTOR_TABLA(VAL_VECTOR(p)) = datos;
					VECTOR_TIPO(VAL_VECTOR(p)) = vector_no_uniforme;
					return p;
				}
				case vector_uniforme_char: {
					RES *v1, *p;
					unsigned l = 0;
					char *datos, *actual;

					for ( v1 = seqs; CONS_P(v1); v1 = CDR(v1)) {
						if (!STR_P(CAR(v1)))
							fu_throw(fu_symbol("&wrong-type-arg"),
								fu_str("cat -- secuencias de distintos tipos"));
						l += VECTOR_LENGTH(VAL_VECTOR(CAR(v1)));
					}
					p = fu_empty_vector(l);
					actual = datos = NEWQ(char, l+1);
					for ( v1 = seqs; CONS_P(v1); v1 = CDR(v1)) {
						VECTOR *w1 = VAL_VECTOR(CAR(v1));
						unsigned l1 = VECTOR_LENGTH(w1);

						strncpy(actual, VAL_STR(CAR(v1)), l1);
						actual[l1] = '\0';
						actual += l1;
					}
					VECTOR_TABLA(VAL_VECTOR(p)) = (RES **) datos;
					VECTOR_TIPO(VAL_VECTOR(p)) = vector_uniforme_char;
					return p;
				}
				}
				break;
			}
		}
	}
	fu_throw(fu_symbol("&wrong-type-arg"),
		fu_str("cat -- no es una secuencia"));
}

#define COMPARAR(E1, E2, PRED) \
	((PRED == UNDEF)?\
	 (E1 == E2):\
	 !NULL_P(fu_apply(PRED, fu_cons(E1,fu_cons(E2,NIL)))))
RES *
fu_index(elt, v, pred)
	RES *elt, *v, *pred;
{
	if (NULL_P(v)) {
		fu_throw(fu_symbol("&index-error"),
			fu_str("index -- el elemento no esta en la secuencia"));
	} else if (CONS_P(v)) {
			unsigned i = 0;
			RES *p;

			for ( p = v; CONS_P(p); p = CDR(p), i++ ) {
				if (COMPARAR(elt, CAR(p), pred))
					return fu_int(i);
			}
			fu_throw(fu_symbol("&index-error"),
				fu_str("index -- el elemento no esta en la secuencia"));
	} else if (NINMEDIATO_P(v)) {
		switch ( TIPO(v) ) {
			case tipo_vector:
			{
				VECTOR *w;

				w = VAL_VECTOR(v);
				switch (VECTOR_TIPO(w)) {
				case vector_no_uniforme: {
					unsigned i, l;

					l = VECTOR_LENGTH(w);
					for ( i = 0; i < l; i++ ) {
						if (COMPARAR(elt, VECTOR_ELEMENTO(w, i), pred))
							return fu_int(i);
					}
					fu_throw(fu_symbol("&index-error"),
						fu_str("index -- el elemento no esta en la secuencia"));
				}
				case vector_uniforme_char: {
					char *c, *s;

					if (!CHAR_P(elt))
						fu_throw(fu_symbol("&wrong-type"),
							fu_str("index -- el elemento no es un caracter"));
					s = VAL_STR(v);
					for ( c = s; *c; c++ )
						if (COMPARAR(elt, fu_char(*c), pred))
							return fu_int(c-s);
					fu_throw(fu_symbol("&index-error"),
						fu_str("index -- el elemento no esta en la secuencia"));
				}
				}
				break;
			}
		}
	}
	fu_throw(fu_symbol("&wrong-type-arg"),
		fu_str("index -- no es una secuencia"));
}

RES *
fu_member(elt, v, pred)
	RES *elt, *v, *pred;
{
	if (NULL_P(v)) {
			return NIL;
	} else if (CONS_P(v)) {
			RES *p;

			for ( p = v; CONS_P(p); p = CDR(p) ) {
				if ( COMPARAR(elt, CAR(p), pred) )
					return p;
			}
			return NIL;
	}
	fu_throw(fu_symbol("&wrong-type-arg"),
		fu_str("member -- no es una lista"));
}

RES *
fu_assoc(elt, v, pred)
	RES *elt, *v, *pred;
{
	if (NULL_P(v)) {
			return NIL;
	} else if (CONS_P(v)) {
			RES *p;

			for ( p = v; CONS_P(p); p = CDR(p) ) {
				if (!CONS_P(CAR(p)))
					fu_throw(fu_symbol("&wrong-type-arg"),
						fu_str("assoc -- no es una lista de asociacion"));
				if (COMPARAR(elt, CAAR(p), pred) )
					return CAR(p);
			}
			return NIL;
	}
	fu_throw(fu_symbol("&wrong-type-arg"),
		fu_str("assoc -- no es una lista"));
}
#undef COMPARAR

RES *
fu_last(lista)
	RES *lista;
{
	if (NULL_P(lista))
		return NIL;
	else if (CONS_P(lista)) {
		RES *p;

		for (p = lista; CONS_P(CDR(p)); p = CDR(p));
		return p;
	}
	fu_throw(fu_symbol("&wrong-type-arg"),
		fu_str("last -- no es una lista"));
}

RES *
fu_range(x,y,z)
		RES *x, *y, *z;
{
	RES *resultado = NIL;
	int termina, empieza = 0, step = 1, i;

	if (!INT_P(x))
		fu_throw(fu_symbol("&wrong-type-arg"),
			fu_str("range -- el primer argumento no es entero"));

	if (y == UNDEF) {
		termina = VAL_INT(x);
	} else {
		if (!INT_P(y))
			fu_throw(fu_symbol("&wrong-type-arg"),
				fu_str("range -- el segundo argumento no es entero"));
		empieza = VAL_INT(x);
		termina = VAL_INT(y);
		if (z != UNDEF) {
				if (!INT_P(z))
					fu_throw(fu_symbol("&wrong-type-arg"),
						fu_str("range -- el tercer argumento no es entero"));
				step = VAL_INT(z);
				if (step == 0)
					return NIL;
		}
	}

	if (step > 0)
		for ( i = empieza; i < termina; i += step)
			resultado = fu_cons(fu_int(i), resultado);
	else
		for ( i = empieza; i > termina; i += step)
			resultado = fu_cons(fu_int(i), resultado);

	return fu_xrev(resultado);
}

RES *
fu_iota(x,y,z)
		RES *x, *y, *z;
{
	RES *resultado = NIL;
	int cuenta, empieza = 0, step = 1, i;

	if (!INT_P(x))
		fu_throw(fu_symbol("&wrong-type-arg"),
			fu_str("iota -- la cantidad no es entera"));

	cuenta = VAL_INT(x);
	if (y != UNDEF) {
		if (!INT_P(y))
			fu_throw(fu_symbol("&wrong-type-arg"),
				fu_str("iota -- el inicio no es un entero"));
		empieza = VAL_INT(y);
		if (z != UNDEF) {
				if (!INT_P(z))
					fu_throw(fu_symbol("&wrong-type-arg"),
						fu_str("iota -- el step no es un entero"));
				step = VAL_INT(z);
		}
	}

	for ( i = 0; i < cuenta; i++)
		resultado = fu_cons(fu_int(empieza + i * step), resultado);

	return fu_xrev(resultado);
}

RES *
fu_fread(archivo)
	RES *archivo;
{
		RES *arch, *last = NIL;
		FILE *f;

		if (!STR_P(archivo))
			fu_throw(fu_symbol("&wrong-type-arg"),
				fu_str("fread -- el archivo debe ser una cadena"));

		if ( !(f = fopen(VAL_STR(archivo),"r"))) {
			fu_throw(fu_symbol("&system-error"),
				fu_str("fread -- no se puede leer del archivo"));
		}
		arch = fu_reader(fu_port(f), FALSE);
		while (f) {
			RES *sexpr;
			sexpr = fu_read(arch);
			if (sexpr == EOF_OBJECT)
				break;
			else
				last = fu_cons(sexpr, last);
		}
		if (fclose(f)) {
			fu_throw(fu_symbol("&system-error"),
				fu_str("fread -- no se puede cerrar el archivo"));
		}
		return fu_xrev(last);
}

RES *
fu_load(archivo)
	RES *archivo;
{
		RES *arch, *last = NIL;
		FILE *f;

		if (!STR_P(archivo))
			fu_throw(fu_symbol("&wrong-type-arg"),
				fu_str("load -- el archivo debe ser una cadena"));

		if ( !(f = fopen(VAL_STR(archivo),"r"))) {
			fu_throw(fu_symbol("&system-error"),
				fu_str("load -- no se puede leer del archivo"));
		}
		arch = fu_reader(fu_port(f), FALSE);
		while (f) {
			RES *sexpr;
			sexpr = fu_read(arch);
			if (sexpr == EOF_OBJECT)
				break;
			else
				last = fu_eval(sexpr);
		}
		if (fclose(f)) {
			fu_throw(fu_symbol("&system-error"),
				fu_str("load -- no se puede cerrar el archivo"));
		}
		return last;
}

RES *
fu_import(archivo)
	RES *archivo;
{
		RES *last;

		fu_push_env();
		fu_load(archivo);
		last = fu_env();
		fu_pop_env();
		return CAR(last);
}

RES *
fu_run(archivo)
	RES *archivo;
{
		RES *last;

		fu_push_env();
		last = fu_load(archivo);
		fu_env();
		fu_pop_env();
		return last;
}

RES *
fu_die(mensaje, valor)
		RES *mensaje, *valor;
{
	int v = 1;
	if (valor != UNDEF && INT_P(valor))
		v = VAL_INT(v);
	if (mensaje != UNDEF)
		fu_pr(mensaje, Std_Error);
	exit(v);
}

RES *
fu_exit(valor)
	RES *valor;
{
	int v = 0;
	if (valor != UNDEF && INT_P(valor))
		v = VAL_INT(v);
	exit(v);
}

RES *
fu_sys(args)
	RES *args;
{
	return fu_int(system(VAL_STR(fu_mkstr(args))));
}
