typedef struct _proc PROC;
struct _proc {
	struct _res *(*funcion)();
	unsigned char nargs, nopts, flags;
};

/* PROTOS */
RES *fu_apply(RES *val, RES *args);
RES *fu_make_proc(RES *(*funcion)(), unsigned char nargs, unsigned char nopts,
										unsigned char restp);
RES *fu_apply_proc(RES *proc, RES *args);

#define MAX_PROC_ARGS 10

/* MACROS */
#define VAL_PROC(R)	((PROC *) VAL(R))

#define PROC_FUNCION(P)	((P)->funcion)
#define PROC_NARGS(P)	((P)->nargs)
#define PROC_NOPTS(P)	((P)->nopts)

#define PROC_RESTP(P)		((P)->flags & 1)
#define PROC_REST_SET(P)	((P)->flags |= 1)
#define PROC_REST_UNSET(P)	((P)->flags &= ~1)

#define PROC_MACRO(P)		((P)->flags & 2)
#define PROC_MACRO_SET(P)	((P)->flags |= 2)
#define PROC_MACRO_UNSET(P)	((P)->flags &= ~2)

#define MACROP(X)	((TIPO_P(tipo_proc,X) && PROC_MACRO(VAL_PROC(X))) || (TIPO_P(tipo_closure,X) && CLOSURE_MACRO(VAL_CLOSURE(X))))
