%{
#include "Fu.h"
%}
%union {
	RES *val;
}
%token T_LPAREN T_RPAREN T_DOT T_EOF
%token T_QUOTE T_BACKQUOTE T_UNQUOTE_SPLICING T_UNQUOTE
%token <val> T_ATOM T_ATOM_DOT T_EQUAL_ATOM T_CADENA_INTERPOLADA

%type <val> sexpr expr expr_list expr_dot
%start sexpr
%%
sexpr:	expr				{ Read_Sexpr = $1; return; }
|		T_EOF				{ Read_Sexpr = EOF_OBJECT; return; }
;

expr:	T_ATOM
|	T_CADENA_INTERPOLADA
|	T_LPAREN expr_list T_RPAREN	{ $$ = $2; }
|	T_QUOTE expr	{ $$ = fu_make_list("xx", fu_symbol("quote"), $2); }
|	T_BACKQUOTE expr{ $$ = fu_make_list("xx", fu_symbol("backquote"), $2); }
|	T_UNQUOTE expr	{ $$ = fu_make_list("xx", fu_symbol("unquote"), $2); }
|	T_UNQUOTE_SPLICING expr	{ $$ = fu_make_list("xx", fu_symbol("unquote-splicing"), $2); }
|	expr_dot T_ATOM { $$ = fu_make_list("xx", $1,
				fu_make_list("xx", fu_symbol("quote"), $2)); }
|	T_EQUAL_ATOM expr { $$ = fu_make_list("xxx", ARGSET,
									fu_make_list("xx", fu_symbol("quote"), $1),
									$2); }
;

expr_dot :
	T_ATOM_DOT
|	expr_dot T_ATOM_DOT { $$ = fu_make_list("xx", $1,
				fu_make_list("xx", fu_symbol("quote"), $2)); }
;

expr_list:	expr expr_list		{ $$ = fu_cons($1, $2); }
|		T_DOT expr		{ $$ = $2; }
|		/* vacia */		{ $$ = NIL; }
;
%%

yywrap() {}

yyerror(s)
	char *s;
{
	fu_throw(fu_symbol("&parse-error"),
				fu_str(s));
}
