#include "Fu.h"

__inline__ RES *
fu_int(i)
	int i;
{
	return (RES *) ((i << 2) | 1);
}

RES *
fu_int_sumar(resto)
	RES *resto;
{
	RES *v, *p;

	v = fu_int(0);
	for (p = resto; CONS_P(p); p = CDR(p)) {
		if (!INT_P(CAR(p))) {
			fu_throw(fu_symbol("&wrong-type-arg"),
				fu_str("int_sumar -- no son enteros"));
		}
		v = fu_int(VAL_INT(v) + VAL_INT(CAR(p)));
	}
	return v;
}

RES *
fu_int_restar(resto)
	RES *resto;
{
	RES *v, *p;

	if ( !CONS_P(resto))
		v = fu_int(0);
	else {
		v = fu_int(VAL_INT(CAR(resto)));
 		if (NULL_P(CDR(resto)))
			v = fu_int(-VAL_INT(v));
		for (p = CDR(resto); CONS_P(p); p = CDR(p)) {
			if (!INT_P(CAR(p)))
				fu_throw(fu_symbol("&wrong-type-arg"),
					fu_str("int_restar -- no son enteros"));
			v = fu_int(VAL_INT(v) - VAL_INT(CAR(p)));
		}
	}
	return v;
}

RES *
fu_int_multiplicar(resto)
	RES *resto;
{
	RES *v, *p;

	v = fu_int(1);
	for (p = resto; CONS_P(p); p = CDR(p)) {
		if (!INT_P(CAR(p))) {
			fu_throw(fu_symbol("&wrong-type-arg"),
				fu_str("int_multiplicar -- no son enteros"));
		}
		v = fu_int(VAL_INT(v) * VAL_INT(CAR(p)));
	}
	return v;
}

RES *
fu_int_menor(resto)
	RES *resto;
{
	int ant, sig;
	char primero = TRUE;
	RES *p;

	for (p = resto; CONS_P(p); p = CDR(p)) {
		if (!INT_P(CAR(p)))
			fu_throw(fu_symbol("&wrong-type-arg"),
				fu_str("int_menor -- no son enteros"));
		if ( (ant < (sig = VAL_INT(CAR(p)))) || primero )
			ant = sig;
		else
			return NIL;

		if (primero) primero = FALSE;
	}
	return T;
}

RES *
fu_int_mayor(resto)
	RES *resto;
{
	int ant, sig;
	char primero = TRUE;
	RES *p;

	for (p = resto; CONS_P(p); p = CDR(p)) {
		if (!INT_P(CAR(p)))
			fu_throw(fu_symbol("&wrong-type-arg"),
				fu_str("int_menor -- no son enteros"));
		if ( (ant > (sig = VAL_INT(CAR(p)))) || primero )
			ant = sig;
		else
			return NIL;

		if (primero) primero = FALSE;
	}
	return T;
}
