#include "Fu.h"

#define BIND(SYMB, COSA)	fu_def_env(fu_symbol(SYMB), COSA)
#define CON_SETTER(SYMB, COSA, SETTER)	{\
				RES *_pr;\
				_pr = COSA;\
				BIND(SYMB, _pr);\
				fu_setter_set(_pr, SETTER);\
				}
#define INLINE(SYMB, COSA, INLINED)	{\
				RES *_pr;\
				_pr = COSA;\
				BIND(SYMB, _pr);\
				fu_inlined_set(_pr, INLINED);\
				}
#define INLINE_CON_SETTER(SYMB, COSA, INLINED, SETTER)	{\
				RES *_pr;\
				_pr = COSA;\
				BIND(SYMB, _pr);\
				fu_inlined_set(_pr, INLINED);\
				fu_setter_set(_pr, SETTER);\
				}
void
fu_init_builtins()
{
		RES *p;

		BIND("cons", fu_make_proc(fu_cons, 2, 0, 0));

		INLINE_CON_SETTER("car",
						fu_make_proc(fu_car, 1, 0, 0),
						special_form_car,
						fu_make_proc(fu_car_set, 2, 0, 0));
		INLINE_CON_SETTER("cdr",
						fu_make_proc(fu_cdr, 1, 0, 0),
						special_form_cdr,
						fu_make_proc(fu_cdr_set, 2, 0, 0));

		BIND("+", fu_make_proc(fu_int_sumar, 0, 0, 1));
		BIND("-", fu_make_proc(fu_int_restar, 0, 0, 1));
		BIND("*", fu_make_proc(fu_int_multiplicar, 0, 0, 1));
		BIND("<", fu_make_proc(fu_int_menor, 0, 0, 1));
		BIND(">", fu_make_proc(fu_int_mayor, 0, 0, 1));
		BIND("env", fu_make_proc(fu_env, 0, 0, 0));
		INLINE("dir", fu_make_proc(fu_dir, 0, 0, 0),
						special_form_dir);
		BIND("eval", fu_make_proc(fu_eval, 1, 0, 0));
		BIND("read", fu_make_proc(fu_read, 0, 1, 0));
		BIND("stread", fu_make_proc(fu_stread, 1, 0, 0));
		INLINE("eq", fu_make_proc(fu_eq, 2, 0, 0),
						special_form_eq);

		p = fu_make_proc(fu_null, 1, 0, 0);
		BIND("null", p);
		INLINE("not", p, special_form_not);

		BIND("err", fu_make_proc(fu_throw, 1, 1, 0));
		BIND("handle", fu_make_proc(fu_handle, 3, 0, 0));
		BIND("map", fu_make_proc(fu_map, 1, 0, 1));
		BIND("mapc", fu_make_proc(fu_mapc, 1, 0, 1));
		BIND("maplist", fu_make_proc(fu_maplist, 1, 0, 1));
		BIND("mapl", fu_make_proc(fu_mapl, 1, 0, 1));
		BIND("list", fu_make_proc(fu_list, 0, 0, 1));
		BIND("list*", fu_make_proc(fu_list_1, 0, 0, 1));
		BIND("vec", fu_make_proc(fu_vector_builtin, 0, 0, 1));
		BIND("mkvec", fu_make_proc(fu_make_vector, 1, 1, 0));
		BIND("consp", fu_make_proc(fu_consp, 1, 0, 0));
		BIND("ord", fu_make_proc(fu_char_int, 1, 0, 0));
		BIND("chr", fu_make_proc(fu_int_char, 1, 0, 0));
		BIND("gensym", fu_make_proc(fu_gensym, 0, 0, 0));
		BIND("call", fu_make_proc(fu_apply, 2, 0, 0));

		/* cadenas */
		BIND("str", fu_make_proc(fu_mkstr, 0, 0, 1));
		BIND("fmt", fu_make_proc(fu_fmt, 1, 0, 1));
		BIND("num->str", fu_make_proc(fu_num_to_str, 1, 5, 0));
		BIND("sym", fu_make_proc(fu_mksym, 0, 0, 1));

		/* secuencias */
		BIND("cat", fu_make_proc(fu_cat, 0, 0, 1));
		BIND("len", fu_make_proc(fu_length, 1, 0, 0));
		BIND("rev", fu_make_proc(fu_rev, 1, 0, 0));
		BIND("xrev", fu_make_proc(fu_xrev, 1, 0, 0));
		CON_SETTER("elt", fu_make_proc(fu_elt, 2, 0, 0),
						  fu_make_proc(fu_elt_set, 3, 0, 0));
		BIND("copy", fu_make_proc(fu_copy_shallow, 1, 0, 0));
		BIND("index", fu_make_proc(fu_index, 2, 1, 0));

		/* listas */
		CON_SETTER("nth", fu_make_proc(fu_nth, 2, 0, 0),
						  fu_make_proc(fu_nth_set, 3, 0, 0));
		CON_SETTER("ntl", fu_make_proc(fu_ntl, 2, 0, 0),
						  fu_make_proc(fu_ntl_set, 3, 0, 0));
		BIND("member", fu_make_proc(fu_member, 2, 1, 0));
		BIND("assoc", fu_make_proc(fu_assoc, 2, 1, 0));
		BIND("last", fu_make_proc(fu_last, 1, 0, 0));
		BIND("range", fu_make_proc(fu_range, 1, 2, 0));
		BIND("iota", fu_make_proc(fu_iota, 1, 2, 0));

		/* vectores */
		CON_SETTER("vref", fu_make_proc(fu_get_vector, 2, 0, 0),
						   fu_make_proc(fu_set_vector, 3, 0, 0));

		/* hashes */
		CON_SETTER("get", fu_make_proc(fu_get_hash_eq, 2, 0, 0),
						   fu_make_proc(fu_set_hash_eq, 3, 0, 0));
		CON_SETTER("hget", fu_make_proc(fu_get_hash, 2, 0, 0),
						  fu_make_proc(fu_set_hash, 3, 0, 0));
		CON_SETTER("fget", fu_make_proc(fu_get_hash_f, 4, 0, 0),
						   fu_make_proc(fu_set_hash_f, 5, 0, 0));

		BIND("db", fu_make_proc(fu_db, 0, 0, 1));
		BIND("mkdic", fu_make_proc(fu_make_hash, 0, 1, 0));

		/* archivos */
		BIND("load", fu_make_proc(fu_load, 1, 0, 0));
		BIND("import", fu_make_proc(fu_import, 1, 0, 0));
		BIND("run", fu_make_proc(fu_run, 1, 0, 0));
		BIND("fread", fu_make_proc(fu_fread, 1, 0, 0));

		BIND("sys", fu_make_proc(fu_sys, 0, 0, 1));

		/* finalizacion */
		BIND("die", fu_make_proc(fu_die, 0, 2, 0));
		BIND("exit", fu_make_proc(fu_exit, 0, 1, 0));

		/* output */
		BIND("out", fu_make_proc(fu_fprint, 1, 2, 0));
		BIND("pr", fu_make_proc(fu_pr, 1, 1, 0));
		BIND("pr1", fu_make_proc(fu_pr1, 1, 1, 0));
		BIND("wr", fu_make_proc(fu_wr, 1, 1, 0));
		BIND("wr1", fu_make_proc(fu_wr1, 1, 1, 0));
		BIND("cr", fu_make_proc(fu_cr, 0, 1, 0));
		BIND("lf", fu_make_proc(fu_lf, 0, 1, 0));
		BIND("crlf", fu_make_proc(fu_crlf, 0, 1, 0));

		/* tipos */
		BIND("typep", fu_make_proc(fu_typep, 2, 0, 0));
		BIND("type", fu_make_proc(fu_type, 1, 0, 0));
		BIND("check", fu_make_proc(fu_check, 2, 0, 0));

		CON_SETTER("setter", fu_make_proc(fu_setter, 1, 0, 0),
					   fu_make_proc(fu_setter_set, 2, 0, 0));
		CON_SETTER("inlined", fu_make_proc(fu_inlined, 1, 0, 0),
					   fu_make_proc(fu_inlined_set, 2, 0, 0));

		/* variables */
		BIND("*stdin*", Std_Input);
		BIND("*stdout*", Std_Output);
		BIND("*stderr*", Std_Error);
}
#undef BIND
