#include "Fu.h"
#include <fcntl.h>
#include <linux/kd.h>

#ifndef CLOCK_TICK_RATE
#define CLOCK_TICK_RATE 1193180
#endif

int fd = -1;

/* codigo robado de V01D y adaptado para Funes */
/* gracias V01D ! */
RES *
fu_sound(f_freq, f_duration, f_rep, f_delay)
	RES *f_freq, *f_duration, *f_rep, *f_delay;
{
	float freq;
	unsigned int duration, rep, delay;
	unsigned int i;

	if (f_freq != UNDEF && !FLOAT_P(f_freq) && ! INT_P(f_freq))
		fu_throw(fu_symbol("&wrong-type-arg"),
			fu_str("snd -- la frecuencia no es un numero"));

	freq = (f_freq == UNDEF) ? 220 :
			(INT_P(f_freq)
				? (float) VAL_INT(f_freq)
				: VAL_FLOAT(f_freq));
	duration = (f_duration == UNDEF) ? 100 : VAL_INT(f_duration);
	rep = (f_rep == UNDEF) ? 1 : VAL_INT(f_rep);
	delay = (f_delay == UNDEF) ? 0 : VAL_INT(f_delay);

	if ((fd = open(ctermid(NULL), O_WRONLY)) == -1) return NIL;

	for (i = 0; i < rep; i++) {
		if (freq > 0 && ioctl(fd, KIOCSOUND, (int)(CLOCK_TICK_RATE/(float) freq)) < 0) {
			perror("ioctl");
		}
		usleep(1000*duration);

		if (delay > 0) {
			ioctl(fd, KIOCSOUND, 0);
			if(rep > 1) usleep(1000*delay);
		}
	}

	ioctl(fd, KIOCSOUND, 0);	
	close(fd); fd = -1;
	return T;
}
