%{
#include "Fu.h"
%}
%union {
	RES *val;
}
%token T_LPAREN T_RPAREN T_DOT T_EOF
%token T_QUOTE T_BACKQUOTE T_UNQUOTE_SPLICING T_UNQUOTE
%token <val> T_ATOM T_ATOM_DOT T_EQUAL_ATOM T_CADENA_INTERPOLADA
%token REGEXP_START REGEXP_END REGEXP_CLOSURE REGEXP_OR
%token <val> REGEXP_ATOM

%type <val> sexpr expr expr_list expr_dot
%type <val> regexp regexp_cat regexp_or regexp_clos regexp_atom

%start sexpr

%left REGEXP_OR
%left REGEXP_CLOSURE

%%
sexpr:	expr				{ Read_Sexpr = $1; return; }
|		T_EOF				{ Read_Sexpr = EOF_OBJECT; return; }
;

expr:	T_ATOM
|	T_CADENA_INTERPOLADA
|	T_LPAREN expr_list T_RPAREN	{ $$ = $2; }
|	T_QUOTE expr	{ $$ = fu_make_list("xx", fu_symbol("quote"), $2); }
|	T_BACKQUOTE expr{ $$ = fu_make_list("xx", fu_symbol("backquote"), $2); }
|	T_UNQUOTE expr	{ $$ = fu_make_list("xx", fu_symbol("unquote"), $2); }
|	T_UNQUOTE_SPLICING expr	{ $$ = fu_make_list("xx", fu_symbol("unquote-splicing"), $2); }
|	expr_dot T_ATOM { $$ = fu_make_list("xx", $1,
				fu_make_list("xx", fu_symbol("quote"), $2)); }
|	T_EQUAL_ATOM expr { $$ = fu_make_list("xxx", ARGSET,
									fu_make_list("xx", fu_symbol("quote"), $1),
									$2); }
|	REGEXP_START regexp REGEXP_END { $$ = fu_make_list("xx", fu_symbol("quote"),
														$2); }
;

expr_dot :
	T_ATOM_DOT
|	expr_dot T_ATOM_DOT { $$ = fu_make_list("xx", $1,
				fu_make_list("xx", fu_symbol("quote"), $2)); }
;

expr_list:	expr expr_list		{ $$ = fu_cons($1, $2); }
|		T_DOT expr		{ $$ = $2; }
|		/* vacia */		{ $$ = NIL; }
;

regexp:
		regexp_or
;

regexp_or :
		regexp_cat
|		regexp_or REGEXP_OR regexp_cat	{ $$ = fu_make_list("xxx",
										fu_symbol("or"),
										$1, $3); }
;

regexp_cat :
		regexp_clos
|		regexp_cat regexp_clos	{ $$ = fu_make_list("xxx",
										fu_symbol("cat"),
										$1, $2); }
;

regexp_clos :
		regexp_atom
|		regexp_atom REGEXP_CLOSURE	{ $$ = fu_make_list("xx",
										fu_symbol("clos"),
										$1); }
;

regexp_atom:
		T_LPAREN regexp T_RPAREN	{ $$ = $2; }
|		REGEXP_ATOM
;
%%

yywrap() {}

yyerror(s)
	char *s;
{
	fu_throw(fu_symbol("&parse-error"),
				fu_str(s));
}
