#include "Fu.h"

RES *
fu_macro_defmacro(nombre, llist, body)
	RES *nombre, *llist, *body;
{
	RES *macro;

	if (!CONS_P(body) && body != NIL)
		fu_throw(fu_symbol("&bad-argument"),
			fu_str("macro -- cuerpo deforme"));

	macro = fu_eval(fu_make_list("xxX",fu_symbol("fun"),llist,body));
	CLOSURE_MACRO_SET(VAL_CLOSURE(macro));
	fu_def_env(nombre, macro);
	return macro;
}

RES *
fu_macro_let(bindings, cuerpo)
	RES *bindings, *cuerpo;
{
	RES *v, *argumentos, *valores;

	argumentos = NIL;
	valores = NIL;

	if (!CONS_P(bindings) && bindings!=NIL) {
		fu_throw(fu_symbol("&bad-argument"),
			fu_str("let -- los bindings deben ser una lista"));
	}

	for ( v = bindings; CONS_P(v); v = CDR(v)) {
		RES *a, *b;
		if (CONS_P(CAR(v))) {
			a = CAAR(v);
			if (CONS_P(CDAR(v))) {
				b = CADAR(v);
			} else {
				fu_throw(fu_symbol("&bad-argument"),
					fu_str("let -- binding deforme"));
			}
		} else {
			a = CAR(v);
			b = NIL;
		}
		argumentos = fu_cons(a, argumentos);
		valores = fu_cons(b, valores);
	}

	return fu_cons(fu_make_list("xxX",
						fu_symbol("fun"),
						argumentos,
						cuerpo),
				valores);
}

RES *
fu_macro_nlet(nombre, bindings, cuerpo)
	RES *nombre, *bindings, *cuerpo;
{
	RES *v, *argumentos, *valores;

	argumentos = NIL;
	valores = NIL;

	if (!CONS_P(bindings) && bindings!=NIL) {
		fu_throw(fu_symbol("&bad-argument"),
			fu_str("nlet -- los bindings deben ser una lista"));
	}

	for ( v = bindings; CONS_P(v); v = CDR(v)) {
		RES *a, *b;
		if (CONS_P(CAR(v))) {
			a = CAAR(v);
			if (CONS_P(CDAR(v))) {
				b = CADAR(v);
			} else {
				fu_throw(fu_symbol("&bad-argument"),
					fu_str("nlet -- binding deforme"));
			}
		} else {
			a = CAR(v);
			b = NIL;
		}
		argumentos = fu_cons(a, argumentos);
		valores = fu_cons(b, valores);
	}

	return fu_make_list("xxxx",
					fu_symbol("let"),
					fu_make_list("x",
							fu_make_list("xx",
									nombre,
									NIL)),
					fu_make_list("xxx",
						fu_symbol("set"),
						nombre,
						fu_make_list("xxX",
							fu_symbol("fun"),
							fu_xrev(argumentos),
							cuerpo)),
					fu_cons(nombre, fu_xrev(valores)));
}

RES *
fu_macro_each(var, seq, cuerpo)
	RES *var, *seq, *cuerpo;
{
	/*
	 * (mapc (fun (<var>) . <cuerpo>) <seq>)
	 */
	return fu_make_list("xxx",
					fu_symbol("mapc"),
					fu_make_list("xxX",
						fu_symbol("fun"),
						fu_cons(var, NIL),
						cuerpo),
					seq);
}

RES *
fu_macro_to(var, rango, cuerpo)
	RES *var, *rango, *cuerpo;
{
	RES *inicio, *final, *step = fu_int(1);

	if (!CONS_P(rango))
		fu_throw(fu_symbol("&bad-argument"),
			fu_str("to -- el rango debe ser una lista"));

	if (CONS_P(CDR(rango))) {
		inicio = CAR(rango);
		final = CADR(rango);
		if (CONS_P(CDDR(rango)))
			step = CADDR(rango);
	} else {
		inicio = fu_int(0);
		final = CAR(rango);
	}

	/*
	 * (let ((<var> <inicio>))
	 *   (while (< <var> <final>)
	 *     <cuerpo>
	 *     (set <var> (+ <var> 1))))
	 *
	 */
	return fu_make_list("xxx",
			fu_symbol("let"),
			fu_cons(fu_make_list("xx", var, inicio), NIL),
			fu_make_list("xxxx",
				fu_symbol("while"),
				fu_make_list("xxx",
					fu_symbol("<"), var, final),
				fu_cons(fu_symbol("do"), cuerpo),
				fu_make_list("xxx",
					fu_symbol("set"),
					var,
					fu_make_list("xxx",
						fu_symbol("+"),
						var,
						step))));
}

RES *
fu_macro_try(expr, handler_case)
	RES *expr, *handler_case;
{
	unsigned char condicion_p = 1;
	RES *p, *resu = NIL;

	for ( p = handler_case; CONS_P(p); p = CDR(p)) {
		RES *car = CAR(p);

		if (!CONS_P(CDR(p))) {
			/* tengo el ultimo termino */
			if (condicion_p)
			/* si tocaba una condicion, es el else */
				resu = fu_cons(car, resu);
			else {
			/* si no, agrego un else (throwar de nuevo la
			 * excepcion */
				resu = fu_cons(car, resu);
				resu = fu_cons(fu_make_list("xxx",
										fu_symbol("err"),
										fu_symbol("exc"),
										fu_symbol("errstr")), resu);
			}
			break;
		}
		if (condicion_p) {
			resu = fu_cons(fu_make_list("xxx",
							fu_symbol("member"),
							fu_symbol("exc"),
							fu_make_list("xx",
								fu_symbol("quote"),
								(CONS_P(car)? car: fu_cons(car, NIL)))),
						resu);
		} else {
			resu = fu_cons(car, resu);
		}
		condicion_p = !condicion_p;
	}
	return fu_make_list("xxxx",
					fu_symbol("handle"),
					T,
					fu_make_list("xxx",
							fu_symbol("fun"),
							fu_make_list("xx", fu_symbol("exc"),
												fu_symbol("errstr")),
							fu_make_list("xX",
								fu_symbol("if"),
								fu_xrev(resu))),
					fu_make_list("xxx", fu_symbol("fun"), NIL, expr));
}

RES *
fu_macro_catch(exc, cuerpo)
	RES *exc, *cuerpo;
{
	return fu_make_list("xxxx",
					fu_symbol("handle"),
					exc,
					fu_make_list("xxx",
							fu_symbol("fun"),
							fu_make_list("xx", fu_symbol("exc"),
									fu_symbol("val")),
							fu_symbol("val")),
					fu_make_list("xxX", fu_symbol("fun"), NIL, cuerpo));
}

RES *
fu_macro_1_mas(n)
		RES *n;
{
		return fu_make_list("xxx", fu_symbol("+"), n, fu_int(1));
}

RES *
fu_macro_1_menos(n)
		RES *n;
{
		return fu_make_list("xxx", fu_symbol("-"), n, fu_int(1));
}

RES *
fu_macro_mas_mas(e,inc)
	RES *e, *inc;
{
	return fu_make_list("xxx", fu_symbol("set"), e,
						fu_make_list("xxx", fu_symbol("+"), e,
								(inc == UNDEF)? fu_int(1): inc));
}

RES *
fu_macro_menos_menos(e,inc)
	RES *e, *inc;
{
	return fu_make_list("xxx", fu_symbol("set"), e,
						fu_make_list("xxx", fu_symbol("-"), e,
								(inc == UNDEF)? fu_int(1): inc));
}

RES *
fu_macro_and(body)
	RES *body;
{
	RES *p, *resu, *tmp, *cond;

	resu = tmp = fu_cons(NIL, NIL);
	for (p = body; CONS_P(p); p = CDR(p)) {
		cond = fu_cons(CAR(p), NIL);
		CDR(tmp) = fu_cons(fu_cons(fu_symbol("if"), cond), NIL);
		tmp = cond;
	}
	return CADR(resu);
}

RES *
fu_macro_backquote(expr)
	RES *expr;
{
#if 0
	// `(a . ()) => (cons `a `()) => (cons 'a '()) => (a . ())
	fu_print(expr);
	printf("\n");
	if (expr == NIL) {
		return NIL;
	} else if (CONS_P(expr)) {
		RES *v = fu_macro_backquote(CAR(expr));
		RES *w = fu_macro_backquote(CDR(expr));

		return fu_cons(fu_symbol("cons"), fu_cons(v, fu_cons(w, NIL)));
	} else {
		return fu_cons(fu_symbol("quote"), fu_cons(expr, NIL));
	}
#endif
	if (expr == NIL) {
		return NIL;
	} else if (CONS_P(expr)) {
		if (CAR(expr) == fu_symbol("unquote")) {
			if (!CONS_P(CDR(expr)))
				fu_throw(fu_symbol("&bad-argument"),
					fu_str("backquote -- unquote deforme"));
			return CADR(expr);
		} else {
			RES *v = CAR(expr), *w = CDR(expr);

			if (CONS_P(v) && CAR(v) == fu_symbol("unquote-splicing")) {
				/*if (w == NIL) {
					return CADR(v);
				} else*/
					return fu_make_list("xxx", fu_symbol("cat"),
						CADR(v),
						fu_macro_backquote(w));
			} else {
				/*if (w == NIL)
					return fu_make_list("xx", fu_symbol("list"),
						fu_macro_backquote(v));
				else*/
					return fu_make_list("xxx", fu_symbol("cons"),
						fu_macro_backquote(v),
						fu_macro_backquote(w));
			}
		}
	} else
		return fu_cons(fu_symbol("quote"), fu_cons(expr, NIL));
}

RES *
fu_macro_defset(nombre,llist, body)
	RES *nombre, *llist, *body;
{
	return fu_make_list("xxx", fu_symbol("set"),
					fu_make_list("xx", fu_symbol("setter"), nombre),
					fu_make_list("xxX",
							fu_symbol("fun"), llist,
							body));
}

RES *
fu_macro_defun(nombre,llist, body)
	RES *nombre, *llist, *body;
{
	return fu_make_list("xxx", fu_symbol("def"),
					nombre,
					fu_make_list("xxX",
							fu_symbol("fun"), llist,
							body));
}

RES *
fu_macro_defdyn(nombre,llist, body)
	RES *nombre, *llist, *body;
{
	return fu_make_list("xxx", fu_symbol("def"),
					nombre,
					fu_make_list("xxX",
							fu_symbol("dyn"), llist,
							body));
}

RES *
fu_macro_outf(port, fmt, args)
	RES *port, *fmt, *args;
{
	return fu_make_list("xxx",
					fu_symbol("out"), port,
					fu_make_list("xxX", fu_symbol("fmt"), fmt, args));
}

RES *
fu_macro_prf(fmt, args)
	RES *fmt, *args;
{
	return fu_make_list("xx",
					fu_symbol("pr1"),
					fu_make_list("xxX", fu_symbol("fmt"), fmt, args));
}

RES *
fu_macro_wrf(fmt, args)
	RES *fmt, *args;
{
	return fu_make_list("xx",
					fu_symbol("wr1"),
					fu_make_list("xxX", fu_symbol("fmt"), fmt, args));
}

RES *
fu_macro_deftype(nombre, des)
	RES *nombre, *des;
{
	return fu_make_list("xxx", fu_symbol("def"),
					nombre,
					fu_make_list("xx",
							fu_symbol("type"), des));
}

RES *
fu_macro_pack(cuerpo)
	RES *cuerpo;
{
	return fu_make_list("xxxx", fu_symbol("let"), NIL,
					fu_make_list("xX", fu_symbol("do"), cuerpo),
					fu_cons(fu_symbol("dir"), NIL));
}

RES *
fu_macro_module(nombre, cuerpo)
	RES *nombre, *cuerpo;
{
	return fu_make_list("xxx", fu_symbol("def"),
					nombre,
					fu_make_list("xX",
							fu_symbol("pack"), cuerpo));
}

RES *
fu_macro_use(modulo)
	RES *modulo;
{
	if (TIPO_P(tipo_sym, modulo)) {
		return fu_make_list("xxx", fu_symbol("def"),
						modulo,
						fu_make_list("xx",
								fu_symbol("import"),
								fu_str_cat(fu_str(VAL_SYMNAME(modulo)), 
										   fu_str(".fu"))));
	} else
		fu_throw(fu_symbol("&wrong-type-arg"),
			fu_str("use -- el argumento debe ser un simbolo"));
}

RES *
fu_macro_exec(arch, args)
	RES *arch, *args;
{
	if (TIPO_P(tipo_sym, arch)) {
		return fu_make_list("xxX",
				fu_symbol("run"),
				fu_str_cat(fu_str(VAL_SYMNAME(arch)), 
				   fu_str(".fu")),
				args);
	} else
		fu_throw(fu_symbol("&wrong-type-arg"),
			fu_str("exec -- el argumento debe ser un simbolo"));
}

RES *
fu_macro_defstruct(nombre, slots)
	RES *nombre, *slots;
{
	RES *true_nombre;
	RES *opciones = NIL;
	RES *p;
	RES *slots_eval = NIL;
	RES *slots_nombres = NIL;
	RES *make_slot_accessors = NIL;
	RES *qt = fu_symbol("quote");
	RES *lst = fu_symbol("list");
	RES *acc = fu_symbol("stype-accessor");
	RES *df = fu_symbol("def");
	RES *opt;
	RES *nombre_constructor = UNDEF;
	RES *args_constructor = UNDEF;
	RES *opciones_reales = NIL;
	RES *prefix = NIL;
	unsigned char arma_args_constructor = TRUE;

	if (CONS_P(nombre)) {
		true_nombre = CAR(nombre);
		opciones = CDR(nombre);
	} else
		true_nombre = nombre;

	prefix = true_nombre;

	for (opt = opciones; CONS_P(opt); opt = CDR(opt)) {
		if (CAR(opt) == fu_keyword("=constructor")) {
			arma_args_constructor = FALSE;
			opt = CDR(opt);
			if (!CONS_P(opt))
				fu_throw(fu_symbol("&bad-argument"),
					fu_str("defstruct -- se esperaba nombre de constructor"));
			nombre_constructor = CAR(opt);
			if (nombre_constructor != NIL) {
				opt = CDR(opt);
				if (!CONS_P(opt))
					fu_throw(fu_symbol("&bad-argument"),
						fu_str("defstruct -- se esperaban argumentos del constructor"));
				args_constructor = CAR(opt);
			}
		} else if (CAR(opt) == fu_keyword("=prefix")) {
			opt = CDR(opt);
			if (!CONS_P(opt))
				fu_throw(fu_symbol("&bad-argument"),
					fu_str("defstruct -- se esperaba prefijo"));
			prefix = CAR(opt);
		} else {
			opciones_reales = fu_cons(CAR(opt), opciones_reales);
		}
	}
	opciones_reales = fu_xrev(opciones_reales);

	for (p = slots; CONS_P(p); p = CDR(p)) {
		RES *aa;
		if (CONS_P(CAR(p))) {
			aa = CAAR(p);
			slots_eval = fu_cons(
							fu_make_list("xxX", lst,
									fu_make_list("xx", qt, aa),
									CDAR(p)),
							slots_eval);
		} else {
			aa = CAR(p);
			slots_eval = fu_cons(fu_make_list("xx", qt, aa),
							slots_eval);
		}
		if (arma_args_constructor)
			slots_nombres = fu_cons(aa, slots_nombres);
		
		make_slot_accessors = fu_cons(
					fu_make_list("xxx", df,
							fu_mksym(fu_make_list("xxx",
											prefix,
											fu_str("-"),
											aa)),
							fu_make_list("xxx",
									acc, true_nombre,
									fu_make_list("xx", qt, aa))),
					make_slot_accessors);
	}
	slots_eval = fu_cons(lst, fu_xrev(slots_eval));
	if (arma_args_constructor)
		slots_nombres = fu_xrev(slots_nombres);

	/*
	** (def nombre (mkstype slots opciones))
	** (def make-nombre (stype-constructor nombre slots))
	** (def nombre-slot1 (stype-accessor nombre slot1))
	** ...
	** (def nombre-slotN (stype-accessor nombre slotN))
	*/
	if (arma_args_constructor) {
		nombre_constructor =
			fu_mksym(fu_make_list("xx", fu_str("make-"), prefix));
		args_constructor = slots_nombres;
	}
	args_constructor = fu_make_list("xx", qt, args_constructor);
	
	return fu_make_list("xxxX",
		fu_symbol("do"),

				fu_make_list("xxx", df, true_nombre,
					fu_make_list("xxX", fu_symbol("mkstype"),
						slots_eval, opciones_reales))
				
				,

				
				(nombre_constructor == NIL ? NIL :
				 fu_make_list("xxx", df,
						 nombre_constructor,
						 fu_make_list("xxx", fu_symbol("stype-constructor"),
								 true_nombre, args_constructor)))
				
				,

				make_slot_accessors
				);
}

RES *
fu_macro_push(gvar, val)
	RES *gvar, *val;
{
	return fu_make_list("xxx", fu_symbol("set"), gvar,
					fu_make_list("xxx", fu_symbol("cons"), val, gvar));
}

#define MBIND(SYMB, COSA)	{ COSA; fu_def_env(fu_symbol(SYMB), p); }
#define MAKE_MACRO(A,B,C,D)	{ p = fu_make_proc(A,B,C,D); \
									PROC_MACRO_SET(VAL_PROC(p)); }
void
fu_init_macro()
{
	RES *p;

	MBIND("macro", MAKE_MACRO(fu_macro_defmacro,2,0,1));
	MBIND("let", MAKE_MACRO(fu_macro_let,1,0,1));
	MBIND("nlet", MAKE_MACRO(fu_macro_nlet,2,0,1));
	MBIND("each", MAKE_MACRO(fu_macro_each,2,0,1));
	MBIND("try", MAKE_MACRO(fu_macro_try,1,0,1));
	MBIND("catch", MAKE_MACRO(fu_macro_catch,1,0,1));
	MBIND("1+", MAKE_MACRO(fu_macro_1_mas,1,0,0));
	MBIND("1-", MAKE_MACRO(fu_macro_1_menos,1,0,0));
	MBIND("++", MAKE_MACRO(fu_macro_mas_mas,1,1,0));
	MBIND("--", MAKE_MACRO(fu_macro_menos_menos,1,1,0));
	MBIND("and", MAKE_MACRO(fu_macro_and,0,0,1));
	MBIND("backquote", MAKE_MACRO(fu_macro_backquote,1,0,0));
	MBIND("defset", MAKE_MACRO(fu_macro_defset,2,0,1));
	MBIND("defun", MAKE_MACRO(fu_macro_defun,2,0,1));
	MBIND("defdyn", MAKE_MACRO(fu_macro_defdyn,2,0,1));
	MBIND("to", MAKE_MACRO(fu_macro_to,2,0,1));
	MBIND("deftype", MAKE_MACRO(fu_macro_deftype,2,0,0));
	MBIND("pack", MAKE_MACRO(fu_macro_pack,0,0,1));
	MBIND("module", MAKE_MACRO(fu_macro_module,1,0,1));
	MBIND("use", MAKE_MACRO(fu_macro_use,1,0,0));
	MBIND("exec", MAKE_MACRO(fu_macro_exec,1,0,1));
	MBIND("defstruct", MAKE_MACRO(fu_macro_defstruct,1,0,1));
	MBIND("push", MAKE_MACRO(fu_macro_push,2,0,0));

	/* output */
	MBIND("outf", MAKE_MACRO(fu_macro_outf,2,0,1));
	MBIND("prf", MAKE_MACRO(fu_macro_prf,1,0,1));
	MBIND("wrf", MAKE_MACRO(fu_macro_wrf,1,0,1));
}
#undef MBIND
#undef MAKE_MACRO
