%{
#include <string.h>

#include "Fu.h"
#ifndef _WIN32
#include "parser.tab.h"
#else
#include "parser_tab.h"
#endif

#ifdef BERSERK_FUNES
#define MAX_INDENT_DEPTH 256
#define TAB_WIDTH 2
#define TRUE 1
#define FALSE 0

#undef getc

unsigned num_lineas = 0, columna = 0;
unsigned espacios[MAX_INDENT_DEPTH];
unsigned current_espacio = 0;
char encontro_no_blanco = FALSE;
unsigned cantidad_cerrar = 0;
char getc_crudo = FALSE;

int
getc(arch)
	FILE *arch;
{
	extern FILE *yyin;
	int caracter;

	espacios[0] = 0;

	if (cantidad_cerrar > 0) {
		cantidad_cerrar--;
		if (cantidad_cerrar > 0) {
			return ')';
		}
	}
	caracter = fgetc(arch);

	if (getc_crudo) {
		if (caracter == '\n') {
			num_lineas++;
			columna = 0;
			encontro_no_blanco = FALSE;
		} else if (caracter == '\r') {
			/* nada */
		} else if (caracter == '\t') {
			columna += TAB_WIDTH;
		} else {
			columna++;
		}
		return caracter;
	}

	if (caracter == '\n') {
		num_lineas++;
		columna = 0;
		encontro_no_blanco = FALSE;
	} else if (caracter == '\r') {
		/* nada */
	} else if (caracter == ' ') {
		columna++;
	} else if (caracter == '\t') {
		columna += TAB_WIDTH;
	} else if (caracter == ';') {
		/* es un comentario y no me interesa donde empieza!! */
		columna++;
		return ';';
	} else {
		if (!encontro_no_blanco) {
			encontro_no_blanco = TRUE;
			if (current_espacio && columna <= espacios[current_espacio]) {
				while (--current_espacio && columna <= espacios[current_espacio])
					cantidad_cerrar++;
				cantidad_cerrar++;
				ungetc(caracter, arch);
				return ')';
			}
		}
		if (caracter == ':') {
			espacios[++current_espacio] = columna++;
			return '(';
		} else  {
			columna++;
			return caracter;
		}
	}
}

#undef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
        { \
          int c = getc(yyin); \
          if (c == EOF) { \
            if (ferror(yyin)) \
              YY_FATAL_ERROR("input in flex scanner failed"); \
            result = YY_NULL; \
          } else { \
            buf[0] = c; \
            result = 1; \
          } \
        }

#endif /* BERSERK_FUNES */

#define MAX_READ_BUFFER	256
#define PUSHBUF(C)	if (c-buffer<MAX_READ_BUFFER-1) {\
				*c++ = C;\
			} else {\
				*c = 0;\
				c = buffer;\
				cadena = fu_str_cat(cadena,fu_str(buffer));\
				*c++ = C;\
			}
char buffer[MAX_READ_BUFFER];
char *c;
RES *cadena;

char interpolada;			/* la cadena tiene $ adentro */
RES *resultado;				/* resultado de interpolar */
%}
EXTALNUM	[0-9a-zA-Z!$%&*+/:<=>?@_~^-]
%x str
%x comentario
%x regexp
%%
<<EOF>>		{ return T_EOF; }
";"			{ BEGIN(comentario);
#if BERSERK_FUNES
			getc_crudo = TRUE; 
#endif
}
<comentario>.*\n { 
#if BERSERK_FUNES
			getc_crudo = FALSE;
#endif
			BEGIN(INITIAL); }
"("			{ return T_LPAREN; }
")"			{ return T_RPAREN; }
"."			{ return T_DOT; }
"'"			{ return T_QUOTE; }
"`"			{ return T_BACKQUOTE; }
",@"		{ return T_UNQUOTE_SPLICING; }
","			{ return T_UNQUOTE; }
"#t"		{ yylval.val = T; return T_ATOM; }
"#f"		{ yylval.val = NIL; return T_ATOM; }
"-"?[0-9]*"."[0-9]+ { yylval.val = fu_float(atof(yytext)); return T_ATOM; }
"-"?[0-9]+"."[0-9]* { yylval.val = fu_float(atof(yytext)); return T_ATOM; }
"-"?[0-9]+	{ yylval.val = fu_int(atoi(yytext)); return T_ATOM; }
\\nl		{ yylval.val = fu_char((int) '\n'); return T_ATOM; }
\\cr		{ yylval.val = fu_char((int) '\r'); return T_ATOM; }
\\.		{ yylval.val = fu_char((int) yytext[1]); return T_ATOM; }
{EXTALNUM}+"."	{	char *s;
			unsigned l;
			l = strlen(yytext)-1;
			s = NEWQ(char, l+1);
			strncpy(s,yytext,l);
			s[l] = '\0';
			yylval.val = fu_symbol(s);
			return T_ATOM_DOT;
		}
"--"{EXTALNUM}+	{	char *s;
			unsigned l;
			l = strlen(yytext)-1;
			s = NEWQ(char, l+1);
			strncpy(s,&yytext[2],l);
			s[l] = '\0';
			yylval.val = fu_symbol(s);
			return T_EQUAL_ATOM;
		}
"="{EXTALNUM}+	{	char *s;
			unsigned l;
			l = strlen(yytext);
			s = NEWQ(char, l+1);
			strncpy(s,yytext,l);
			s[l] = '\0';
			yylval.val = fu_keyword(s);
			return T_ATOM;
		}
{EXTALNUM}+	{	char *s;
			unsigned l;
			l = strlen(yytext);
			s = NEWQ(char, l+1);
			strncpy(s,yytext,l);
			s[l] = '\0';
			yylval.val = fu_symbol(s);
			return T_ATOM;
		}
\"\"			{	yylval.val = fu_str("");
					return T_ATOM;
				}
\"			{	interpolada = FALSE;
				cadena = fu_str("");
				c = buffer;
#if BERSERK_FUNES
				getc_crudo = TRUE;
#endif
				BEGIN(str); }
"#/"		{	interpolada = FALSE;
#if BERSERK_FUNES
				getc_crudo = TRUE;
#endif
				BEGIN(regexp);
				return REGEXP_START;
			}
<regexp>"/" {
		BEGIN(INITIAL);
		return REGEXP_END;
}
<regexp>"*"	{
				return REGEXP_CLOSURE;
			}
<regexp>"|"	{
				return REGEXP_OR;
			}
<regexp>"("	{
				return T_LPAREN;
}
<regexp>")"	{
				return T_RPAREN;
}
<regexp>.	{
				yylval.val = fu_char((int) yytext[0]); return REGEXP_ATOM;
}

<str>\"			{	BEGIN(INITIAL);
#if BERSERK_FUNES
					getc_crudo = FALSE;
#endif
					*c = '\0';
					cadena = fu_str_cat(cadena,fu_str(buffer));
					if (interpolada) {
						resultado = fu_cons(cadena, resultado);
						yylval.val = fu_cons(
							fu_symbol("cat"), fu_xrev(resultado));
						return T_CADENA_INTERPOLADA;
					} else {
						yylval.val = cadena;
						return T_ATOM;
					}
				}
<str>\\\n		{ /* nada */ }
<str>\\n		{ PUSHBUF('\n'); }
<str>\\t		{ PUSHBUF('\t'); }
<str>\\r		{ PUSHBUF('\r'); }
<str>\\b		{ PUSHBUF('\b'); }
<str>\\f		{ PUSHBUF('\f'); }
<str>\\.		{ PUSHBUF(yytext[1]); }
<str>"$@"		{
					/* interpola splicing */
					RES *prev = NIL;
					RES *cadena_ant;
					RES *resultado_ant;
					RES *separador;
					char interpolada_ant;

					BEGIN(INITIAL);
					*c = '\0';
					cadena = fu_str_cat(cadena,fu_str(buffer));
					cadena_ant = cadena;
					resultado_ant = resultado;
					interpolada_ant = interpolada;
					yyparse();
					separador = Read_Sexpr;
					yyparse();
					cadena = cadena_ant;
					resultado = resultado_ant;
					interpolada = interpolada_ant;
					if (!interpolada)
						interpolada = TRUE;
					else
						prev = resultado;
					resultado = fu_cons(
							fu_make_list("xxxx",
								fu_symbol("call"),
								fu_symbol("join"),
								fu_make_list("xx",
									fu_symbol("str"),
									separador),
								fu_make_list("xxx",
									fu_symbol("map"),
									fu_symbol("str"),
									Read_Sexpr)),
						fu_cons(cadena, prev));
					cadena = fu_str("");
					c = buffer;
					BEGIN(str);
				}
<str>"$"		{
					/* interpola sin splice */
					RES *prev = NIL;
					RES *cadena_ant;
					RES *resultado_ant;
					char interpolada_ant;

					BEGIN(INITIAL);
					*c = '\0';
					cadena = fu_str_cat(cadena,fu_str(buffer));
					cadena_ant = cadena;
					resultado_ant = resultado;
					interpolada_ant = interpolada;
					yyparse();
					cadena = cadena_ant;
					resultado = resultado_ant;
					interpolada = interpolada_ant;
					if (!interpolada)
						interpolada = TRUE;
					else
						prev = resultado;
					resultado = fu_cons(
						fu_cons(fu_symbol("str"), fu_cons(Read_Sexpr, NIL)),
						fu_cons(cadena, prev));
					cadena = fu_str("");
					c = buffer;
					BEGIN(str);
				}
<str>[^\\\"] 		{ char *p = yytext;
			  while (*p)
			  	PUSHBUF(*p++);
			}
[ \t\n\r]*		{ /* se come los blancos */ }
.			{
		fu_throw(fu_symbol("&read-error"),
					fu_str("caracter invalido"));
}
%%

RES *
fu_read(port)
	RES *port;
{
	RES *r = port;
	YY_BUFFER_STATE prev;
	unsigned char cambio = FALSE;

#ifdef BERSERK_FUNES
	unsigned i;
	unsigned num_lineas_ant, columna_ant;
	unsigned espacios_ant[MAX_INDENT_DEPTH];
	unsigned current_espacio_ant;
	unsigned cantidad_cerrar_ant;
	char encontro_no_blanco_ant;
	char getc_crudo_ant;
#endif

	if (r != UNDEF && !TIPO_P(tipo_reader, r)) {
		fu_throw(fu_symbol("&wrong-type-arg"),
					fu_str("read -- no es un reader"));
	}
	if (port == UNDEF) r = fu_reader(Std_Input, FALSE);
	if ( YY_CURRENT_BUFFER != VAL_READER(r) ) {
#ifdef BERSERK_FUNES
		num_lineas_ant = num_lineas;
		columna_ant = columna;
		current_espacio_ant = current_espacio;
		for (i = 0; i <= MAX_INDENT_DEPTH; i++)
			espacios_ant[i] = espacios[i];
		encontro_no_blanco_ant = encontro_no_blanco;
		cantidad_cerrar_ant = cantidad_cerrar;
		getc_crudo_ant = getc_crudo;

		num_lineas = 0;
		columna = 0;
		espacios[0] = 0;
		current_espacio = 0;
		encontro_no_blanco = FALSE;
		cantidad_cerrar = 0;
		getc_crudo = FALSE;
#endif

		prev = YY_CURRENT_BUFFER;
		yy_switch_to_buffer(VAL_READER(r));
		cambio = TRUE;
	}
	yyparse();
	if (port == UNDEF) yy_delete_buffer(YY_CURRENT_BUFFER);
	if (cambio) {
		yy_switch_to_buffer(prev);

#ifdef BERSERK_FUNES
		num_lineas = num_lineas_ant;
		columna = columna_ant;
		current_espacio = current_espacio_ant;
		for (i = 0; i <= MAX_INDENT_DEPTH; i++)
			espacios[i] = espacios_ant[i];
		encontro_no_blanco = encontro_no_blanco_ant;
		cantidad_cerrar = cantidad_cerrar_ant;
		getc_crudo = getc_crudo_ant;
#endif
	}
	return Read_Sexpr;
}

RES *
fu_reader(cosa, start)
	RES *cosa;
	unsigned char start;
{
	RES *p;
	YY_BUFFER_STATE buf;

	p = NEW(RES);
	TIPO(p) = tipo_reader;
	buf = yy_create_buffer(VAL_PORT(cosa), 256);
	VAL(p) = (void *) buf;
	if (start)
		yy_switch_to_buffer(buf);
	return p;
}

RES *
fu_stread(cadena)
	RES *cadena;
{
	YY_BUFFER_STATE prev, curr;
	unsigned char cambio = FALSE;

#ifdef BERSERK_FUNES
	unsigned i;
	unsigned num_lineas_ant, columna_ant;
	unsigned espacios_ant[MAX_INDENT_DEPTH];
	unsigned current_espacio_ant;
	char encontro_no_blanco_ant;
	unsigned cantidad_cerrar_ant;
#endif

	if (!STR_P(cadena)) {
		fu_throw(fu_symbol("&wrong-type-arg"),
					fu_str("stread -- no es una cadena"));
	}

#ifdef BERSERK_FUNES
	num_lineas_ant = num_lineas;
	columna_ant = columna;
	current_espacio_ant = current_espacio;
	for (i = 0; i <= MAX_INDENT_DEPTH; i++)
		espacios_ant[i] = espacios[i];
	encontro_no_blanco_ant = encontro_no_blanco;
	cantidad_cerrar_ant = cantidad_cerrar;

	num_lineas = 0;
	columna = 0;
	espacios[0] = 0;
	current_espacio = 0;
	encontro_no_blanco = FALSE;
	cantidad_cerrar = 0;
#endif

	prev = YY_CURRENT_BUFFER;
	curr = yy_scan_string(VAL_STR(cadena));
	yy_switch_to_buffer(curr);

	yyparse();
	yy_delete_buffer(YY_CURRENT_BUFFER);
	yy_switch_to_buffer(prev);

#ifdef BERSERK_FUNES
	num_lineas = num_lineas_ant;
	columna = columna_ant;
	current_espacio = current_espacio_ant;
	for (i = 0; i <= MAX_INDENT_DEPTH; i++)
		espacios[i] = espacios_ant[i];
	encontro_no_blanco = encontro_no_blanco_ant;
	cantidad_cerrar = cantidad_cerrar_ant;
#endif

	return Read_Sexpr;
}
