#include "Fu.h"

int
pjw_hash(s,modulo)
	char *s;
	int modulo;
{
	char *p;
	unsigned h = 0, g;

	for ( p = s; *p; p++ ) {
		h = (h << 4) + (*p);
		if ( g = h & 0xf0000000 ) {
			h ^= (g >> 24);
			h ^= g;
		}
	}
	return h % modulo;
}

__inline__ RES *
fu_make_hash(len)
	RES *len;
{
	RES *p;
	if (len == UNDEF)
		len = fu_int(SYMTABLE_SIZE);
	p = fu_make_vector(len, NIL);
	VECTOR_TIPO(VAL_VECTOR(p)) = vector_hash;
	return p;
}

RES *
fu_db(args)
	RES *args;
{
	RES *h, *p;

	h = fu_make_hash(UNDEF);
	for (p = args; CONS_P(p) && CONS_P(CDR(p)); p = CDDR(p))
		fu_set_hash_eq(h, CAR(p), CADR(p));
	return h;
}

#define EL VECTOR_ELEMENTO(h, k)

/* set y get genericos dadas funciones de
 * igualdad y hash
 */
RES *
fu_set_hash_f(eqfun,hashfun,hash,clave,valor)
	RES *eqfun, *hashfun, *hash, *clave, *valor;
{
	int k;
	VECTOR *h;
	RES *clave_valor;

 	h = VAL_VECTOR(hash);
	k = VAL_INT(fu_apply(hashfun,
					fu_cons(clave, fu_cons(fu_int(VECTOR_LENGTH(h)), NIL))));
	if (!(EL)) {
		/* El lugar estaba vacio */
		clave_valor = fu_cons(clave, valor);
		EL = fu_cons(clave_valor, NIL);
	} else {
		RES *q;
		/* El lugar estaba ocupado */
		/* Reviso si ya existe la clave */
		for ( q = EL; q != NIL; q = CDR(q) ) {
			if ( fu_apply(eqfun, fu_cons(CAR(CAR(q)),fu_cons(clave,NIL)))
							!= NIL ) {
				/* En este caso ya existia */
				CDR(CAR(q)) = valor;
				return CAR(q);
			}
		}
		/* En este caso, no existia en ese compartimento un dato con
		 * la misma clave */
		clave_valor = fu_cons(clave, valor);
		EL = fu_cons(clave_valor, EL);
	}
	return clave_valor;
}

RES *
fu_get_hash_f(eqfun,hashfun,hash,clave)
	RES *eqfun, *hashfun, *hash, *clave;
{
	int k;
	VECTOR *h;

	h = VAL_VECTOR(hash);
	k = VAL_INT(fu_apply(hashfun,
					fu_cons(clave, fu_cons(fu_int(VECTOR_LENGTH(h)), NIL))));
	if (EL) {
		RES *q;
		for ( q = EL; q != NIL; q = CDR(q) )
			if ( fu_apply(eqfun, fu_cons(CAR(CAR(q)), fu_cons(clave,NIL)))
							!= NIL )
				return CAR(q);
	}
	return NIL;
}

/* funciones rapidas con eq */
RES *
fu_set_hash_eq(hash,clave,valor)
	RES *hash, *clave, *valor;
{
	int k;
	VECTOR *h;
	RES *clave_valor;

 	h = VAL_VECTOR(hash);
	k = ((int) clave) % VECTOR_LENGTH(h);
	if (!(EL)) {
		/* El lugar estaba vacio */
		clave_valor = fu_cons(clave, valor);
		EL = fu_cons(clave_valor, NIL);
	} else {
		RES *q;
		/* El lugar estaba ocupado */
		/* Reviso si ya existe la clave */
		for ( q = EL; q != NIL; q = CDR(q) ) {
			if ( CAR(CAR(q)) == clave ) {
				/* En este caso ya existia */
				CDR(CAR(q)) = valor;
				return CAR(q);
			}
		}
		/* En este caso, no existia en ese compartimento un dato con
		 * la misma clave */
		clave_valor = fu_cons(clave, valor);
		EL = fu_cons(clave_valor, EL);
	}
	return clave_valor;
}

RES *
fu_get_hash_eq(hash,clave)
	RES *hash, *clave;
{
	int k;
	VECTOR *h;

	h = VAL_VECTOR(hash);
	k = ((int) clave) % VECTOR_LENGTH(h);
	if (EL) {
		RES *q;
		for ( q = EL; q != NIL; q = CDR(q) )
			if ( CAR(CAR(q)) == clave)
				return CAR(q);
	}
	return NIL;
}

/* funciones con cadenas para uso interno */
RES *
fu_set_hash(hash,clave,valor)
	RES *hash, *clave, *valor;
{
	char *str_clave;
	int k;
	VECTOR *h;
	RES *clave_valor;

	if ( !TIPO_P(tipo_vector, hash)) {
			fu_throw(fu_symbol("&wrong-type-arg"),
						fu_str("set_hash -- no es un vector"));
	}
	if ( !STR_P(clave)) {
		fu_throw(fu_symbol("&wrong-type-arg"),
					fu_str("set_hash -- la clave no es una cadena"));
	}
 	h = VAL_VECTOR(hash);
 	str_clave = VAL_STR(clave);
	k = pjw_hash(str_clave, VECTOR_LENGTH(h));
	if (!(EL)) {
		/* El lugar estaba vacio */
		clave_valor = fu_cons(clave, valor);
		EL = fu_cons(clave_valor, NIL);
	} else {
		RES *q;
		/* El lugar estaba ocupado */
		/* Reviso si ya existe la clave */
		for ( q = EL; q != NIL; q = CDR(q) ) {
			if ( ! strcmp( VAL_STR(CAR(CAR(q))), str_clave ) ) {
				/* En este caso ya existia */
				CDR(CAR(q)) = valor;
				return CAR(q);
			}
		}
		/* En este caso, no existia en ese compartimento un dato con
		 * la misma clave */
		clave_valor = fu_cons(clave, valor);
		EL = fu_cons(clave_valor, EL);
	}
	return clave_valor;
}

RES *
fu_get_hash(hash,clave)
	RES *hash, *clave;
{
	char *str_clave;
	int k;
	VECTOR *h;

	if ( !TIPO_P(tipo_vector, hash)) {
		fu_throw(fu_symbol("&wrong-type-arg"),
					fu_str("get_hash -- no es un vector"));
	}
	if ( !STR_P(clave)) {
		fu_throw(fu_symbol("&wrong-type-arg"),
					fu_str("get_hash -- la clave no es una cadena"));
	}
	h = VAL_VECTOR(hash);
 	str_clave = VAL_STR(clave);
	k = pjw_hash(str_clave, VECTOR_LENGTH(h));
	if (EL) {
		RES *q;
		for ( q = EL; q != NIL; q = CDR(q) )
			if ( ! strcmp(VAL_STR(CAR(CAR(q))), str_clave))
				return CAR(q);
	}
	return NIL;
}
#undef EL

RES *
fu_db_data(hash, func)
	RES *hash, *func;
{
	RES *resultado = NIL;
	VECTOR *v;
	unsigned i;

	if ( !TIPO_P(tipo_vector, hash)) {
		fu_throw(fu_symbol("&wrong-type-arg"),
					fu_str("data -- no es un vector"));
	}
	v = VAL_VECTOR(hash);
	for (i = 0; i < VECTOR_LENGTH(v); i++) {
		RES *l1; 

		l1 = VECTOR_ELEMENTO(v, i);
		if (l1 == NIL) {
			/* nada */
		} else if (CONS_P(l1)) {
			RES *p;

			for ( p = l1; CONS_P(p); p = CDR(p))
				resultado = fu_cons((func == UNDEF ?
										CAR(p) :
										fu_apply(func, fu_cons(CAR(p), NIL))),
								resultado);
		} else
			fu_throw(fu_symbol("&wrong-type-arg"),
				fu_str("data -- el hash es deforme"));
	}
	return resultado;
}

RES *
fu_db_vec(hash)
	RES *hash;
{
	RES *r;

	if ( !TIPO_P(tipo_vector, hash)) {
		fu_throw(fu_symbol("&wrong-type-arg"),
					fu_str("data -- no es un vector"));
	}
	r = fu_empty_vector(VECTOR_LENGTH(VAL_VECTOR(hash)));
	VECTOR_TABLA(VAL_VECTOR(r)) = VECTOR_TABLA(VAL_VECTOR(hash));
	VECTOR_TIPO(VAL_VECTOR(r)) = vector_no_uniforme;
}
