#include "Fu.h"
#include <string.h>

/*
 * nil		0000 0011
 * t		0001 0011
 * eof		0010 0011
 * undef	0011 0011
 * argset	0100 0011
 */
RES* NIL = (RES *)		0x03;
RES* T = (RES *)	 	0x13;
RES* EOF_OBJECT = (RES *)	0x23;
RES* UNDEF = (RES *)		0x33;
RES* ARGSET = (RES *)		0x43;

RES *Fu_Argv;

void
init()
{
	fu_init_symbol();
	fu_init_env();
	fu_init_tipos();
	fu_init_setter();
	fu_init_inline();
	fu_init_special();
	fu_init_port();
	fu_init_builtins();
	fu_init_macro();
}

void
fu_logo()
{
printf("\n\n");
printf("     **  ********   **   **   ***   **  ********    ******   **\n");
printf("   **     |*   |*   |*   |*   |**   |*   |*   |*   |*    **    **\n");
printf("  |*      |*__      |*   |*   |***  |*   |*__       **__        |*\n");
printf("  |*      |***      |*   |*   |* ** **   |***        *****      |*\n");
printf("  |*      |*        |*   |*   |*  ****   |*              **     |*\n");
printf("   **     |*        |*___|*   |*   |**   |*____|   **___**     **\n");
printf("     **  ****        *****    **    **  ********    *****    **\n");
printf("\n");
}

RES *
fu_args()
{
	return Fu_Argv;
}

int
main(argc,argv)
	int argc;
	char *argv[];
{
	int interactiva;
	RES *c;
	RES *input, *env_ant;

	init();

	if (argc == 1) {
		interactiva = 1;
		fu_logo();
		input = fu_reader(Std_Input, TRUE);
	} else {
		interactiva = 0;
	}

	Fu_Err_Salto = NEW(jmp_buf);
	if ( setjmp(*Fu_Err_Salto) ) {
		fprintf(stderr, "Excepcion no cachada: ");
		fu_fprint(Std_Error, Fu_Err_Excepcion, T);
		fprintf(stderr, "\n");
		fu_fprint(Std_Error, Fu_Err_Descripcion, T);
		fprintf(stderr, "\n");
		fu_with_env(env_ant);
		if (!interactiva)
				exit(1);
	}

	env_ant = fu_env();

	/*fu_load(fu_str("init.fu"));*/
	Fu_Argv = NIL;
	if ( interactiva ) {
		/* sin argumentos => REPL */
		while (1) {
				printf("funes> ");
				//fu_closure_print(FU_COMPILE(fu_read(input)));
				fu_print(fu_eval(fu_read(input)));
				printf("\n");
		}
	} else {
		/* lee de archivo */
		RES *arch;
		FILE *f;
		unsigned i;

		if ( !(f = fopen(argv[1],"r"))) {
			fprintf(stderr, "no se puede leer del archivo %s\n", argv[1]);
			exit(1);
		}
		arch = fu_reader(fu_port(f), TRUE);

		/* Lee los argumentos */
		for (i = 2; i < argc; i++)
			Fu_Argv = fu_cons(fu_stread(fu_str(argv[i])), Fu_Argv);
		Fu_Argv = fu_xrev(Fu_Argv);

		while (f) {
			RES *sexpr;
			sexpr = fu_read(arch);
			if (sexpr == EOF_OBJECT)
				exit(0);
			else
				fu_eval(sexpr);
				//fu_closure_print(FU_COMPILE(sexpr));
		}
		if (fclose(f)) {
			fprintf(stderr, "no se puede cerrar el archivo\n");
			exit(1);
		}
	}
	return 0;
}
