#include <stdio.h>
#include <math.h>
#define DELTA 0.0001
#define PI 3.141592654
#define RESOLUCION 0.05

double rayo (double,double,double,double);
double conica (double, double, double,double);
double interseccion(double,double,double,double,double,double);
double anguloc (double,double,double,double);
double anguloin (double,double);
double anguloout(double,double);
double angulotr (double,double,double);
double anguloref (double);
double signo(double,double);
double converg(double,double,double,double,double,double);

main(){
  FILE *ptr;
  FILE *ptr2;
  FILE *ptrw;
  FILE *ptrw2;

  int superficies;
  int puntosfigura;
  int i,j,k,numrayos;
  double coordr,coordz,coordri,coordzi,ang,amax;   /*iniciales*/
  double locz,curv,param,deltaang;           /*se cargan del arreglo*/
  double angc,angin,angtr,angref,puntoz,puntor,z;   /*uso temporal*/
  double corefini,coref,corefant,nat;
  if ((ptr=fopen("lentes.dat","r"))==NULL){
    printf("No se encontr el archivo de lentes!\n Se termina el programa.");
    return 0;}
  fscanf(ptr,"%lf",&corefini);
  fscanf(ptr,"%d",&superficies);
  printf("%d",superficies);
  if (superficies<0) {
    printf("Numero de superficies debe ser mayor o igual a cero!\n Se termina el programa.");
    return 0;}

  if ((ptr2=fopen("figura.dat","r"))==NULL){
    printf("No se encontr el archivo de figura!\n Se termina el programa.");
    return 0;}
  fscanf(ptr2,"%d",&puntosfigura);
  if (puntosfigura<=0) {
    printf("Numero de puntos en figura debe ser mayor que cero!\n Se termina el programa.");
    return 0;}

  printf("Entre el numero de rayos por punto y el angulo maximo:\n");
  scanf ("%d%lf",&numrayos,&amax);
  double rayos[superficies+1][3][numrayos][puntosfigura];
  double conicas[superficies][5];
  double figura[puntosfigura][2];
  double focor[puntosfigura],focoz[puntosfigura],desv[puntosfigura],temp1,temp2,contador=0;
  for (i=0;i<superficies;i++)
    fscanf (ptr,"%lf%lf%lf%lf%lf",&conicas[i][0],&conicas[i][1],&conicas[i][2],&conicas[i][3],&conicas[i][4]);

  for (i=0;i<puntosfigura;i++)
    fscanf (ptr2,"%lf%lf",&figura[i][0],&figura[i][1]);

  amax=amax*PI/180;
  deltaang=(double)amax*2/(numrayos-1);
  for (k=0;k<puntosfigura;k++) {
    coordzi=figura[k][0];
    coordri=figura[k][1];
    coref=corefini;

    for(j=0;j<numrayos;j++){
      ang=amax-j*deltaang;
      coordr=coordri;
      coordz=coordzi;
      rayos[0][0][j][k]=coordr;
      rayos[0][1][j][k]=coordz;
      rayos[0][2][j][k]=ang;
      for (i=0;i<superficies;i++){
         locz=conicas[i][0];
         curv=conicas[i][1];
         param=conicas[i][2];
         corefant=coref;
         coref=conicas[i][3];
         nat=conicas[i][4];
         puntoz=interseccion(coordr,coordz,ang,locz,curv,param);
         puntor=rayo(coordr,coordz,ang,puntoz);
         angc=anguloc(locz,curv,param,puntor);
         angin=anguloin(ang,angc);
         angtr=angulotr(angin,corefant,coref);
         angref=anguloref(angin);          /*hasta aqui no hay cambios*/
         coordr=puntor;
         coordz=puntoz;
         if (nat==1) ang=anguloout(angtr,angc);
         if (nat==2) ang=anguloout(angref,angc);
         rayos[i+1][0][j][k]=coordr;
         rayos[i+1][1][j][k]=coordz;
         rayos[i+1][2][j][k]=ang;
         }       /*luego de esto tenemos el rayo final*/
       }

     contador=0;
     focoz[k]=0;
     focor[k]=0;
     for (j=0;j<numrayos-1;j++){
       for (i=j+1;i<numrayos;i++){
         temp1=converg(rayos[superficies][1][j][k],rayos[superficies][2][j][k],rayos[superficies][0][j][k],
                             rayos[superficies][1][i][k],rayos[superficies][2][i][k],rayos[superficies][0][i][k]);
         focoz[k]+=temp1;
         temp2=rayo(rayos[superficies][0][j][k],rayos[superficies][1][j][k],rayos[superficies][2][j][k],temp1);
         focor[k]+=temp2;
         desv[k]+=temp1*temp1+temp2*temp2;
         contador++;
          }
       }

     focoz[k]=(double)focoz[k]/contador;
     focor[k]=(double)focor[k]/contador;
     desv[k]=(double)desv[k]/contador-(focoz[k]*focoz[k]+focor[k]*focor[k]);
     desv[k]=sqrt(desv[k]);
   }
   ptrw=fopen("out.txt","w");
   for(k=0;k<puntosfigura;k++){
     for(j=0;j<numrayos;j++){
       for (i=0;i<superficies;i++){
         for (z=rayos[i][1][j][k];fabs((rayos[i+1][1][j][k])-z) >2*RESOLUCION;
              z+=signo(rayos[i][1][j][k],rayos[i+1][1][j][k])*RESOLUCION)
           fprintf(ptrw,"%f\t%f\n",z,rayo(rayos[i][0][j][k],rayos[i][1][j][k],rayos[i][2][j][k],z));
         }
       for (z=rayos[superficies][1][j][k];signo(rayos[superficies][1][j][k],
                    focoz[k])*focoz[k]>(z-signo(rayos[superficies][1][j][k],focoz[k]))*signo(rayos[superficies][1][j][k],
                    focoz[k]);z+=signo(rayos[superficies][1][j][k],focoz[k])*RESOLUCION)
         fprintf(ptrw,"%f\t%f\n",z,rayo(rayos[superficies][0][j][k],rayos[superficies][1][j][k],rayos[superficies][2][j][k],z));
       }
    }
  ptrw2=fopen("figout.txt","w");
  for (k=0;k<puntosfigura;k++)
    fprintf(ptrw2,"%f\t\t%f\t\t%f\n",focoz[k],focor[k],desv[k]);
  for (k=0;k<puntosfigura;k++)
    fprintf(ptrw2,"%f\t\t%f\n",figura[k][0],figura[k][1]);

  return 0;}

double converg(double x1,double alfa1,double b1,double x2,double alfa2,double b2){
  double m1,m2,pconvx;
  m1=tan(alfa1);
  m2=tan(alfa2);
  pconvx=(m1*x1-m2*x2+b2-b1)/(m1-m2);
  return pconvx;
  }

double signo(double x1,double x2){
  if (x2>x1) return 1;
  if (x2<x1) return -1;
  }

double anguloref (double the) {
  double antw;
  antw=0-the;
  return antw;
  }

double angulotr (double the,double n1,double n2){
  double antw;
  antw=(n1/n2)*sin(the);
  antw=asin(antw);
  return antw;
  }
double anguloout(double thtr,double thsup){
  double answ;
  answ=thtr+thsup;
  return answ;
  }

double anguloin (double thray,double thsup){
  double answ;
  answ=thray-thsup;
  return answ;
  }

double anguloc(double zz,double cc,double pp,double rr){
  double tangente,ans;
  tangente=-(conica(0,cc,pp,rr+DELTA)-conica(0,cc,pp,rr-DELTA))/(2*DELTA);
  ans=atan(tangente);
  return ans;
  }

double interseccion (double por,double poz,double th,double pz,double cur,double pa){
  double cz=-2*DELTA,dif=2*DELTA;
  while (fabs(dif)>DELTA){
    cz+=dif;
    dif=conica(pz,cur,pa,rayo(por,poz,th,cz))-cz;
    }
  return cz;
  }

double rayo (double posr,double posz,double theta,double zeta){
  double res,angulorad,pendiente;
  pendiente=tan(theta);
  res=(zeta-posz)*pendiente+posr;
  return res;
  }

double conica (double posz,double curvat,double para,double r){
  double res;
  res=(double)(curvat*r*r)/(1+sqrt(1-para*curvat*curvat*r*r));
  res=posz+res;
  return res;
  }







