#include <stdio.h>
#include <math.h>
#define DELTA 0.0001
#define PI 3.141592654
#define RESOLUCION 0.05

double rayo (double,double,double,double);
double conica (double, double, double,double);
double interseccion(double,double,double,double,double,double);
double anguloc (double,double,double,double);
double anguloin (double,double);
double anguloout(double,double);
double angulotr (double,double,double);
double anguloref (double);
double signo(double,double);

main(){
  FILE *ptr;
  FILE *ptrw;
  int superficies;
  int i,j,numrayos;
  double coordri,coordzi,coordr,coordz,ang,amax;   /*iniciales*/
  double locz,curv,param,deltaang;           /*se cargan del arreglo*/
  double angc,angin,angtr,angref,puntoz,puntor,z;   /*uso temporal*/
  double corefini=1,coref,corefant,nat;
  if ((ptr=fopen("lentes.dat","r"))==NULL){
    printf("No se encontr el archivo de datos!\n Se termina el programa.");
    return 0;}
  fscanf(ptr,"%lf",&corefini);
  fscanf(ptr,"%d",&superficies);
  if (superficies<0) {
    printf("Numero de superficies debe ser mayor o igual a cero!\n Se termina el programa.");
    return 0;}

  printf("Entre por favor los datos del rayo principal:\n<coordenadas iniciales r,z>\n");
  scanf("%lf%lf",&coordri,&coordzi);
  printf("Diga cuantos rayos (minimo 2) y la inclinacion maxima\n");
  scanf("%d%lf",&numrayos,&amax);
  double rayos[superficies+1][3][numrayos];
  double conicas[superficies][5];
  for (i=0;i<superficies;i++)
    fscanf (ptr,"%lf%lf%lf%lf%lf",&conicas[i][0],&conicas[i][1],&conicas[i][2],&conicas[i][3],&conicas[i][4]);

  amax=amax*PI/180;
  deltaang=(double)amax*2/(numrayos-1);
  printf("   R\t\t   Z\t\tangulo(rad)");
  for(j=0;j<numrayos;j++){
    ang=amax-j*deltaang;
    coordr=coordri;
    coordz=coordzi;
    coref=corefini;
    rayos[0][0][j]=coordr;
    rayos[0][1][j]=coordz;
    rayos[0][2][j]=ang;
    printf("\n");
    for (i=0;i<superficies;i++){
       printf("%f\t%f\t%f\n",coordr,coordz,ang);
       locz=conicas[i][0];
       curv=conicas[i][1];
       param=conicas[i][2];
       corefant=coref;
       coref=conicas[i][3];
       nat=conicas[i][4];
       puntoz=interseccion(coordr,coordz,ang,locz,curv,param);
       puntor=rayo(coordr,coordz,ang,puntoz);
       angc=anguloc(locz,curv,param,puntor);
       angin=anguloin(ang,angc);
       angtr=angulotr(angin,corefant,coref);
       angref=anguloref(angin);          /*hasta aqui no hay cambios*/
       coordr=puntor;
       coordz=puntoz;
       if (nat>1.5) ang=anguloout(angref,angc);
         else ang=anguloout(angtr,angc);
       rayos[i+1][0][j]=coordr;
       rayos[i+1][1][j]=coordz;
       rayos[i+1][2][j]=ang;
       if (i==superficies-1) printf("%f\t%f\t%f\n",coordr,coordz,ang);
       }       /*luego de esto tenemos el rayo final*/
     }
   ptrw=fopen("out.txt","w");
   for(j=0;j<numrayos;j++){
     for (i=0;i<superficies;i++){
       for (z=rayos[i][1][j];fabs((rayos[i+1][1][j])-z) >2*RESOLUCION;z+=signo(rayos[i][1][j],rayos[i+1][1][j])*RESOLUCION)
         fprintf(ptrw,"%f\t%f\n",z,rayo(rayos[i][0][j],rayos[i][1][j],rayos[i][2][j],z));
         }
       }

  return 0;}

double signo(double x1,double x2){
  if (x2>x1) return 1;
  if (x2<x1) return -1;
  }

double anguloref (double the) {
  double antw;
  antw=0-the;
  return antw;
  }

double angulotr (double the,double n1,double n2){
  double antwt;
  antwt=(n1/n2)*sin(the);
  antwt=asin(antwt);
  return antwt;
  }
double anguloout(double thtr,double thsup){
  double answ;
  answ=thtr+thsup;
  return answ;
  }

double anguloin (double thray,double thsup){
  double answ;
  answ=thray-thsup;
  return answ;
  }

double anguloc(double zz,double cc,double pp,double rr){
  double tangente,ans;
  tangente=-(conica(0,cc,pp,rr+DELTA)-conica(0,cc,pp,rr-DELTA))/(2*DELTA);
  ans=atan(tangente);
  return ans;
  }

double interseccion (double por,double poz,double th,double pz,double cur,double pa){
  double cz=-2*DELTA,dif=2*DELTA;
  while (fabs(dif)>DELTA){
    cz+=dif;
    dif=conica(pz,cur,pa,rayo(por,poz,th,cz))-cz;
    }
  return cz;
  }

double rayo (double posr,double posz,double theta,double zeta){
  double res,angulorad,pendiente;
  pendiente=tan(theta);
  res=(zeta-posz)*pendiente+posr;
  return res;
  }

double conica (double posz,double curvat,double para,double r){
  double res;
  res=(double)(curvat*r*r)/(1+sqrt(1-para*curvat*curvat*r*r));
  res=posz+res;
  return res;
  }







