import java.util.*;
import java.net.*;
import java.io.*;


public class FileTransfer
{
    ClientPI clientPI;



    public FileTransfer(ClientPI pi)
    {
        this.clientPI = pi;
    }



    public void downloadFileInPassive(String fileName) throws IOException
    {

        // Set type to binary
        System.out.println(clientPI.sendCommand("TYPE I").getResponseText());

        // Get the port address of the server DTP
        String[] address = getDataSocketAddress(clientPI.sendCommand("PASV")
                .getResponseText());

        if(address == null)
        {
            throw new FTPException("Could not obtain socket address");
        }

        String hostName = address[0];
        for(int i=1;i<4;i++)
        {
            hostName += "."+address[i];
        }

        int port = (Integer.parseInt(address[4]) *256)+
            Integer.parseInt(address[5]);


        // connect to the server DTP
        Socket dataTransferSocket = new Socket(hostName,port);



        // Issue a RETR command
        System.out.println(clientPI.sendCommand("RETR "+fileName).getResponseText());



        // Download the data from the socket to the 
        // file system (Below is really the client DTP!)
        FileOutputStream outputStream = new FileOutputStream(fileName);
        InputStream inputStream = dataTransferSocket.getInputStream();
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        while((bytesRead = inputStream.read(buffer)) > -1)
        {
            outputStream.write(buffer, 0, bytesRead);
        }
        outputStream.flush();
        outputStream.close();
        inputStream.close();

        dataTransferSocket.close();


        // Get the completion reply from the server.
        System.out.println(clientPI.getReply().getResponseText());
    }

    public void uploadFileInPassive(String fileName) throws IOException
    {

        // Set type to binary
        System.out.println(clientPI.sendCommand("TYPE I").getResponseText());

        // Get the port address of the server DTP
        String[] address = getDataSocketAddress(clientPI.sendCommand("PASV")
                .getResponseText());

        if(address == null)
        {
            throw new FTPException("Could not obtain socket address");
        }

        String hostName = address[0];
        for(int i=1;i<4;i++)
        {
            hostName += "."+address[i];
        }

        int port = (Integer.parseInt(address[4]) *256)+
            Integer.parseInt(address[5]);


        // connect to the server DTP
        Socket dataTransferSocket = new Socket(hostName,port);



        // Issue a RETR command
        System.out.println(clientPI.sendCommand("STOR "+fileName).getResponseText());



        // Download the data from the socket to the 
        // file system (Below is really the client DTP!)
        FileInputStream inputStream = new FileInputStream(fileName);
        OutputStream outputStream = dataTransferSocket.getOutputStream();
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        while((bytesRead = inputStream.read(buffer)) > -1)
        {
            outputStream.write(buffer, 0, bytesRead);
        }
        outputStream.flush();
        outputStream.close();
        inputStream.close();

        dataTransferSocket.close();


        // Get the completion reply from the server.
        System.out.println(clientPI.getReply().getResponseText());
    }



    public void downloadFileInActive(String fileName) throws IOException
    {
        ServerSocket serverSocket = new ServerSocket(0);
        String socketAddress = getSocketAddress(serverSocket.getLocalPort());

        // Set type to binary
        System.out.println(clientPI.sendCommand("TYPE I").getResponseText());

        // Send the port command with the local socket
        // address
        System.out.println(clientPI.sendCommand("PORT "+socketAddress).getResponseText());

        // send the RETR command with the file name
        System.out.println(clientPI.sendCommand("RETR "+fileName).getResponseText());

        // Start listening for socket connections
        Socket dataTransferSocket = serverSocket.accept();

        // Client DTP process
        FileOutputStream outputStream = new FileOutputStream(fileName);
        InputStream inputStream = dataTransferSocket.getInputStream();
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        while((bytesRead = inputStream.read(buffer)) > -1)
        {
            outputStream.write(buffer, 0, bytesRead);
        }
        outputStream.flush();
        outputStream.close();
        inputStream.close();

        dataTransferSocket.close();


        // Get the completion reply from the server.
        System.out.println(clientPI.getReply());

    }

    public void uploadFileInActive(String fileName) throws IOException
    {
        ServerSocket serverSocket = new ServerSocket(0);
        String socketAddress = getSocketAddress(serverSocket.getLocalPort());

        // Set type to binary
        System.out.println(clientPI.sendCommand("TYPE I").getResponseText());

        System.out.println(clientPI.sendCommand("PORT "+socketAddress).getResponseText());

        // send the STOR command with the file name
        System.out.println(clientPI.sendCommand("STOR "+fileName).getResponseText());
        Socket dataTransferSocket = serverSocket.accept();
        FileInputStream inputStream = new FileInputStream(fileName);
        OutputStream outputStream = dataTransferSocket.getOutputStream();
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        while((bytesRead = inputStream.read(buffer)) > -1)
        {
            outputStream.write(buffer, 0, bytesRead);
        }
        outputStream.flush();
        outputStream.close();
        inputStream.close();

        dataTransferSocket.close();


        // Get the completion reply from the server.
        System.out.println(clientPI.getReply());
    }


    private String getSocketAddress(int port) throws IOException
    {
        String hostAddress = null;
        try
        {
            hostAddress = 
                InetAddress.getLocalHost().getHostAddress();
            hostAddress = hostAddress.replace('.',',');
        }
        catch(Exception e)
        {
            throw new IOException("Cannot send port command "
                    +e.getMessage());
        }
        return hostAddress+","+(port>>8)+","+(port & 255);
    }

    private String[] getDataSocketAddress(String s)
    {
        System.out.println("Parsing socket address from "+s);
        String[] socketAddressParts = new String[6];
        int beginIdx = s.indexOf('(');
        int endIdx = s.indexOf(')');

        if(beginIdx < 0 ||
            endIdx < 0 )
        {
            return null;
        }

        String addressString = s.substring(
             beginIdx+1, endIdx);

        StringTokenizer st = new StringTokenizer(addressString, ",");
        for(int i=0;i<6;i++)
        {
            socketAddressParts[i]=st.nextToken();
        }
        return socketAddressParts;
    }

    public void listDirectoryInPassive(String path) throws IOException
    {
        // Get the port address of the server DTP
        String[] address = getDataSocketAddress(clientPI.sendCommand("PASV")
                .getResponseText());

        if(address == null)
        {
            throw new FTPException("Could not obtain socket address");
        }

        String hostName = address[0];
        for(int i=1;i<4;i++)
        {
            hostName += "."+address[i];
        }

        int port = (Integer.parseInt(address[4]) *256)+
            Integer.parseInt(address[5]);


        // connect to the server DTP
        Socket dataTransferSocket = new Socket(hostName,port);


        // Issue a LIST command
        System.out.println(clientPI.sendCommand("LIST "+path).getResponseText());



        // Download the data from the socket to the 
        // console
        BufferedReader reader  = new BufferedReader(new InputStreamReader(
                    dataTransferSocket.getInputStream()));
        String  line = null;;
        while((line = reader.readLine()) != null)
        {
            System.out.println(line);
        }
        reader.close();
        dataTransferSocket.close();


        // Get the completion reply from the server.
        System.out.println(clientPI.getReply().getResponseText());
    }
            


    public static void main(String[] args) throws Exception
    {
        String user = "anonymous";
        String password = "somebody@somewhere.com";
        String host = "ftp.vim.org";
        int port = 21;

        ClientPI clientPI = new ClientPI(host,port);
        clientPI.open();
        clientPI.getReply();
        clientPI.sendCommand("USER "+user);
        clientPI.sendCommand("PASS "+password);

        clientPI.sendCommand("CWD pub/vim/");

        FileTransfer ft = new FileTransfer(clientPI);
        ft.listDirectoryInPassive(" .");
        ft.downloadFileInPassive(args[0]);
    }
}
