/*
 * Decompiled with CFR 0.152.
 */
package dope;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.rms.RecordStore;

public class HighScores {
    private static final int MAX_SCORES = 5;
    private static final String FILE_NAME = "dw_scores";
    private RecordStore scoreStore;
    private Vector scoreVector = new Vector();
    private int numScores;
    private boolean addedScore;

    public HighScores() {
        this.readFile();
    }

    public boolean addScore(long l) {
        this.addedScore = true;
        this.insertScoreAt(0, l);
        this.closeFile();
        this.readFile();
        return this.addedScore;
    }

    public Long byteArrayToLong(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        long l = dataInputStream.readLong();
        return new Long(l);
    }

    private void closeFile() {
        try {
            int n = 0;
            while (n < this.scoreVector.size()) {
                byte[] byArray = this.longToByteArray((Long)this.scoreVector.elementAt(n));
                if (n < this.scoreStore.getNumRecords()) {
                    this.scoreStore.setRecord(n, byArray, 0, byArray.length);
                } else {
                    this.scoreStore.addRecord(byArray, 0, byArray.length);
                }
                ++n;
            }
            this.scoreStore.closeRecordStore();
        }
        catch (Exception exception) {
            this.numScores = 0;
        }
    }

    public int getNumScores() {
        return this.numScores;
    }

    public Vector getScores() {
        return this.scoreVector;
    }

    public String getTitle() {
        if (this.numScores == 5) {
            return "Top 5 Scores";
        }
        return "High Scores";
    }

    private int insertScoreAt(int n, long l) {
        if (n == 5) {
            this.addedScore = false;
            return n;
        }
        if (n >= this.scoreVector.size()) {
            this.scoreVector.addElement(new Long(l));
            return n;
        }
        long l2 = (Long)this.scoreVector.elementAt(n);
        if (l > l2) {
            this.scoreVector.insertElementAt(new Long(l), n);
        } else {
            this.insertScoreAt(++n, l);
        }
        return n;
    }

    private byte[] longToByteArray(Long l) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeLong(l);
        return byteArrayOutputStream.toByteArray();
    }

    private void readFile() {
        this.numScores = 0;
        this.scoreVector.removeAllElements();
        try {
            this.scoreStore = RecordStore.openRecordStore((String)FILE_NAME, (boolean)true);
            this.numScores = this.scoreStore.getNumRecords();
            if (this.numScores > 5) {
                this.numScores = 5;
            }
            int n = 0;
            while (n < this.numScores) {
                this.scoreVector.addElement(this.byteArrayToLong(this.scoreStore.getRecord(n)));
                ++n;
            }
        }
        catch (Exception exception) {
            this.numScores = 0;
        }
    }
}

