/*
 * Decompiled with CFR 0.152.
 */
package dope;

import dope.Drug;
import dope.HighScores;
import dope.Message;
import dope.Submission;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class DopeWars
extends MIDlet
implements CommandListener {
    public static final int NUM_DRUGS = 8;
    public static final int NUM_LOCATIONS = 6;
    public static final int NUM_MSGS = 17;
    public static final int NUM_DAYS = 31;
    public static final int NUM_TIPS = 5;
    public static final int ACID = 0;
    public static final int COCAINE = 1;
    public static final int KETAMINE = 2;
    public static final int ECSTASY = 3;
    public static final int HEROIN = 4;
    public static final int WEED = 5;
    public static final int SHROOMS = 6;
    public static final int SPEED = 7;
    public static final int LOAN_FACTOR = 5;
    public static final long MIN_LOAN = 5500L;
    public static final long MAX_LOAN = 999999999L;
    public static final long MIN_BAIL = 5500L;
    public static final long INIT_CASH = 2000L;
    public static final long COP_BOUNTY = 200000L;
    public static final int NONE = 0;
    public static final int START = 1;
    public static final int ABOUT = 2;
    public static final int SPLASH = 3;
    public static final int SCORES = 4;
    public static final int NAME = 5;
    public static final int CITY = 6;
    public static final int EXIT = 7;
    public static final int STATS = 8;
    public static final int DEPOSIT = 9;
    public static final int BORROW = 10;
    public static final int REPAY = 11;
    public static final int WITHDRAW = 12;
    public static final int CHASE = 13;
    public static final int DIE = 14;
    public static final int ESCAPE = 15;
    public static final int PRISON = 16;
    public static final int CATCH = 17;
    public static final int BAIL = 18;
    public static final int SHOT = 19;
    public static final int NEWS = 20;
    public static final int COAT = 21;
    public static final int GUN = 22;
    public static final int BUY = 23;
    public static final int SELL = 24;
    public static final int FLY = 25;
    public static final int MAX_COPS = 3;
    public static final String NO_MONEY_MSG = "You don't have enough money.";
    public static final String NEG_QUANTITY_MSG = "Don't mess with these people.";
    private Drug[] gameDrugs = new Drug[]{new Drug("Acid"), new Drug("Cocaine"), new Drug("Ketamine"), new Drug("Ecstasy"), new Drug("Heroin"), new Drug("Weed"), new Drug("Shrooms"), new Drug("Speed")};
    private String[] gameLocations = new String[]{"London", "New York", "Amsterdam", "Bogota", "Los Angeles", "Kabul"};
    private Message[] gameMessages = new Message[]{new Message(26, "A bust sends Weed prices sky-high!", 5, 4, 0, 0), new Message(40, "The cops seize a major Ecstasy shipment. Prices rocket!", 3, 4, 0, 0), new Message(50, "A bust sends Heroin prices sky-high!", 4, 4, 0, 0), new Message(26, "The cops make a big bust. Ketamine prices are outrageous!", 2, 5, 0, 0), new Message(70, "The cops make a big bust. Cocaine prices are sky-high!", 1, 4, 0, 0), new Message(30, "A bust sends Speed prices sky-high!", 7, 4, 0, 0), new Message(50, "Junkies will pay anything for Smack!", 4, 8, 0, 0), new Message(40, "Addicts will pay anything for Amphetamine!", 7, 8, 0, 0), new Message(40, "Ravers are buying E at outrageous prices!", 3, 8, 0, 0), new Message(34, "Druggies are desperate for Shrooms!", 6, 8, 0, 0), new Message(70, "Demand for Charlie has soared!", 1, 8, 0, 0), new Message(34, "Home-made LSD floods the market!", 0, 0, 8, 0), new Message(20, "A Colombian shipment floors Weed prices!", 5, 0, 4, 0), new Message(22, "Vets are selling Special-K on the cheap!", 2, 0, 8, 0), new Message(110, "You find some Blow in a luggage locker!", 1, 0, 0, 3), new Message(90, "You meet a friend, who lays some Acid on you!", 0, 0, 0, 6), new Message(70, "You find some Es in the subway!", 3, 0, 0, 4)};
    private String[] gameTips = new String[]{"Ketamine prices are very volatile.", "Don't shoot at the CIA if you're about to retire with a fortune.", "You can make a killing by muling weed.", "The courts can often tell how big a player you are; keep enough cash on you to pay bail.", "A Glock in each hand is your best defence."};
    HighScores gameScores;
    Submission scoreSub;
    private long myCash;
    private long myDebt;
    private long myBank;
    private int myCoat;
    private int myGuns;
    private int myTotal;
    private int myLocation;
    private int myDaysLeft;
    private int myCops;
    private boolean myLoanToday;
    private int currState = 0;
    private int currDrug;
    private long currBail;
    private long currLoan;
    private int currMsg;
    private int currTip;
    private boolean currGame;
    private Displayable currOutput;
    private boolean currError;
    private long[] currScores;
    private int currScoreIndex;
    private Display myDisplay;
    private List cityOutput;
    private List travelOutput;
    private List statsOutput;
    private List menuOutput;
    private Form userOutput;
    private List scoresOutput;
    private Command cancelButton = new Command("Cancel", 4, 2);
    private Command noButton = new Command("No", 4, 2);
    private Command backButton = new Command("Back", 4, 1);
    private Command splashButton = new Command("Ok", 4, 1);
    private Command msgButton = new Command("Ok", 4, 1);
    private Command questionButton = new Command("Yes", 4, 1);
    private Command quantityButton = new Command("Ok", 4, 1);
    private Command userButton = new Command("Ok", 4, 1);
    private Command menuButton = new Command("Ok", 4, 1);
    private Command buyButton = new Command("Buy", 4, 1);
    private Command sellButton = new Command("Sell", 4, 2);
    private Command flyButton = new Command("Fly", 4, 3);
    private Command statsButton = new Command("Stats", 4, 4);
    private Command exitButton = new Command("Exit", 4, 5);
    private Command submitButton = new Command("Submit", 4, 2);
    private Command increaseButton = new Command("Increase", 4, 2);
    private Command decreaseButton = new Command("Decrease", 4, 3);
    private Command travelButton = new Command("Ok", 4, 1);
    private int quantityLength = String.valueOf(Long.MAX_VALUE).length() - 1;
    private Random rand = new Random();

    public DopeWars() {
        this.currTip = this.getRandom(4);
        this.gameScores = new HighScores();
        this.myDisplay = Display.getDisplay((MIDlet)this);
    }

    private void askQuantity(String string, String string2, int n) {
        this.currState = n;
        Form form = new Form(string);
        TextField textField = new TextField(string2, "", this.quantityLength, 2);
        form.append((Item)textField);
        form.addCommand(this.cancelButton);
        form.addCommand(this.quantityButton);
        form.setCommandListener((CommandListener)this);
        this.myDisplay.setCurrent((Displayable)form);
        this.currOutput = form;
    }

    private void askQuestion(String string, String string2, int n) {
        this.currState = n;
        Form form = new Form(string);
        form.append(string2);
        form.addCommand(this.noButton);
        form.addCommand(this.questionButton);
        form.setCommandListener((CommandListener)this);
        this.myDisplay.setCurrent((Displayable)form);
    }

    private void askUserID() {
        this.currState = 5;
        this.scoreSub = new Submission();
        String string = "";
        this.userOutput = new Form("Submission");
        TextField textField = new TextField("What is your registration code?", this.scoreSub.getLastUserID(), this.scoreSub.getUserIDLen(), 0);
        this.userOutput.append((Item)textField);
        this.userOutput.addCommand(this.cancelButton);
        this.userOutput.addCommand(this.userButton);
        this.userOutput.setCommandListener((CommandListener)this);
        this.myDisplay.setCurrent((Displayable)this.userOutput);
        this.currOutput = this.userOutput;
    }

    private void borrowMoney() {
        this.currLoan = this.myCash * 5L;
        if (this.currLoan < 5500L) {
            this.currLoan = 5500L;
        } else if (this.currLoan + this.myCash > 999999999L) {
            this.currLoan = 999999999L - this.myCash;
        }
        this.askQuantity("Bank", "You can borrow up to " + this.formatMoney(this.currLoan) + ".", 10);
    }

    private void buyCoat() {
        this.myCash -= 200L;
        this.myCoat += 40;
        this.displayOutput();
    }

    private void buyDrugs() {
        this.currDrug = this.cityOutput.getSelectedIndex();
        if (this.gameDrugs[this.currDrug].price == 0) {
            this.showMsg("Sorry", String.valueOf(this.gameDrugs[this.currDrug].name) + " isn't on sale.", 6);
        } else if ((long)this.gameDrugs[this.currDrug].price > this.myCash) {
            this.showMsg("Sorry", NO_MONEY_MSG, 6);
        } else if (this.myTotal == this.myCoat) {
            this.showMsg("Sorry", "Your suitcase is full.", 6);
        } else {
            int n = (int)(this.myCash / (long)this.gameDrugs[this.currDrug].price);
            String string = n + this.myTotal > this.myCoat ? "You can carry up to " + (this.myCoat - this.myTotal) + "." : "At " + this.formatMoney(this.gameDrugs[this.currDrug].price) + " each, you can afford " + n + ".";
            this.askQuantity(this.gameDrugs[this.currDrug].name, string, 23);
        }
    }

    private void buyGun() {
        this.myCash -= 400L;
        ++this.myGuns;
        this.displayOutput();
    }

    private void checkBorrow(long l) {
        if (l == 0L) {
            this.displayOutput();
        } else if (l < 0L) {
            this.showError("Careful", NEG_QUANTITY_MSG, 10);
        } else if (l > this.currLoan) {
            this.showError("Sorry", "You can't borrow that much.", 10);
        } else {
            this.myDebt += l;
            this.myCash += l;
            this.myLoanToday = true;
            this.displayOutput();
        }
    }

    private void checkBuyDrugs(int n) {
        if (n < 0) {
            this.showError("Careful", NEG_QUANTITY_MSG, 23);
        } else if ((long)(n * this.gameDrugs[this.currDrug].price) > this.myCash) {
            this.showError("Sorry", NO_MONEY_MSG, 23);
        } else if (n + this.myTotal > this.myCoat) {
            this.showError("Sorry", "You haven't got enough suitcase space.", 23);
        } else {
            this.myCash -= (long)(n * this.gameDrugs[this.currDrug].price);
            this.gameDrugs[this.currDrug].quantity += n;
            this.displayOutput();
        }
    }

    private void checkDeposit(long l) {
        if (l < 0L) {
            this.showError("Careful", NEG_QUANTITY_MSG, 9);
        } else if (this.myCash < l) {
            this.showError("Sorry", NO_MONEY_MSG, 9);
        } else {
            this.myBank += l;
            this.myCash -= l;
            this.displayOutput();
        }
    }

    private void checkRepay(long l) {
        if (l < 0L) {
            this.showError("Careful", NEG_QUANTITY_MSG, 11);
        } else if (l > this.myCash) {
            this.showError("Sorry", "You can't afford to repay that much.", 11);
        } else if (l > this.myDebt) {
            this.showError("Bank", "Your loan isn't that large.", 11);
        } else {
            this.myDebt -= l;
            this.myCash -= l;
            this.displayOutput();
        }
    }

    private void checkSellDrugs(int n) {
        if (n < 0) {
            this.showError("Careful", NEG_QUANTITY_MSG, 24);
        } else if (n > this.gameDrugs[this.currDrug].quantity) {
            this.showError("Sorry", "You don't have that much to sell.", 24);
        } else {
            this.myCash += (long)(n * this.gameDrugs[this.currDrug].price);
            this.gameDrugs[this.currDrug].quantity -= n;
            this.displayOutput();
        }
    }

    private void checkWithdraw(long l) {
        if (l < 0L) {
            this.showError("Careful", NEG_QUANTITY_MSG, 12);
        } else if (this.myBank < l) {
            this.showError("Sorry", "You don't have that much in the bank.", 12);
        } else {
            this.myBank -= l;
            this.myCash += l;
            this.displayOutput();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cancelButton || command == this.msgButton) {
            this.displayOutput();
            return;
        }
        if (command == this.menuButton || displayable == this.menuOutput && command == List.SELECT_COMMAND) {
            int n = this.menuOutput.getSelectedIndex();
            int n2 = this.menuOutput.size();
            if (n == 0) {
                this.startGame();
                return;
            } else if (n == n2 - 1) {
                this.quitGame();
                return;
            } else if (n == n2 - 2) {
                this.initAbout();
                return;
            } else if (n == 1 && this.currGame) {
                this.currState = 6;
                this.displayOutput();
                return;
            } else {
                this.initScores();
            }
            return;
        }
        if (command == this.splashButton) {
            this.initMenu();
            return;
        }
        if (command == this.backButton) {
            switch (this.currState) {
                case 8: {
                    this.currState = 6;
                    this.displayOutput();
                    return;
                }
                case 2: 
                case 4: {
                    this.initMenu();
                    return;
                }
                default: {
                    return;
                }
            }
        }
        if (command == this.submitButton || displayable == this.scoresOutput && command == List.SELECT_COMMAND) {
            this.currScoreIndex = this.scoresOutput.getSelectedIndex();
            this.showMsg("Sorry", "Online score submission is not available in the Beta.", 4);
            return;
        }
        if (command == this.questionButton) {
            switch (this.currState) {
                case 21: {
                    this.buyCoat();
                    return;
                }
                case 22: {
                    this.buyGun();
                    return;
                }
                case 13: {
                    this.shootCops();
                    return;
                }
                case 18: {
                    this.payBail();
                    return;
                }
                default: {
                    return;
                }
            }
        }
        if (command == this.noButton) {
            switch (this.currState) {
                case 21: 
                case 22: {
                    this.displayOutput();
                    return;
                }
                case 13: {
                    this.escapeCops(false);
                    return;
                }
                case 18: {
                    this.currState = 16;
                    this.displayOutput();
                    return;
                }
                default: {
                    return;
                }
            }
        }
        if (command == this.quantityButton) {
            long l = 0L;
            try {
                Form form;
                if (displayable instanceof Form && (form = (Form)displayable).get(0) instanceof TextField) {
                    TextField textField = (TextField)form.get(0);
                    l = Long.parseLong(textField.getString());
                }
            }
            catch (Exception exception) {}
            switch (this.currState) {
                case 23: {
                    this.checkBuyDrugs((int)l);
                    return;
                }
                case 24: {
                    this.checkSellDrugs((int)l);
                    return;
                }
                case 9: {
                    this.checkDeposit(l);
                    return;
                }
                case 10: {
                    this.checkBorrow(l);
                    return;
                }
                case 12: {
                    this.checkWithdraw(l);
                    return;
                }
                case 11: {
                    this.checkRepay(l);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        if (command == this.userButton || displayable == this.userOutput && command == List.SELECT_COMMAND) {
            String string = "";
            try {
                Form form;
                if (displayable instanceof Form && (form = (Form)displayable).get(0) instanceof TextField) {
                    TextField textField = (TextField)form.get(0);
                    string = textField.getString();
                }
            }
            catch (Exception exception) {}
            this.submitHighScore(this.currScores[this.currScoreIndex], string);
            return;
        }
        if (command == this.buyButton) {
            this.buyDrugs();
            return;
        } else if (command == this.sellButton || displayable == this.cityOutput && command == List.SELECT_COMMAND) {
            this.sellDrugs();
            return;
        } else if (command == this.exitButton) {
            this.initMenu();
            return;
        } else if (command == this.flyButton) {
            this.initTravel();
            return;
        } else if (command == this.travelButton || displayable == this.travelOutput && command == List.SELECT_COMMAND) {
            int n = this.travelOutput.getSelectedIndex();
            if (n >= this.myLocation) {
                ++n;
            }
            this.travelTo(n);
            return;
        } else if (command == this.statsButton) {
            this.initStats();
            return;
        } else if (command == this.increaseButton) {
            int n = this.statsOutput.getSelectedIndex();
            if (n == 2) {
                if (this.myLoanToday) {
                    this.showMsg("Sorry", "Only one loan per day.", 8);
                    return;
                } else {
                    this.borrowMoney();
                }
                return;
            } else if (n == 3) {
                if (this.myCash == 0L) {
                    this.showMsg("Bank", "You have no money to deposit.", 8);
                    return;
                } else {
                    this.askQuantity("Bank", "You can deposit up to " + this.formatMoney(this.myCash) + ".", 9);
                }
                return;
            } else {
                this.showMsg("Sorry", "Your Swiss bankers only handle savings and loans.", 8);
            }
            return;
        } else {
            if (command != this.decreaseButton) return;
            int n = this.statsOutput.getSelectedIndex();
            if (n == 2) {
                if (this.myDebt == 0L) {
                    this.showMsg("Bank", "You have no loan to pay back.", 8);
                    return;
                } else {
                    this.repayMoney();
                }
                return;
            } else if (n == 3) {
                if (this.myBank == 0L) {
                    this.showMsg("Bank", "You have no money to withdraw.", 8);
                    return;
                } else {
                    this.askQuantity("Bank", "You can withdraw up to " + this.formatMoney(this.myBank) + ".", 12);
                }
                return;
            } else {
                this.showMsg("Sorry", "Your Swiss bankers only handle savings and loans.", 8);
            }
        }
    }

    protected void destroyApp(boolean bl) {
    }

    private void displayOutput() {
        if (this.currError) {
            this.currOutput.setCommandListener((CommandListener)this);
            this.myDisplay.setCurrent(this.currOutput);
            this.currError = false;
        } else {
            switch (this.currState) {
                case 20: {
                    this.drugEvents();
                    break;
                }
                case 6: 
                case 25: {
                    this.cityOutput.setCommandListener((CommandListener)this);
                    this.myDisplay.setCurrent((Displayable)this.cityOutput);
                    break;
                }
                case 15: 
                case 18: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    this.initCity();
                    break;
                }
                case 8: {
                    this.statsOutput.setCommandListener((CommandListener)this);
                    this.myDisplay.setCurrent((Displayable)this.statsOutput);
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.initStats();
                    break;
                }
                case 13: {
                    this.escapeCops(true);
                    break;
                }
                case 19: {
                    this.encounterCops(true);
                    break;
                }
                case 17: {
                    this.goToCourt();
                    break;
                }
                case 14: 
                case 16: {
                    this.gameOver();
                    break;
                }
                case 4: 
                case 5: {
                    this.initScores();
                    break;
                }
                case 7: {
                    this.finishGame();
                }
            }
        }
    }

    private void drugEvents() {
        int n = this.currMsg;
        while (n < 17) {
            if (this.getRandom(this.gameMessages[n].freq) == 0 && (this.gameDrugs[this.gameMessages[n].drug].price != 0 || this.gameMessages[n].extra != 0)) {
                if (this.gameMessages[n].dearer > 0) {
                    this.gameDrugs[this.gameMessages[n].drug].price *= this.gameMessages[n].dearer;
                } else if (this.gameMessages[n].cheaper > 0) {
                    this.gameDrugs[this.gameMessages[n].drug].price /= this.gameMessages[n].cheaper;
                } else {
                    this.gameDrugs[this.gameMessages[n].drug].quantity = this.myTotal + this.gameMessages[n].extra > this.myCoat ? (this.gameDrugs[this.gameMessages[n].drug].quantity += this.myCoat - this.myTotal) : (this.gameDrugs[this.gameMessages[n].drug].quantity += this.gameMessages[n].extra);
                }
                this.currMsg = n + 1;
                this.showMsg("News", this.gameMessages[n].msg, 20);
                return;
            }
            ++n;
        }
        this.otherEvents();
    }

    private void encounterCops(boolean bl) {
        if (this.myCops == 0) {
            return;
        }
        String string = String.valueOf(this.myCops) + " CIA agent";
        string = String.valueOf(string) + (this.myCops == 1 ? " is" : "s are");
        if (bl) {
            string = String.valueOf(string) + " still";
        }
        string = String.valueOf(string) + " chasing you.";
        if (this.myGuns > 0) {
            string = String.valueOf(string) + " Do you want to stop and fight?";
            this.askQuestion("CIA", string, 13);
        } else {
            this.showMsg("CIA", string, 13);
        }
    }

    private void escapeCops(boolean bl) {
        if (this.getRandom(6 - this.myCops) == 0) {
            if (this.getRandom(6) == 0) {
                this.showMsg("CIA", "The CIA have caught you!", 17);
            } else if (bl) {
                this.escapeCops(true);
            } else {
                this.encounterCops(true);
            }
        } else {
            this.showMsg("CIA", "You escaped the CIA.", 15);
        }
    }

    private void finishGame() {
        this.currState = 0;
        this.currGame = false;
        this.initMenu();
    }

    private String formatMoney(long l) {
        String string = "$";
        if (l < 100000000L) {
            string = String.valueOf(string) + l;
        } else {
            string = String.valueOf(string) + l / 1000000L;
            int n = (int)(l / 10000L % 100L);
            string = String.valueOf(string) + (n < 10 ? ".0" : ".");
            string = String.valueOf(string) + n;
            string = String.valueOf(string) + " M";
        }
        return string;
    }

    private void gameOver() {
        this.myCash += this.myBank - this.myDebt;
        this.myBank = 0L;
        this.myDebt = 0L;
        int n = 0;
        while (n < 8) {
            this.myCash += (long)(this.gameDrugs[n].quantity * this.gameDrugs[n].price);
            this.gameDrugs[n].quantity = 0;
            ++n;
        }
        if (this.currState == 14) {
            this.showMsg("Game Over", "You died very young.", 7);
        } else if (this.myCash < 0L) {
            this.showMsg("Game Over", "Your Swiss bankers have written you off.", 7);
        } else if (this.myCash > 2000L) {
            String string = "Well done!";
            string = this.currState == 16 ? String.valueOf(string) + "Hey jailbird, you've got " + this.formatMoney(this.myCash) + " waiting for you" : String.valueOf(string) + "You made a cool " + this.formatMoney(this.myCash);
            string = String.valueOf(string) + (this.gameScores.addScore(this.myCash) ? " - a new high score!" : ".");
            this.showMsg("Game Over", string, 7);
        } else {
            this.showMsg("Game Over", "You didn't make any money.", 7);
        }
    }

    private int getRandom(int n) {
        int n2 = this.rand.nextInt() % n;
        if (n2 < 0) {
            n2 += n;
        }
        return n2;
    }

    private void goToCourt() {
        int n = 0;
        while (n < 8) {
            this.gameDrugs[n].quantity = 0;
            ++n;
        }
        this.myGuns = 0;
        this.showMsg("Sorry", "Bail isn't available in the Beta.", 16);
    }

    private void initAbout() {
        this.currState = 2;
        Form form = new Form("About");
        form.append("Dope Wars Beta v0.3 (c) 2001 Alex Dean. All Rights Reserved.");
        form.append("\n\nDope Wars was produced by RedTeam. For more info: http://www.redteam.co.uk/dopewars/");
        form.append("\n\nTip: " + this.gameTips[this.currTip]);
        form.append("\n\nAlex says 'fo' sheezy!' to Carolyn, John Bustard and jaded, Ian at Beermat, Andrew, all at Airside, Richard, Mike at LogicChain and Angus at the MicroJava Network.");
        form.addCommand(this.backButton);
        form.setCommandListener((CommandListener)this);
        this.myDisplay.setCurrent((Displayable)form);
    }

    private void initCity() {
        this.myTotal = 0;
        this.cityOutput = new List(this.gameLocations[this.myLocation], 3);
        int n = 0;
        while (n < 8) {
            this.myTotal += this.gameDrugs[n].quantity;
            String string = String.valueOf(this.gameDrugs[n].quantity) + " " + this.gameDrugs[n].name + " ";
            string = String.valueOf(string) + (this.gameDrugs[n].price > 0 ? this.formatMoney(this.gameDrugs[n].price) : "none");
            this.cityOutput.append(string, null);
            ++n;
        }
        this.cityOutput.addCommand(this.buyButton);
        this.cityOutput.addCommand(this.sellButton);
        this.cityOutput.addCommand(this.flyButton);
        this.cityOutput.addCommand(this.statsButton);
        this.cityOutput.addCommand(this.exitButton);
        this.cityOutput.setCommandListener((CommandListener)this);
        this.myDisplay.setCurrent((Displayable)this.cityOutput);
        this.currState = 6;
    }

    private void initMenu() {
        this.menuOutput = new List("Dope Wars Beta", 3);
        this.menuOutput.append("New Game", null);
        if (this.currGame) {
            this.menuOutput.append("Resume Game", null);
        }
        if (this.gameScores.getNumScores() > 0) {
            this.menuOutput.append("High Scores", null);
        }
        this.menuOutput.append("About", null);
        this.menuOutput.append("Quit Game", null);
        this.menuOutput.addCommand(this.menuButton);
        this.menuOutput.setCommandListener((CommandListener)this);
        this.myDisplay.setCurrent((Displayable)this.menuOutput);
    }

    private void initScores() {
        this.currState = 4;
        this.scoresOutput = new List(this.gameScores.getTitle(), 3);
        Vector vector = this.gameScores.getScores();
        int n = this.gameScores.getNumScores();
        this.currScores = new long[n];
        int n2 = 0;
        while (n2 < n) {
            this.currScores[n2] = (Long)vector.elementAt(n2);
            this.scoresOutput.append(this.formatMoney(this.currScores[n2]), null);
            ++n2;
        }
        this.scoresOutput.addCommand(this.backButton);
        this.scoresOutput.addCommand(this.submitButton);
        this.scoresOutput.setCommandListener((CommandListener)this);
        this.myDisplay.setCurrent((Displayable)this.scoresOutput);
    }

    private void initSplash() {
        this.currState = 3;
        Form form = new Form(null);
        form.append("Dope Wars Beta (c) 2001 Alex Dean");
        form.addCommand(this.splashButton);
        form.setCommandListener((CommandListener)this);
        this.myDisplay.setCurrent((Displayable)form);
    }

    private void initStats() {
        this.currState = 8;
        this.statsOutput = new List("Stats", 3);
        String string = this.myDaysLeft == 1 ? " day" : " days";
        this.statsOutput.append("Time: " + this.myDaysLeft + string, null);
        this.statsOutput.append("Cash: " + this.formatMoney(this.myCash), null);
        this.statsOutput.append("Loan: " + this.formatMoney(this.myDebt), null);
        this.statsOutput.append("Savings: " + this.formatMoney(this.myBank), null);
        this.statsOutput.append("Suitcase: " + this.myTotal + "/" + this.myCoat, null);
        if (this.myGuns > 0) {
            this.statsOutput.append("Glocks: " + this.myGuns, null);
        }
        this.statsOutput.addCommand(this.backButton);
        this.statsOutput.addCommand(this.increaseButton);
        this.statsOutput.addCommand(this.decreaseButton);
        this.statsOutput.setCommandListener((CommandListener)this);
        this.myDisplay.setCurrent((Displayable)this.statsOutput);
    }

    private void initTravel() {
        this.currState = 25;
        this.travelOutput = new List("Travel", 3);
        int n = 0;
        while (n < 6) {
            if (n != this.myLocation) {
                this.travelOutput.append(this.gameLocations[n], null);
            }
            ++n;
        }
        this.travelOutput.addCommand(this.cancelButton);
        this.travelOutput.addCommand(this.travelButton);
        this.travelOutput.setCommandListener((CommandListener)this);
        this.myDisplay.setCurrent((Displayable)this.travelOutput);
    }

    private void otherEvents() {
        if (this.getRandom(12) == 0 && this.myCash >= 200L) {
            this.askQuestion("Suitcase", "Buy a bigger false-bottomed suitcase?", 21);
        } else if (this.myGuns < 2 && this.getRandom(15) == 0 && this.myCash >= 400L) {
            this.askQuestion("Guns", "Buy a Glock ceramic pistol?", 22);
        } else if (this.getRandom(10) == 0 && this.myTotal > 0) {
            this.encounterCops(false);
        } else {
            this.initCity();
        }
    }

    protected void pauseApp() {
    }

    private void payBail() {
        this.myCash -= this.currBail;
        this.displayOutput();
    }

    private void priceDrugs(int n) {
        this.gameDrugs[0].price = 334 + this.getRandom(4500);
        this.gameDrugs[1].price = 16406 + this.getRandom(12000);
        this.gameDrugs[2].price = 4000 + this.getRandom(4000);
        this.gameDrugs[3].price = 2018 + this.getRandom(1400);
        this.gameDrugs[4].price = 2893 + this.getRandom(7500);
        this.gameDrugs[5].price = 215 + this.getRandom(2000);
        this.gameDrugs[6].price = 530 + this.getRandom(1300);
        this.gameDrugs[7].price = 81 + this.getRandom(2700);
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.getRandom(8);
            this.gameDrugs[n3].price = 0;
            ++n2;
        }
    }

    public void quitGame() {
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    private void repayMoney() {
        long l = this.myCash < this.myDebt ? this.myCash : this.myDebt;
        this.askQuantity("Bank", "You can pay back up to " + this.formatMoney(l) + ".", 11);
    }

    private void sellDrugs() {
        this.currDrug = this.cityOutput.getSelectedIndex();
        if (this.gameDrugs[this.currDrug].quantity == 0) {
            this.showMsg("Sorry", "You don't have any " + this.gameDrugs[this.currDrug].name + " to sell.", 6);
        } else if (this.gameDrugs[this.currDrug].price == 0) {
            this.showMsg("Sorry", "Nobody wants to buy " + this.gameDrugs[this.currDrug].name + ".", 6);
        } else {
            this.askQuantity(this.gameDrugs[this.currDrug].name, "You can sell up to " + this.gameDrugs[this.currDrug].quantity + " at " + this.formatMoney(this.gameDrugs[this.currDrug].price) + " each.", 24);
        }
    }

    private void shootCops() {
        if (this.getRandom(5 - this.myGuns) == 0) {
            --this.myCops;
            if (this.myCops == 0) {
                this.myCash += 200000L;
                this.showMsg("CIA", "You've killed all the agents! The Russian mafia give you a " + this.formatMoney(200000L) + " bounty.", 15);
            } else {
                this.showMsg("CIA", "You've killed an agent!", 19);
            }
        } else if (this.getRandom(this.myCops * 2) == 0) {
            if (this.getRandom(5) == 0) {
                this.showMsg("CIA", "The agents killed you!", 14);
            } else {
                this.showMsg("CIA", "You've been wounded and caught!", 17);
            }
        } else {
            this.showMsg("CIA", "Clips emptied but nobody got hit.", 19);
        }
    }

    private void showError(String string, String string2, int n) {
        this.currError = true;
        this.showMsg(string, string2, n);
    }

    private void showMsg(String string, String string2, int n) {
        this.currState = n;
        Form form = new Form(string);
        form.append(string2);
        form.addCommand(this.msgButton);
        form.setCommandListener((CommandListener)this);
        this.myDisplay.setCurrent((Displayable)form);
    }

    protected void startApp() throws MIDletStateChangeException {
        this.initSplash();
    }

    private void startGame() {
        this.currState = 1;
        this.currGame = true;
        int n = 0;
        while (n < 8) {
            this.gameDrugs[n].quantity = 0;
            ++n;
        }
        this.myCash = 2000L;
        this.myDebt = 5500L;
        this.myBank = 0L;
        this.myCoat = 100;
        this.myGuns = 0;
        this.myTotal = 0;
        this.myDaysLeft = 31;
        this.myCops = this.getRandom(2) + 1;
        this.myLoanToday = true;
        this.travelTo(0);
    }

    private void submitHighScore(long l, String string) {
        if (!this.scoreSub.checkUserID(string)) {
            this.showError("Sorry", "Your registration code is invalid.", 5);
        } else {
            this.scoreSub.setLastUserID(string);
            String string2 = this.scoreSub.submitScore(l, string);
            String string3 = this.scoreSub.submitFailed() ? "Sorry" : "Thanks";
            this.showMsg(string3, string2, 4);
        }
    }

    private void travelTo(int n) {
        this.myLocation = n;
        if (this.currState != 1) {
            this.myDebt += this.myDebt >> 3;
            this.myBank += this.myBank >> 4;
            --this.myDaysLeft;
            this.myLoanToday = false;
        }
        if (this.myDaysLeft == 0) {
            this.gameOver();
            return;
        }
        this.priceDrugs(2);
        this.currMsg = 0;
        this.drugEvents();
    }
}

