/****************************
* This class keeps track of *
* the players ship position *
* and paints his ship.      *
****************************/

//--------shipHandler.java----------\\

import java.awt.*;
import java.awt.event.*;

public class shipHandler extends SpaceM{
	
	Image image;
	
	private static int explodeFrame = 0;
	private static boolean exploding = false;
	private static boolean exploded = false;
	private static long timeLastExplosion = 0;
	
	private static int xPos;
	private static int yPos;
	private static int pixels = 7;
	private static int shipWidth = ship1.getWidth(null);
	private static int shipHeight = ship1.getHeight(null);
	static Rectangle shipR;
	boolean setShipXPos = true;
	
	static Bullet[] bullets;
	
	private static String rocketB = "rocket";
	private static String normalB = "normal";
	
	public shipHandler(){
		shipR = new Rectangle(xPos, yPos, shipWidth, shipHeight);
		bullets = new Bullet[5];
	}		
		
	public static void moveShipL(){
		if(!exploding){
			xPos -= pixels;
		}
	}
	
	public static void moveShipR(){	
		if(!exploding){
			xPos += pixels;
		}
	}
	
	private static int setShipXPos(){
		return (width - shipWidth) / 2;		
	}
	
	private static int setShipYPos(){
		return height - (shipHeight + 10);
	}
	
	public static int shipWidth(){
		return shipWidth;
	}
	
	public static int shipX(){
		return xPos;
	}
	
	public static int shipY(){
		return yPos;
	}
	
	public static Rectangle getRect(){
		return shipR;
	}
	
	public static void fireBullet(){
		for(int i = 0;  i < bullets.length; i++){
			if(bullets[i] == null){
				
				try{
				
				bullets[i] = new Bullet(xPos + (shipWidth/2), yPos - m1.getHeight(null), 
				                       m1.getWidth(null), m1.getHeight(null), 5, normalB, m3);
				
				bulletS.setMicrosecondPosition(0);
				bulletS.start();
				break;
				
				}catch(Exception e){e.printStackTrace();}
				
			}
		}		
	}
	
	public static void fireRocket(){
		for(int i = 0;  i < bullets.length; i++){
			if(bullets[i] == null){
				
				bullets[i] = new Bullet(xPos + (shipWidth/2), yPos - m1.getHeight(null), 
				                       m1.getWidth(null), m1.getHeight(null), 4, rocketB, m1);
				                       
				rocketS.setMicrosecondPosition(0);
				rocketS.start();
				break;
			}
		}		
	}
	
	public static Image getImage(){
		if(exploding){
			
			if((System.currentTimeMillis() - timeLastExplosion) > 40){
				timeLastExplosion = System.currentTimeMillis();
				++explodeFrame;
			}
			
			switch(explodeFrame){
				
				case 0: 
				    break;
				
				case 1:
					return e1;		
				
				case 2:
				    return e2;				   
				
				case 3: 
					return e3;					
				
				case 4: 
					return e4;					
				
				case 5:
				    return e5;
			    
			    case 6:
				    return e6;
				
				case 7:
				    return clearE;
				    
				case 8:
					explodeFrame = 0;
					exploding = false;
					exploded = true;
					MiscHandler.loseLife();
					return clearE;
			}						
		}				
		return ship1;
	}
	
	public static void explode(){
    	if(!exploding && !exploded){
	    	exploding = true;
	    	
	    	for(int i = 0;  i < bullets.length; i++){
				if(bullets[i] == null)continue;
				else bullets[i] = null;
			}
			
			for(int i = 0; i < LevelHandler.fighterN; i++){
				if(LevelHandler.eShips[i] == null)continue;
				else if(LevelHandler.eShips[i].bullet == null)continue;
				else LevelHandler.eShips[i].bullet = null;
			}
			
			if(!(LevelHandler.mothership == null)){
				for(int i = 0; i < LevelHandler.mothership.bullets.length; i++){
					LevelHandler.mothership.bullets[i] = null;
				}
			}
			
			explosionS.setMicrosecondPosition(0);
			explosionS.start();	    
	    }
    }
    
    public static boolean exploding(){
    	return exploding;
    }
    
    public static boolean exploded(){
    	return exploded;
    }
    
    public static void setShipDefaults(){
    	exploding = false;
    	exploded = false;
    	
    	xPos = setShipXPos();
    	
    	for(int i = 0; i < bullets.length; i++){
    		bullets[i] = null;
    	}
    }
    
    public void paintShip(Graphics g){
		
		shipR.setBounds(xPos, yPos, shipWidth, shipHeight);
		
		if(setShipXPos){
			xPos = setShipXPos();
			setShipXPos = false;
		}
		
		//set the yPos if it = 0
			
		if(yPos == 0){
			yPos = setShipYPos();
		}
		
		//make sure my ship is not off the screen:
		
		if(xPos <= 0){
			xPos = 0;
		}
		
		else if(xPos + shipWidth >= width){
			xPos = width - shipWidth;
		}
		
		//if my ship has just exploded pause the game for a 1/2 sec.
		
		if(exploded){
			
			try{
		   		Thread.currentThread().sleep(500);
		  	} catch (InterruptedException e){}
			
			xPos = setShipXPos();
			yPos = setShipYPos();
			
			exploded = false;			
		}
		
		image = getImage();
				
		g.drawImage(image, xPos, yPos, this);		
	}	
}