/****************************
* This class paints the     *
* enemyShips and moves them *
****************************/
import java.util.*;
import java.awt.*;

public class eShipHandler extends SpaceM{

	Random random;
	
	public eShipHandler(){
		random = new Random();
	}

	static private String[] directions = 
	{   
	    "left",
	    "right",
	    "down",
	    "leftdown",
	    "rightdown",
	};

	final private String left = "left";
	final private String right = "right";
	final private String down = "down";
	final private String leftdown = "leftdown";
	final private String rightdown = "rightdown";
	
	int randomDirection;
	
	Image ship;
	int x;
	int y;
	
	public void moveShips(){
		for(int i = 0; i < LevelHandler.fighterN; i++){
			if(LevelHandler.eShips[i] == null)continue;
			
			else if(LevelHandler.eShips[i].exploded()){				
				LevelHandler.eShips[i] = null;
				continue;				
			}
						
			else if(LevelHandler.eShips[i].newDirection() && !LevelHandler.eShips[i].exploding()){
				randomDirection = random.nextInt(directions.length - 1);
				
				//this line here prevents an arrayOutOfBoundsException		
				if(randomDirection >= directions.length)randomDirection = directions.length - 1;
				
				if(directions[randomDirection].equals(left)){
					LevelHandler.eShips[i].moveShipLeft();
				}
				
				else if(directions[randomDirection].equals(right)){
					LevelHandler.eShips[i].moveShipRight();
				}
				
				else if(directions[randomDirection].equals(down) && LevelHandler.eShips[i].CanGoDown()){
					LevelHandler.eShips[i].moveShipDown();
				}
				
				else if(directions[randomDirection].equals(leftdown) && LevelHandler.eShips[i].CanGoDown()){
					LevelHandler.eShips[i].moveShipLeftDown();
				}
				
				else if(directions[randomDirection].equals(rightdown) && LevelHandler.eShips[i].CanGoDown()){
					LevelHandler.eShips[i].moveShipRightDown();
				}
				
				else{
					if(i == 3){
						LevelHandler.eShips[i].moveShipRight();
					}
										
					if(i == 4){
						LevelHandler.eShips[i].moveShipLeft();
					}
					
					if(i == 5){
						LevelHandler.eShips[i].moveShipRight();
					}								
				}
			}			
		}
	
		updateShipRectangles();
	}
	
	public void paintShips(Graphics g){
		for(int i = 0; i < LevelHandler.fighterN; i++){
			if(LevelHandler.eShips[i] == null)continue;
			
			ship = LevelHandler.eShips[i].getShipImage();
			x = LevelHandler.eShips[i].getShipX();
			y = LevelHandler.eShips[i].getShipY();
			
			g.drawImage(ship, x, y, this);			
		}
	}
	
	public void updateShipRectangles(){
		for(int i = 0; i < LevelHandler.fighterN; i++){
			if(LevelHandler.eShips[i] == null)continue;
			
			LevelHandler.eShips[i].setShipRectangle();		
		}
	}
}
		