/*****************************************
* This class initializes ship positions, *
* moves the ships, and keeps track of    *
* their current position.                *
*****************************************/

import java.util.*;
import java.awt.*;

public class eShip extends SpaceM{
	
	//variables pertaining when and how to move
	private int timesMoved;
	private boolean canGoDown = true;
	
	private int explodeFrame = 0;
	private boolean exploding = false;
	private boolean exploded = false;
	private long timeLastExplosion = 0;
	
	private boolean r;  //right
	private boolean l;  //left
	private boolean d;  //down
	private boolean rd; //right & down
	private boolean ld; //left & down
	  
	//things pertaining to the ship:
		
	private int x;
	private int y;
	private int width;
	private int height;
	private int speed;
    private Image ship;
    
    private Rectangle shipR;
        
    //things pertaining to the firing of ship bullets
    eBullet bullet;
    	
	public eShip(int X, int Y, int Width, int Height, int Speed, Image Ship){
		x = X;
		y = Y;
		width = Width;
		height = Height;
		speed = Speed;
		
		ship = Ship;	
		
		shipR = new Rectangle(x, y, width, height);
		bullet = null;
	}
	
	public eShip(){
	}
	
	public void moveShipLeft(){
		setDirectionBooleansFalse();
		l = true;
		
		if(screenCollisionX()){
			moveShipRight();
			return;
		}
		
		x -= speed;
	}
			
	public void moveShipRight(){
		setDirectionBooleansFalse();
		r = true;
		
		if(screenCollisionX()){
			moveShipLeft();
			return;
		}
		
		x += speed;
	}
			
	public void moveShipDown(){
		setDirectionBooleansFalse();
		d = true;
		
		if(screenCollisionY()){
			moveShipLeft();
			return;
		}
		
		y += speed;
	}
		
	public void moveShipLeftDown(){
		setDirectionBooleansFalse();
		ld = true;
		
		if(screenCollisionX()){
			moveShipRightDown();
			return;
		}
		
		if(screenCollisionY()){
			moveShipRight();
			return;
		}		
				
		x -= speed;
		y += speed;			
	}
		
	public void moveShipRightDown(){
		setDirectionBooleansFalse();
		rd = true;
		
		if(screenCollisionX()){
			moveShipLeftDown();
			return;
		}
		
		if(screenCollisionY()){
			moveShipLeft();
			return;
		}
		
		x += speed;
		y += speed;			
	}
	
	public void moveShip(){
		
		if(!exploding){
			if(l)moveShipLeft();
			else if(r)moveShipRight();
			else if(d && canGoDown)moveShipDown();
			else if(ld && canGoDown)moveShipLeftDown();
			else if(rd && canGoDown)moveShipRightDown();
		}
	}	
	
	public boolean newDirection(){
		++timesMoved;
		
		if(timesMoved > 50){
			timesMoved=0;
			return true;			
		}
				
		else{
			moveShip();
			return false;
		}
	}
	
	public void setDirectionBooleansFalse(){
		l = false;
		r = false;
		d = false;
		ld = false;
		rd = false;
	}	
	 
	public Image getShipImage(){
		if(exploding){
			
			if((System.currentTimeMillis() - timeLastExplosion) > 40){
				timeLastExplosion = System.currentTimeMillis();
				++explodeFrame;
			}
			
			switch(explodeFrame){
				
				case 0: 
				    break;
				
				case 1:
					return e1;		
				
				case 2:
				    return e2;				   
				
				case 3: 
					return e3;					
				
				case 4: 
					return e4;					
				
				case 5:
				    return e5;
				    
				case 6:
					explodeFrame = 0;
					exploding = false;
					exploded = true;
					return e6;
			}						
		}				
		return ship;
	}
	
	public int getShipX(){
		return x;
	}
	
	public int getShipY(){
		return y;
	}
	
	public int getShipCenterX(){
		return x + (width/2);
	}
	
	public Rectangle getRect(){	
		return shipR;	
    }
    
    public void setShipRectangle(){
    	shipR.setBounds(x, y, width, height);
    }
    
    public void explode(){
    	if(!exploding && !exploded){
	    	exploding = true;
	    	explosionS.setMicrosecondPosition(0);
			explosionS.start();
	    }
    }
    
    public boolean exploding(){
    	return exploding;
    }
    
    public boolean exploded(){
    	return exploded;
    }

	private boolean screenCollisionY(){
		if(((y + height) >= (super.height / 2)) && (d || ld || rd)){  //this makes the ship NOT move if 
			y = (super.height / 2) - height;            			  //the current direction is down			
			canGoDown = false;
			return true;
		}
		
		return false;		
	}
	
	private boolean screenCollisionX(){
		if((x <= 3) && l){  //this makes the ship NOT move if 
			x = 3;          //the current direction is left, and the ship
			return true;	//is as far left as allowed.
		}
		
		
	  	else if(((x + width) >= super.width) && r){  //this makes the ship NOT move if 
			x = super.width - width;                 //the current direction is right			
			return true;							 //and the ship is as far right as allowed
		}
		
		else{
			return false;
		}
	}
	
	public boolean CanGoDown(){
		return canGoDown;		
	}
	
	public void fireBullet(){
		if(bullet == null){
			bullet = new eBullet(x, y, width, height);
			bulletS.setMicrosecondPosition(0);
			bulletS.start();			
		}	
	}
}