/************************************************
*This class constructs the bullets for the ship *
************************************************/

import java.awt.*;

public class eBullet extends SpaceM{
	private boolean lockedOnTarget = false;
	
	private double distance;
	private double ratioToDistance;
	private int xD; // x distance
	private int yD; // y distance
	private int shipW;
	private int shipX;
	private int shipY;
	
	private int x;
	private int y;
	private int width;
	private int height;
	
	private static int speed = 5;
	
	Rectangle bulletR;
	
	private int explodeFrame = 0;
	private boolean exploding = false;
	private boolean exploded = false;
	private long timeLastExplosion = 0;
	
	public eBullet(int X, int Y, int eShipWidth, int eShipHeight){
		width = m1.getWidth(null);
		height = m1.getHeight(null);
		
		x = X + ((eShipWidth - width) / 2);
		y = Y + eShipHeight +1;
		
		shipW = shipHandler.shipWidth();	
		bulletR = new Rectangle(x, y, width, height);	
	}
	
	public void moveBullet(){
		/*shipX = shipHandler.shipX();
		
		if(x < shipX + (shipW / 2)){
			x += speed;			
			y += speed;
		}
		
		else if(x > shipX + (shipW / 2)){
			x -= speed;
			y += speed;
		}
		
		else if(x == shipX + (shipW / 2)){
			y += speed;
		}*/
		
		if(!lockedOnTarget){
			shipX = shipHandler.shipX() + shipW/2;
			shipY = shipHandler.shipY();
			
			xD = shipX - x;
			yD = shipY - y;	
			distance = Math.sqrt((yD * yD) + (xD * xD));
			ratioToDistance = speed/distance;
			lockedOnTarget = true;			
		}
		
		//else{
			y += (int)(ratioToDistance * yD);
			x += (int)(ratioToDistance * xD);		
		//}
		
		setRect();
	}
	
	private void setRect(){
		bulletR.setBounds(x, y, width, height);
	}
	
	public int getX(){
		return x;
	}
	
	public int getY(){
		return y;
	}
	
	public int getHeight(){
		return height;
	}
	
	public Rectangle getRect(){
		return bulletR;
	}
	
	public Image getImage(){
		if(exploding){
			
			if((System.currentTimeMillis() - timeLastExplosion) > 10){
				timeLastExplosion = System.currentTimeMillis();
				++explodeFrame;
			}
			
			switch(explodeFrame){
				
				case 4:
					explodeFrame = 0;
					exploding = false;
					exploded = true;				
					return e1;
				
				default: 
					return e1;
			}
		}				
		return m2;
	}
	
	public void explode(){
    	if(!exploding && !exploded){
	    	exploding = true;
	    	explosionS.setMicrosecondPosition(0);
			explosionS.start();	    
	    }
    }
        
    public boolean exploding(){
    	return exploding;
    }
    
    public boolean exploded(){
    	return exploded;
    }
    
    public static void increaseBulletSpeed(){
    	++speed;
    }
}