import java.io.*;
import java.net.*;
import java.awt.*;
import java.util.*;
import javax.swing.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.sound.midi.*;
import javax.sound.sampled.*;

public class SpaceM extends Frame implements Runnable, MouseListener, MouseMotionListener, KeyListener{
	//class instances:
	static Credits credits;
	static shipHandler shipH;
	static eShipHandler eShipH;
	static BackgroundHandler bh;
	static LevelHandler lh;
	static eBulletHandler ebh;
	static BulletHandler bulletH;
	static MiscHandler miscH;
	static MotherShipHandler MShipH;
	
	static bgmusic sound;
	 
	static SpaceM s;
	static BufferStrategy strategy;
	static Graphics g;
	
	volatile static boolean playing = false;
	volatile static boolean cheatScreen = false;
	volatile static boolean instrScreen = false;
	volatile static boolean aboutScreen = false;
	volatile static boolean openScreen = true;
	volatile static boolean nameScreen = false;
	volatile static boolean dimesionsSet = false;
	volatile static boolean showCredits = false;
	volatile static boolean renderLoop = true;
	volatile static boolean scoreScreen = false;
	volatile static boolean pause = false;
		
	static boolean z;
	static boolean a;
	static boolean p;
	
	static int speed = 10;
		
	//variables for positioning of "buttons" and Image Label
	static int aboutImageY;
	static int aboutImageX;
		
	static int openX;
	static int openY;
	
	static int exitX;
	static int exitY;
	
	static int aboutX;
	static int aboutY;
	
	static int playX;
	static int playY;
	
	static int instrX;
	static int instrY;
	
	static int cheatX;
	static int cheatY;
	
	static int yPos;
	
	static int speedX;
	static int speedY;
	static int speedIndex = 0;
	
	static int height;
	static int width;
	
	//variables for sleep time
	static long beforeRender;
	static long afterRender;
	static long timeRenderTook;
	static long sleep;
	
	//variables to find out if a mouse is over a "button":
	static boolean overExit = false;
	static boolean overAbout = false;
	static boolean overPlay = false;
	static boolean overInstr = false;
	static boolean overCheat = false;
	
	//Variables for my ship.
	
	static volatile boolean left = false;
	static volatile boolean right = false;
	
	static boolean fireBullet = false;
	static boolean fireRocket = false;
	
	//misc
	
	Rectangle exitR, aboutR, playR, instrR, cheatR, speedR;	
	
	static int mouseX = 0;
	static int mouseY = 0;
	
	static int key;

	static Font font;
	Cursor nullCursor;
	Point paddleCursorPoint;
	
	//sound stuff.
	
	static Clip rocketS;
	static Clip bulletS;
	static Clip explosionS;
	
	static AudioInputStream rocketA;
    static DataLine.Info rocketI;
 
    static AudioInputStream bulletA;
    static DataLine.Info bulletI;
         
    static AudioInputStream explosionA;
    static DataLine.Info explosionI;
    
    char[] initials = new char[3];
    int initialN = 0;
    
	/********
	*Threads*
	********/
	
	static Thread painter;
	
	private static DisplayMode[] BEST_DISPLAY_MODES = new DisplayMode[] {
        
        new DisplayMode(1280, 1024, 32, DisplayMode.REFRESH_RATE_UNKNOWN),
        new DisplayMode(1280, 960, 32, DisplayMode.REFRESH_RATE_UNKNOWN),
        new DisplayMode(1280, 720, 32, DisplayMode.REFRESH_RATE_UNKNOWN),
        new DisplayMode(1152, 864, 32, DisplayMode.REFRESH_RATE_UNKNOWN),
        new DisplayMode(1024, 768, 32, DisplayMode.REFRESH_RATE_UNKNOWN),
        new DisplayMode(800, 600, 32, DisplayMode.REFRESH_RATE_UNKNOWN),
        new DisplayMode(640, 480, 32, DisplayMode.REFRESH_RATE_UNKNOWN),
        
        new DisplayMode(1280, 1024, 16, DisplayMode.REFRESH_RATE_UNKNOWN),
        new DisplayMode(1280, 960, 16, DisplayMode.REFRESH_RATE_UNKNOWN),
        new DisplayMode(1280, 720, 16, DisplayMode.REFRESH_RATE_UNKNOWN),
        new DisplayMode(1152, 864, 16, DisplayMode.REFRESH_RATE_UNKNOWN),
        new DisplayMode(1024, 768, 16, DisplayMode.REFRESH_RATE_UNKNOWN),
        new DisplayMode(800, 600, 16, DisplayMode.REFRESH_RATE_UNKNOWN),
        new DisplayMode(640, 480, 16, DisplayMode.REFRESH_RATE_UNKNOWN)        
    };
    
    //private static DisplayMode displaymode;
    //private static Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();    
    
    /************************
    *Image and URL Variables*
    ************************/
    
    URL[] URLS  = 
    {
    	this.getClass().getResource("/about1.gif"),
    	this.getClass().getResource("/about2.gif"),
    	this.getClass().getResource("/aboutImage.gif"),
    	this.getClass().getResource("/exit1.gif"),
    	this.getClass().getResource("/exit2.gif"),
    	this.getClass().getResource("/m1.gif"),
    	this.getClass().getResource("/m2.gif"),
    	this.getClass().getResource("/open.gif"),
    	this.getClass().getResource("/ship.gif"),
    	this.getClass().getResource("/ship2.gif"),
    	this.getClass().getResource("/background.jpg"),
    	this.getClass().getResource("/instr1.gif"),
    	this.getClass().getResource("/instr2.gif"),
    	this.getClass().getResource("/play1.gif"),
    	this.getClass().getResource("/play2.gif"),
    	this.getClass().getResource("/cheat1.gif"),
    	this.getClass().getResource("/cheat2.gif"),
    	this.getClass().getResource("/nullPointer.gif"),
    	this.getClass().getResource("/m3.gif"),
    	this.getClass().getResource("/e1.gif"),
    	this.getClass().getResource("/e2.gif"),
    	this.getClass().getResource("/e3.gif"),
    	this.getClass().getResource("/e4.gif"),
    	this.getClass().getResource("/e5.gif"),
    	this.getClass().getResource("/e6.gif"),
    	this.getClass().getResource("/clearExplosion.gif"),
    	this.getClass().getResource("/missle.wav"),
    	this.getClass().getResource("/gun.wav"),
    	this.getClass().getResource("/explosion.wav"),
    	this.getClass().getResource("/n0.gif"),
    	this.getClass().getResource("/n1.gif"),
    	this.getClass().getResource("/n2.gif"),
    	this.getClass().getResource("/n3.gif"),
    	this.getClass().getResource("/n4.gif"),
    	this.getClass().getResource("/n5.gif"),
    	this.getClass().getResource("/n6.gif"),
    	this.getClass().getResource("/n7.gif"),
    	this.getClass().getResource("/n8.gif"),
    	this.getClass().getResource("/n9.gif"),
    	this.getClass().getResource("/eMothership1.gif"),
    	this.getClass().getResource("/eMothership2.gif"),
    	this.getClass().getResource("/eMothership3.gif"),
    	this.getClass().getResource("/eMothership4.gif"),
    	this.getClass().getResource("/eMothership5.gif"),
    	this.getClass().getResource("/eMothership6.gif"),
    	this.getClass().getResource("/eMothership7.gif"),
    	this.getClass().getResource("/eMothership8.gif"),
    	this.getClass().getResource("/eMothership9.gif"),
    	this.getClass().getResource("/eMothership10.gif"),
    	this.getClass().getResource("/eMothership11.gif"),
    	this.getClass().getResource("/mothership.gif"),
    	this.getClass().getResource("/speed1.jpg"),
    	this.getClass().getResource("/speed2.jpg"),
    	this.getClass().getResource("/speed3.jpg")
    };
      
    static Image about1, about2, aboutImage, exit1, exit2, m1, m2, open, ship1, ship2, background, 
                 instr1, instr2, play1, play2, cheat1, cheat2, nullPointer, m3, e1, e2, e3, e4, e5, e6,
                 mothershipI, clearE;
                 
    static Image[] numbers;
    
    static Image[] eMothership;
    static Image[] speedI;
	
	//Sound
			
	public void startThreads(){
		if(painter == null)painter = new Thread(this, "painter");
		painter.setPriority(7);
		painter.start();
	}
		
	public void run(){
		
		while(renderLoop){
			
			try{
				
				beforeRender = System.currentTimeMillis();
				render();
				afterRender = System.currentTimeMillis();
				timeRenderTook = afterRender - beforeRender;
				sleep = speed - timeRenderTook;
				Thread.currentThread().sleep(sleep);
				
			} catch (Exception exc){}
		}
	}
	
	/***********
	*Contructor*
	***********/
	
	public SpaceM(GraphicsConfiguration gc){
		super(gc);
		
		MediaTracker tracker = new MediaTracker(this); 
		
		try{
			
		for(int i = 0; i < URLS.length; i++){
			if(URLS[i] == null){
				System.out.println(i + "null");
				throw new IOException();
			}
		}
		
		} catch(IOException e){ e.printStackTrace();}
				
		about1 = getToolkit().createImage(URLS[0]);
		about2 = getToolkit().createImage(URLS[1]);
		aboutImage = getToolkit().createImage(URLS[2]);
		exit1 = getToolkit().createImage(URLS[3]);
		exit2 = getToolkit().createImage(URLS[4]);
		m1 = getToolkit().createImage(URLS[5]);
		m2 = getToolkit().createImage(URLS[6]);
		open = getToolkit().createImage(URLS[7]);
		ship1 = getToolkit().createImage(URLS[8]);
		ship2 = getToolkit().createImage(URLS[9]);
		background = getToolkit().createImage(URLS[10]);
		instr1 = getToolkit().createImage(URLS[11]);
		instr2 = getToolkit().createImage(URLS[12]);
		play1 = getToolkit().createImage(URLS[13]);
		play2 = getToolkit().createImage(URLS[14]);
		cheat1 = getToolkit().createImage(URLS[15]);
		cheat2 = getToolkit().createImage(URLS[16]);
		nullPointer = getToolkit().createImage(URLS[17]);
		m3 = getToolkit().createImage(URLS[18]);
		e1 = getToolkit().createImage(URLS[19]);
		e2 = getToolkit().createImage(URLS[20]);
		e3 = getToolkit().createImage(URLS[21]);
		e4 = getToolkit().createImage(URLS[22]);
		e5 = getToolkit().createImage(URLS[23]);
		e6 = getToolkit().createImage(URLS[24]);	
		clearE = getToolkit().createImage(URLS[25]);
				
		numbers = new Image[10];
		eMothership = new Image[11];
		speedI = new Image[3];
		
		for(int i = 0, u = 29; i < numbers.length; i++, u++){
			numbers[i] = getToolkit().createImage(URLS[u]);
			tracker.addImage(numbers[i], 0);
		}
		
		for(int i = 0, u = 39; i < eMothership.length; i++, u++){
			eMothership[i] = getToolkit().createImage(URLS[u]);
			tracker.addImage(eMothership[i], 0);
		}
		
		for(int i = 0, u = 51; i < speedI.length; i++, u++){
			speedI[i] = getToolkit().createImage(URLS[u]);
			tracker.addImage(speedI[i], 0);
		}
		
		mothershipI = getToolkit().createImage(URLS[50]);
		
		tracker.addImage(about1,0); 
		tracker.addImage(about2,0);
		tracker.addImage(aboutImage,0);
		tracker.addImage(exit1,0);
		tracker.addImage(exit2,0);
		tracker.addImage(m1,0);
		tracker.addImage(m2,0); 
		tracker.addImage(open,0);
		tracker.addImage(ship1,0);
		tracker.addImage(ship2,0);
		tracker.addImage(background,0);
		tracker.addImage(instr1,0);
		tracker.addImage(instr2,0);
		tracker.addImage(play1,0);
		tracker.addImage(play2,0);
		tracker.addImage(cheat1,0);
		tracker.addImage(cheat2,0);
		tracker.addImage(nullPointer,0);
		tracker.addImage(m3,0);
		tracker.addImage(clearE,0);
		tracker.addImage(mothershipI,0);
				
		try{
			tracker.waitForID(0);
		} catch (InterruptedException e){} 
	
	
		//sounds
		
		try
        {
            rocketA = AudioSystem.getAudioInputStream(URLS[26]);
            rocketI = new DataLine.Info(Clip.class, rocketA.getFormat());
            rocketS = (Clip)AudioSystem.getLine(rocketI);
            rocketS.open(rocketA);
            
            bulletA = AudioSystem.getAudioInputStream(URLS[27]);
            bulletI = new DataLine.Info(Clip.class, bulletA.getFormat());
            bulletS = (Clip)AudioSystem.getLine(bulletI);
            bulletS.open(bulletA);
            
            explosionA = AudioSystem.getAudioInputStream(URLS[28]);
            explosionI = new DataLine.Info(Clip.class, explosionA.getFormat());
            explosionS = (Clip)AudioSystem.getLine(explosionI);
            explosionS.open(explosionA);
        }
        catch(UnsupportedAudioFileException e){}
        catch(LineUnavailableException e){}
        catch(IOException e){}
		
		font = new Font("Times_New_Roman", Font.BOLD, 20);
		
		shipH = new shipHandler();
		eShipH = new eShipHandler();
		credits = new Credits();
		sound = new bgmusic();
		bh = new BackgroundHandler();
		lh = new LevelHandler();
		ebh = new eBulletHandler();
		bulletH = new BulletHandler();
		miscH = new MiscHandler(); //this is just to init variables.
		MShipH = new MotherShipHandler();
		
		addMouseListener(this);
		addMouseMotionListener(this);
		addKeyListener(this);		
	
		//nullCursor:
		paddleCursorPoint = new Point(0, 0);
		nullCursor = Toolkit.getDefaultToolkit().createCustomCursor(nullPointer, paddleCursorPoint, "nullCursor");
	}
	
	public SpaceM(){	
	}

	/**************
	*Mouse Methods*
	**************/

	public void mouseMoved(MouseEvent e){
		mouseX = e.getX();
		mouseY = e.getY();
		
		if(!dimesionsSet && !(width == 0) && !(height == 0)){
			getDimensionsAndSetButtonPositions();
			dimesionsSet = true;
		}
		
		if(!playing && !showCredits && !(width == 0) && !(height == 0))areThereRollovers();
	}
	
	public void mouseReleased(MouseEvent e){
		if(!dimesionsSet && !(width == 0) && !(height == 0)){
			getDimensionsAndSetButtonPositions();
			dimesionsSet = true;
		}
		
		if(!playing && !showCredits && !(width == 0) && !(height == 0))decideWhichScreenToShow();	
	}
	
	public void mouseEntered(MouseEvent e){}
	public void mouseExited(MouseEvent e){}
	public void mousePressed(MouseEvent e){
		if(showCredits && yPos < height - 5){
			s.dispose();
			System.exit(0);	
		}
	}
	public void mouseDragged(MouseEvent e){}
	
	public void mouseClicked(MouseEvent e){}

    /*****************
    *Keyboard Methods*
    *****************/
    
    public void keyPressed(KeyEvent k){
		if(playing){
	    	
	    	key = k.getKeyCode();
    		
    		if(key == KeyEvent.VK_LEFT){
    			left = true;
    		}
   	 	
    		else if(key == KeyEvent.VK_RIGHT){
    			right = true;
    		}    		
    		
    		else if(key == KeyEvent.VK_ESCAPE){
    			s.dispose();
				System.exit(0); 	
    		}
    		
    		if(key == KeyEvent.VK_SPACE){
    			fireBullet = true;    		
    		}
    	
    		else if(key == KeyEvent.VK_ENTER){
    			fireRocket = true;
    		}
    		
    		else if(key == KeyEvent.VK_PAUSE){
    			if(pause)pause = false;
    			else pause = true;
    		}
    	}    		   	
    }
    
    public void keyTyped(KeyEvent k){
    	if(nameScreen && !playing){
    		
    		initials[initialN] = k.getKeyChar();
    		++initialN;
    		
    		if(initialN >  2){
    			setAllScreenBooleansToFalse();
    			scoreScreen = true;
    			initialN = 0;
    			
    			MiscHandler.writeScoresAndNames(initials[0], initials[1], initials[2], MiscHandler.getPoints());
    			
    			for(int i = 0; i < initials.length; i++)initials[i] = '\u0000';
				initials[0] = '\u0000';
				//LevelHandler.newGame();
    		}    		
    	}
    	
    	else if(playing && (k.getKeyChar() == 'q')){
    		setAllScreenBooleansToFalse();
    		playing = false;
    		scoreScreen = true;
    		LevelHandler.newGame();
    	}
    	
    	if(playing){
    		
	   		if(k.getKeyChar() == 'z'){
   				z = true;
   				a = false;
   				p = false;  				
   	 		}
    		
	   		else if(z && !a && !(k.getKeyChar() == 'a')){
   	 			z = false;   		 			   		 			
    		}    	
    	
	   		else if(z && !a && (k.getKeyChar() == 'a')){ 
	   			a = true;
	   		}
	   		
	   		else if(z && a && !p && !(k.getKeyChar() == 'p')){
    			z = false;
    			a = false;
    			p = false;
    		}
    		
    		else if(z && a && !p && (k.getKeyChar() == 'p')){
    			p = true;
   				MiscHandler.zapLives();
    		}       		
   		}
   	} 
   
    public void keyReleased(KeyEvent k){
    	if(playing){
	    	key = k.getKeyCode();
	    	if(key == KeyEvent.VK_LEFT){
    			left = false;
    		}
   	 	
    		else if(key == KeyEvent.VK_RIGHT){
    			right = false;
    		}
	    }
    }
    
    /******************
    *The RENDER Method*
    ******************/
    
    private void render(){    	
    	g = strategy.getDrawGraphics();
   		
	   	if (!strategy.contentsLost()) {
   			try{
   				
   				if(pause){
   					g.setFont(font);
   					g.setColor(Color.black);
   					g.fillRect(0, 0, width, height);
   					g.setColor(Color.green);
   					
   					g.drawString("Game Paused", 50, height/2);
   				}
   				
   				//RENDERING DONE WHEN GAME IS PLAYING   			
	   			else if(playing){

	    			if(LevelHandler.NewLevel){
	    					    				
	    				lh.initShips();
    					LevelHandler.NewLevel = false;
    				
    					bh.paintBackground(g);
   		   				shipH.paintShip(g);
    				
	    				lh.paintWaveNumber(g);
	    				
	    				strategy.show();
    					
	    				try{
		    				Thread.currentThread().sleep(1000);
	    				} catch (InterruptedException e){}
	    			}
	    			
	    			else if(LevelHandler.gameComplete()){
	    				lh.paintWaveNumber(g);
	    				
	    				g.dispose();
	    				strategy.show();
	    				g = strategy.getDrawGraphics();
	    					    				
	    				try{
		    				Thread.currentThread().sleep(5000);
	    				} catch (InterruptedException e){}
	    				
	    				if(MiscHandler.highscore()){
	    					setAllScreenBooleansToFalse();
	    					nameScreen = true;	    					
	    				}
	    				
	    				else{
	    					setAllScreenBooleansToFalse();
	    					scoreScreen = true;
	    					//LevelHandler.newGame();
	    				}
	    				
	    				return;	    					
	    			}
    			
	    			//move my ship if a key is pressed:
    			
	    			if(left){
    					shipHandler.moveShipL();
	    			}
    			
    				if(right){
    					shipHandler.moveShipR();
    				}
    			
    				//fire a bullet if the "Enter" or "Space" key was pressed:
    			
	    			if(fireBullet){    				
	    				shipHandler.fireBullet();
	    				fireBullet = false;
   		 			}
    			
    				if(fireRocket){
    					shipHandler.fireRocket();
   		 				fireRocket = false;
    				}
    					
    			
	    			//paint stuff    			
    			
    				bh.paintBackground(g);
   			   		shipH.paintShip(g);
   		   			eShipH.paintShips(g);
   		   			miscH.paintScore(g);
   			   		MShipH.paintShip(g);
	   			   	bulletH.paintBullets(g);
	   			   	ebh.paintAndFireBullets(g);
	   		   		//move enemy ships, move bullets, etc.
   	 			
    				eShipH.moveShips();
    				ebh.moveBullet();
    				bulletH.moveBullets();
    				MShipH.moveShip();
	    			//look for collsions
    				
    				CollisionHandler.DetectCollision();   		   	
   		   		}
   		
	   			//stuff when game is not playing
   			  			
	   			else if(showCredits){
   					credits.drawCredits(g, yPos, height, width);
   					
   					boolean disposeAndExit = credits.areCreditsDone();
   			
	   				if(disposeAndExit){
   						s.dispose();
   						System.exit(0);
   					}
   				
	   				--yPos;
   				}
   				
   				else if(aboutScreen || instrScreen || cheatScreen || openScreen || nameScreen || scoreScreen){
	   				drawBackground(g);   			
    				drawButtonsAndScreen(g);
    				setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
   				}
   			
   			} catch(Exception e){e.printStackTrace(); System.out.println("Exception");}
   			 
   			  finally{
   			 	g.dispose();
    			strategy.show();
    		  }
   		}
  	}

    
    /****************************************
    *Methods called when game is not playing*
    *****************************************/
    
    private void drawBackground(Graphics g){
    	g.setColor(Color.black);
    	g.fillRect(0, 0, width, height);
    }
    
    private void drawButtonsAndScreen(Graphics g){
    	    	
    	if(overExit)g.drawImage(exit2, exitX, exitY, this);
    	else g.drawImage(exit1, exitX, exitY, this);
    	
    	if(overAbout)g.drawImage(about2, aboutX, aboutY, this);
    	else g.drawImage(about1, aboutX, aboutY, this);
    	
    	if(overPlay)g.drawImage(play2, playX, playY, this);
    	else g.drawImage(play1, playX, playY, this);
    	
    	if(overCheat)g.drawImage(cheat2, cheatX, cheatY, this);
    	else g.drawImage(cheat1, cheatX, cheatY, this);
    	
    	if(overInstr)g.drawImage(instr2, instrX, instrY, this);
    	else g.drawImage(instr1, instrX, instrY, this);
    	
    	g.drawImage(speedI[speedIndex], speedX, speedY, this);
 
 		//draw the screen:
 		
    	if(openScreen){
 		   	g.drawImage(open, openX, openY, this);
 		}
 		
 		else if(cheatScreen){
 			g.setFont(font);
 			g.setColor(Color.red);
 			g.drawString("zap", instr1.getWidth(null) + 10, 40);
 			g.setColor(Color.orange);
 			g.drawString("Type in this cheat at any time of the game and press \"Enter.\"", instr1.getWidth(null) + 10, 150);
 			
 		}
 		
 		else if(instrScreen){
 			g.setFont(font);
 			g.setColor(Color.red);
 			g.drawString("Press the arrow keys to move and the ship.", instr1.getWidth(null) + 10, 40);
 			g.setColor(Color.cyan);
 			g.drawString("Press the \"space bar\" to fire cannon.", instr1.getWidth(null) + 10, 80);
 			g.setColor(Color.yellow);
 			g.drawString("Press the \"Enter\" key to fire missles.", instr1.getWidth(null) + 10, 120); 		
 			g.setColor(Color.green);
 			g.drawString("Press \"q\" to quit a game in progress", instr1.getWidth(null) + 10, 160);
 			g.setColor(Color.orange);
 			g.drawString("Press \"the pause/break key\" to pause a game in progress", instr1.getWidth(null) + 10, 200); 
 			g.setColor(Color.blue);
 			g.drawString("The speed button is for those of you who have super computers,", instr1.getWidth(null) + 10, 240); 
 			g.drawString("if the game is to fast slow it down, I keep it on fast though.", instr1.getWidth(null) + 10, 280); 
 			g.drawString("NOTE: Guided missles are no longer guided past level 7!", instr1.getWidth(null) + 10, 320);		
 		}
 		
 		
 		else if(aboutScreen){
 			g.drawImage(aboutImage, aboutImageX, aboutImageY, this);
 		}
 		
 		else if(nameScreen){
 			
 			g.setColor(Color.green);
 			g.setFont(font);
 			
 			g.drawString("High Score: Please enter your three initials:", instr1.getWidth(null) + 10, 40);
 			int x = instr1.getWidth(null) + 10;
 			
 			for(int i = 0; i < initials.length; i++){
 				
 				if(initials[i] == '\u0000')continue;
 				
 				g.drawString(Character.toString(initials[i]), x, 60);
 				
 				x += 15;
 			}
 		} 
 		
 		else if(scoreScreen){
 			MiscHandler.drawScoreScreen(g, instr1.getWidth(null) + 10);
 		}    
    }
   
  	private void getDimensionsAndSetButtonPositions(){
  		yPos = height;
  		
  		//Position aboutImage:
  		aboutImageX = (width - aboutImage.getWidth(null)) / 2; 
  		aboutImageY = (height - aboutImage.getHeight(null)) / 2; 
  		
  		//Position open.  		
  		openX = (width - open.getWidth(null)) / 2;
  		openY = (height - open.getHeight(null)) / 2;
		
		//Positon exit and set exit's Rectangle;
		exitY = 0;
		exitX = 0;
		exitR = new Rectangle(exitX, exitY, exit1.getWidth(null), exit1.getHeight(null));
		
		//Positon about and set about's Rectangle;
		aboutY = exitR.height + 40;
		aboutX = 0;
		aboutR = new Rectangle(aboutX, aboutY, about1.getWidth(null), about1.getHeight(null));
		
		//Positon play and set play's Rectangle;
		playY = exitR.height + aboutR.height + 80;
		playX = 0;
		playR = new Rectangle(playX, playY, play1.getWidth(null), play1.getHeight(null));
		
		//Positon cheat and set cheat's Rectangle;
		cheatY = exitR.height + aboutR.height + playR.height + 120;
		cheatX = 0;
		cheatR = new Rectangle(cheatX, cheatY, cheat1.getWidth(null), cheat1.getHeight(null));
		
		//Positon instr and set instr's Rectangle;
		instrY = exitR.height + aboutR.height + playR.height + cheatR.height + 160;
		instrX = 0;
		instrR = new Rectangle(instrX, instrY, instr1.getWidth(null), instr1.getHeight(null));
		
		//position speed
		
		speedY = instrY + 100;
		speedX = 0;
		
		speedR = new Rectangle(speedX, speedY, speedI[0].getWidth(null), speedI[0].getHeight(null));	
  	}
  	
  	private void areThereRollovers(){
  		Rectangle mouseR = new Rectangle(mouseX, mouseY, 10, 10);
  		
  		setOverVariablesFalse();
  		
  		if(mouseR.intersects(exitR))overExit = true;
  		if(mouseR.intersects(aboutR))overAbout = true;
  		if(mouseR.intersects(playR))overPlay = true;
  		if(mouseR.intersects(cheatR))overCheat = true;
  		if(mouseR.intersects(instrR))overInstr = true; 		
  	}
  	
  	private void setOverVariablesFalse(){
  		overExit = false;
  		overAbout = false;
  		overPlay = false;
  		overCheat = false;
  		overInstr = false;
  	}
  	
  	private void setAllScreenBooleansToFalse(){
  		showCredits = false;
  		openScreen = false;
  		aboutScreen = false;
  		cheatScreen = false;
  		instrScreen = false;
  		nameScreen = false;
  		scoreScreen = false;
  		playing = false;
  	}
  	
  	private void decideWhichScreenToShow(){
  		Rectangle mouseR = new Rectangle(mouseX, mouseY, 10, 10);
  		
  		if(mouseR.intersects(speedR)){
  			++speedIndex;
  			
  			if(speedIndex > 2){
  				speedIndex = 0;
  			}		
  			
  			switch(speedIndex){
  				
  				case 0: speed = 10;
  				        break;
  			    case 1: speed = 20; 
  			            break;
  			    case 2: speed = 40;
  			            break;
  			}			
  			  			
  			return;
  		}
  		
  		setAllScreenBooleansToFalse();
  		 		
    	if(mouseR.intersects(aboutR))aboutScreen = true;
  		if(mouseR.intersects(exitR))showCredits = true;
  		if(mouseR.intersects(playR)){
  			playing = true;
  		    setCursor(nullCursor);
  		    LevelHandler.newGame(); 	  		    	    
  		}
  		
  		if(mouseR.intersects(cheatR))cheatScreen = true;
  		if(mouseR.intersects(instrR))instrScreen = true;  			
  	}  	
  	  		
	/*****
	*Main*
	*****/

	public static void main(String arg[]){
		GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
		GraphicsConfiguration gc = device.getDefaultConfiguration();
		
		s = new SpaceM(gc);		
		s.setUndecorated(true);
		s.setResizable(false);
		s.setIgnoreRepaint(true);
		device.setFullScreenWindow(s);
		s.setVisible(true);
		
		if (device.isDisplayChangeSupported())  {   
        	chooseBestDisplayMode(device);        	
        }
        
        else if(!device.isDisplayChangeSupported()){
          	device.setFullScreenWindow(null);
            s.setVisible(false);        	
        	
        	JOptionPane.showMessageDialog((Component) null, "I am sorry, but Fullscreen mode is not supported.\n\nThis program will exit.", "Fullscreen Not Supported", JOptionPane.ERROR_MESSAGE);
			System.exit(0);        
        }
        
        s.createBufferStrategy(2); 
        strategy = s.getBufferStrategy();
        
        if(!strategy.getCapabilities().isPageFlipping()){
        	device.setFullScreenWindow(null);
            s.setVisible(false);        	
        	
        	JOptionPane.showMessageDialog((Component) null, "I am sorry, but Hardware Acceleration of the game is not available.\n\nThis program will exit.", "No Hardware Acceleration.", JOptionPane.ERROR_MESSAGE);
			System.exit(0);
		}
		
		sound.startThread();
        s.startThreads();        
    }

	/*****************
	*FullScreen Stuff*
	*****************/
	
	public static void chooseBestDisplayMode(GraphicsDevice device) {
        DisplayMode best = getBestDisplayMode(device);
        if (best != null) { 
        	width = best.getWidth();
        	height = best.getHeight();
        	         	
            device.setDisplayMode(best);
        }
    }
    
    private static DisplayMode getBestDisplayMode(GraphicsDevice device) {
        for (int x = 0; x < BEST_DISPLAY_MODES.length; x++) {
            DisplayMode[] modes = device.getDisplayModes();
            for (int i = 0; i < modes.length; i++) {
                if (modes[i].getWidth() == BEST_DISPLAY_MODES[x].getWidth()
                   && modes[i].getHeight() == BEST_DISPLAY_MODES[x].getHeight()
                   && modes[i].getBitDepth() == BEST_DISPLAY_MODES[x].getBitDepth()
                   ) {
                   	
                   	return BEST_DISPLAY_MODES[x];
                }
            }
        }
        return null;
        
        //displaymode = new DisplayMode(screen.width, screen.height, 32, DisplayMode.REFRESH_RATE_UNKNOWN);
		//return displaymode; 
    }
}