/***************************************************
*This class handles mothership bullets and movement*
***************************************************/


import java.awt.*;

public class MotherShipHandler extends SpaceM{

	Image ship, bullet;
	int x, x2;
	int y, y2;
	
	public void moveShip(){
		if(LevelHandler.mothership == null)return;
		else if(LevelHandler.mothership.exploded()){				
			LevelHandler.mothership = null;
			LevelHandler.gameCompleted();
			return;		
		}
		
		LevelHandler.mothership.moveShip();
		updateShipRectangle();
		
		moveBullet();
	}
	
	public void paintShip(Graphics g){
		if(LevelHandler.mothership == null)return;
		ship = LevelHandler.mothership.getShipImage();
		x = LevelHandler.mothership.getShipX();
		y = LevelHandler.mothership.getShipY();
		
		g.drawImage(ship, x, y, this);
		
		paintAndFireBullets(g);		
	}
	
	public void updateShipRectangle(){
		if(LevelHandler.mothership == null)return;
		LevelHandler.mothership.setShipRectangle();		
	}
	
	public void paintAndFireBullets(Graphics g){
		if(!(LevelHandler.mothership == null)){
			for(int i=0; i < LevelHandler.mothership.bullets.length; i++){
				if(!(LevelHandler.mothership.bullets[i] == null)){				    
					
					if(LevelHandler.mothership.bullets[i].exploded()){
						LevelHandler.mothership.bullets[i] = null;
						System.out.println("called");
						continue;
					}				
		   	
				   	x2 = LevelHandler.mothership.bullets[i].getX();
				   	y2 = LevelHandler.mothership.bullets[i].getY();
				   	bullet = LevelHandler.mothership.bullets[i].getImage();
			   	
				   	if(bullet == e1){
						x2 = x2 - (e1.getWidth(null) / 2) + 3;
						y2 = y2 - (e1.getWidth(null) / 2) + 3;
					}
				
					g.drawImage(bullet, x2, y2, this);
				}
				
				else{
					newBullet();
				}		   	
			}			
		}
	}
	
	private void newBullet(){
		if(!(LevelHandler.mothership == null)){
			LevelHandler.mothership.fireBullet();
		}	
	}
	
	public void moveBullet(){
		
		if(!(LevelHandler.mothership == null)){
			for(int i=0; i < LevelHandler.mothership.bullets.length; i++){
				if(!(LevelHandler.mothership.bullets[i] == null)
				    && !LevelHandler.mothership.bullets[i].exploding()){
					
					if(LevelHandler.mothership.bullets[i].exploded()){
							LevelHandler.mothership.bullets[i] = null;
						continue;
					}
				
						LevelHandler.mothership.bullets[i].moveBullet(); 	
				
					if((LevelHandler.mothership.bullets[i].getY()) > super.height){
						LevelHandler.mothership.bullets[i] = null;
					}
				}
			}		
		}
	}
}
