/****************************
* This class tracks scores, *
* lives, etc.               *
****************************/
import java.util.*;
import java.awt.*;
import java.io.*;

public class MiscHandler extends SpaceM{
	
	private static int lives = 3;
	private static String[] names = new String[10];
	
	private static boolean highscore = false;
	
	private static BufferedWriter writeScores;
	private static BufferedReader readScores;
	
	private static File scoreFile;
	private static File nameFile;
	
	private static int y = 0;
	private static int y2 = 20;
	
	private static int x1, x2, x3, x4, x5, x6, x7, x8, x9, x10;
	private static int width;
	private static int height;
	
	//scoring integers
	
	private static int points = 0;
	private static int[] highscores = new int[10];
	
	private static int d1 = 0;   //digit ones
	private static int d10 = 0;  //digit 10s etc.
	private static int d100 = 0;
	private static int d1000 = 0;
	private static int d10000 = 0;
	private static int d100000 = 0;
	private static int d1000000 = 0;
	private static int d10000000 = 0;
	private static int d100000000 = 0;
	private static int d1000000000 = 0;  //digit billions
	
	public MiscHandler(){
		nameFile = new File("names.txt");
		scoreFile = new File("highscores.txt");
		highscores = new int[10];
		
		width = 18;
		x1 = 0;
		x2 = x1 + width;
		x3 = x2 + width;
		x4 = x3 + width;
		x5 = x4 + width;
		x6 = x5 + width;
		x7 = x6 + width;
		x8 = x7 + width;
		x9 = x8 + width;
		x10 = x9 + width;	
		
		height = ship1.getHeight(null);
		
		readFiles();	
	}
		
	public static void readFiles(){
		
		try{
		
			if(scoreFile.exists()){
				BufferedReader readScores = new BufferedReader(new FileReader(scoreFile));
				BufferedReader readNames = new BufferedReader(new FileReader(nameFile));				
							
				for(int i = 0; i < highscores.length; i++){
					
					highscores[i] = Integer.parseInt(readScores.readLine());
					names[i] = readNames.readLine();
				}
				
				readScores.close();
				readNames.close();
			}
			
			else {
				writeFiles();
			}
			
		} catch(IOException e){e.printStackTrace();}
	}
		
	public static void writeFiles(){
			
		try{
							
			BufferedWriter writeScores = new BufferedWriter(new FileWriter(scoreFile));
			BufferedWriter writeNames = new BufferedWriter(new FileWriter(nameFile));
									
			for(int i = 0; i < highscores.length; i++){
				writeScores.write("1");
				writeScores.newLine();
				writeNames.write("default");
				writeNames.newLine();
				writeScores.flush();
				writeNames.flush();
			}
			
			writeNames.close();
			writeScores.close();		
		} catch(IOException e){e.printStackTrace();}
		
		readFiles();			
	}	
	
	public static void awardShipDestroyedPoints(){
		points += 2;
		d1 += 2;
		
		updateScores();
		
		if(points == 100 || points == 101 || points == 500 || points == 501) getLife();
	}
	
	public static void awardMotherShipDestroyedPoints(){
		points += 1000;
		++d1000;
		
		updateScores();
	}
	
	public static void awardBulletDestroyedPoints(){
		points ++;
		d1 ++;
		
		updateScores();
		
		if(points == 100 || points == 101 || points == 500 || points == 501) getLife();
	}
	
	private static void updateScores(){
		if(d1 >= 10){
			d10 ++;
			d1 -= 10;
		}
		
		if(d10 >= 10){
			d100 ++;
			d10 -= 10;
		}
		
		if(d100 >= 10){
			d1000 ++;
			d100 -= 10;
		}
		
		if(d1000 >= 10){
			d10000 ++;
			d1000 -= 10;
		}
		
		if(d10000 >= 10){
			d100000 ++;
			d10000 -= 10;
		}
		
		if(d100000 >= 10){
			d1000000 ++;
			d100000 -= 10;
		}
		
		if(d1000000 >= 10){
			d10000000 ++;
			d1000000 -= 10;
		}
		
		if(d10000000 >= 10){
			d100000000 ++;
			d10000000 -= 10;
		    if(d10000000 <= 9) d10000000 = 0;
		}
		
		if(d100000000 >= 10){
			d1000000000 ++;
			d100000000 -= 10;
		}
		
		if(d1000000000 >= 10){
			points = 0;
			d1 = 0;   //digit ones
			d10 = 0;  //digit 10s etc.
			d100 = 0;
			d1000 = 0;
			d10000 = 0;
			d100000 = 0;
			d1000000 = 0;
			d10000000 = 0;
			d100000000 = 0;
			d1000000000 = 0;	
		}
	}
	
	public static void getLife(){
		++lives;
	}
	
	public static void zapLives(){
		lives = 0;
	}
	
	public static void loseLife(){
		--lives;
		
		if(lives < 0){
									    
		    if(highscore()){
				nameScreen = true;
			}
			
			else{
				playing = false;
				scoreScreen = true;
				LevelHandler.newGame();				
			}
			
			try{
				Thread.sleep(2000);
			} catch (InterruptedException e){}
			
			playing = false;
		}
	}
	
	public static boolean highscore(){
		
		if(points >= highscores[highscores.length - 1]){
			highscore = true;
		}
		
		else highscore = false;
		
		return highscore;
	}
		
	public static void writeScoresAndNames(char c1, char c2, char c3, int score){
	    try{
		    BufferedWriter writeScores = new BufferedWriter(new FileWriter(scoreFile));
			BufferedWriter writeNames = new BufferedWriter(new FileWriter(nameFile));
		    
		   	for(int i = 0; i < highscores.length; i++){
		    	if(highscores[i] <= score){
		    		for(int j = highscores.length-1; j > i; j--){
		    			if(j >= highscores.length)break;
			    		
			    		else{
			    			highscores[j] = highscores[j-1];
			    			names[j] = names[j-1];
			    		}
			    	}
			   	highscores[i] = score;
			   	names[i] = "" + c1 + c2 + c3;
			   	break;
			   	
			   	}
		    }
		    
		   	for(int i = 0; i < highscores.length; i++){						
				writeScores.write("" + highscores[i]);	
				writeScores.newLine();
				writeNames.write(names[i]);
				writeNames.newLine();
				writeScores.flush();
				writeNames.flush();
			}
			
		} catch(Exception e){
							       e.printStackTrace();
               				}
	}
	
	public static void drawScoreScreen(Graphics g, int x){
		
		int y = 30;
		
		g.setColor(Color.red);
		g.setFont(font);
		g.drawString("GAME OVER", x, y);
		
		y = 80;
		
		for(int i = 0; i < highscores.length; i++){
			y += 30;
			g.drawString(Integer.toString(highscores[i]), x, y);
			g.drawString(names[i], x + 100, y);
		}
	}
	
	public static int getPoints(){
		return points;
	}
	
	public static void setScore0AndLives3(){
		points = 0;
		lives = 3;
		
		d1 = 0;   //digit ones
		d10 = 0;  //digit 10s etc.
		d100 = 0;
		d1000 = 0;
		d10000 = 0;
		d100000 = 0;
		d1000000 = 0;
		d10000000 = 0;
		d100000000 = 0;
		d1000000000 = 0;	
	}
	
	public void paintScore(Graphics g){
		g.drawImage(numbers[d1000000000], x1, y, this);
		g.drawImage(numbers[d100000000], x2, y, this);
		g.drawImage(numbers[d10000000], x3, y, this);
		g.drawImage(numbers[d1000000], x4, y, this);
		g.drawImage(numbers[d100000], x5, y, this);
		g.drawImage(numbers[d10000], x6, y, this);
		g.drawImage(numbers[d1000], x7, y, this);
		g.drawImage(numbers[d100], x8, y, this);
		g.drawImage(numbers[d10], x9, y, this);
		g.drawImage(numbers[d1], x10, y, this);
		
		for(int i = 1; i <= lives; i++){  //i = 1 so that image is not drawn at 0
			g.drawImage(ship1, 0, y2, this);
			y2 += height +2;
		}
		
		y2 = 20;
	}		
}