/****************************
* This class is responsible *
* for keeping track of the  *
* level the player is on,   *
* intializing enemy ships   *
* for that level, and, if we*
* are starting a new level  *
* the player is told.       *
****************************/
import java.util.*;
import java.awt.*;
import java.math.*;

public class LevelHandler extends SpaceM{
	static boolean NewLevel;
	static MotherShip mothership;
	static eShip[] eShips;
	static int fighterN;
			
	private static Font font;
	private static FontMetrics fm;
	
	private static int xPos;
	private static int yPos;
 	static int levelN = 1;
	private static boolean gameComplete;
	static String wave = "Wave Number: ";
	
	Random random;
	
	public LevelHandler(){
		font = new Font("monospaced", Font.BOLD, 30);
		fm = getFontMetrics(font);
		random = new Random();
		eShips = new eShip[13];
		NewLevel = true;
	}
	
	public void initShips(){
		if(levelN == 1)fighterN = 5;
		else if(levelN == 2){
			fighterN = 6;
			eBullet.increaseBulletSpeed();
		}
		
		else if(levelN == 3){
			fighterN = 7;
		}
		
		else if(levelN == 4){
			fighterN = 8;
			eBullet.increaseBulletSpeed();
		}
		
		else if(levelN == 5){
			fighterN = 9;					
			MiscHandler.getLife();		
		}
		
		else if(levelN == 6){
			fighterN = 10;
			eBullet.increaseBulletSpeed();
		}
		
		else if(levelN == 7){
			fighterN = 11;
		}
		
		else if(levelN == 8){
			fighterN = 12;
			MiscHandler.getLife();
			eBullet.increaseBulletSpeed();
		}
		
		else if(levelN == 9){
			fighterN = 13;
			eBullet.increaseBulletSpeed();
		}
			
		else if(levelN == 10){
			fighterN = 0;
			mothership = new MotherShip((super.width - mothershipI.getWidth(null)) / 2, 0 - mothershipI.getHeight(null), mothershipI.getWidth(null), mothershipI.getHeight(null), random.nextInt(4)+1, ship2);
			MiscHandler.getLife();
			MiscHandler.getLife();
			eBullet.increaseBulletSpeed();
		}
		
		if(fighterN != 0){
			for(int i = 0; i < fighterN; i++){
				eShips[i] =	new eShip(random.nextInt(width), 0 - ship2.getHeight(null), ship2.getWidth(null), ship2.getHeight(null), random.nextInt(4)+1, ship2);
			}
		}	
	}
	
	public static void checkForNewLevel(){
		
		for(int i = 0; i < fighterN; i++){
	    	if (eShips[i] != null){
	        	NewLevel = false;	        	
	        	return;
	        	
	        }       	
	    }
	    
	    if(mothership != null){
	        	NewLevel = false;
	        	return;
	        }
	        
	    if(levelN >= 10){
	       	NewLevel = false;	       	
	       	return;
	    }
	    
	    if(!playing){
	    	NewLevel = false;
	       	return;
	    }
	    
	    if(shipHandler.exploded()){
	    	NewLevel = false;
	       	return;
	    }
	    
	    NewLevel = true;
	    ++levelN;	    
	}
	
	public void paintWaveNumber(Graphics g){
		if(!gameComplete){
			xPos = (width - fm.stringWidth(wave)) / 2;
			yPos = (height - fm.getHeight())/2;
			g.setColor(Color.green);
			g.setFont(font);
			g.drawString(wave + levelN, xPos, yPos);
		}
		
		else{
			xPos = (width - fm.stringWidth("GAME COMPLETED!!!")) / 2;
			yPos = (height - fm.getHeight())/2;
			g.setColor(Color.black);
			g.fillRect(0, 0, super.width, super.height);
			g.setColor(Color.red);
			g.setFont(font);
			g.drawString("GAME COMPLETED!!!", xPos, yPos);
			
			xPos = (width - fm.stringWidth("YOU HAVE SAVED YOUR HOME PLANET!!!")) / 2;
			yPos = (height - fm.getHeight())/2;
			g.setColor(Color.green);
			g.setFont(font);
			
			g.drawString("YOU HAVE SAVED YOUR HOME PLANET!!!", xPos, yPos + 40);
		}		
	}
	
	public static void gameCompleted(){
		gameComplete = true;
	}
	
	public static boolean gameComplete(){
		return gameComplete;
	}
	
	public static void newGame(){
		levelN = 1;
		NewLevel = true;
		MiscHandler.setScore0AndLives3();		
		SpaceM.right = false;
		SpaceM.left = false;
		gameComplete = false;
		mothership = null;
		shipHandler.setShipDefaults();
		
		for(int i = 0; i < eShips.length; i++){
			eShips[i] =	null;
		}
	}
}