/********************************
* This class detects collisions *
*********************************/

public class CollisionHandler extends SpaceM{
	
	public static void DetectCollision(){
		eShipCollisions();
		shipCollisions();
		bulletCollisions();		
	}		

	private static void eShipCollisions(){
		for(int i = 0; i < LevelHandler.fighterN; i++){
					
			if(LevelHandler.eShips[i] == null) continue;
		    
		    for(int j = 0; j < shipHandler.bullets.length; j++){
		    	if(shipHandler.bullets[j] == null)continue;
		    				
				if(LevelHandler.eShips[i].getRect().intersects(shipHandler.bullets[j].getRect())
				   && !LevelHandler.eShips[i].exploding() && !shipHandler.bullets[j].exploding()){
					LevelHandler.eShips[i].explode();
					shipHandler.bullets[j].explode();
					MiscHandler.awardShipDestroyedPoints();					
				}								
			}			
		}
		
		if(LevelHandler.mothership != null){
			for(int i = 0; i < shipHandler.bullets.length; i++){
		    	if(shipHandler.bullets[i] == null)continue;
		    				
				if(LevelHandler.mothership.getRect().intersects(shipHandler.bullets[i].getRect())
				   && !shipHandler.bullets[i].exploding() && !LevelHandler.mothership.exploding()){
				    
				    shipHandler.bullets[i].explode();
					
					if(LevelHandler.mothership.timeToExplode()){
						LevelHandler.mothership.explode();
						MiscHandler.awardMotherShipDestroyedPoints();
					}
				}								
			}
		}
	
		LevelHandler.checkForNewLevel();
	}
	
	private static void bulletCollisions(){
		for(int i = 0; i < LevelHandler.fighterN; i++){
					
			if(LevelHandler.eShips[i] == null) continue;
		    else if(LevelHandler.eShips[i].bullet == null)continue;
		    		    
		    for(int j = 0; j < shipHandler.bullets.length; j++){
		    	if(shipHandler.bullets[j] == null)continue;
		    	
		    	if(LevelHandler.eShips[i].bullet.getRect().intersects(shipHandler.bullets[j].getRect())
				   && !shipHandler.bullets[j].exploding() && !LevelHandler.eShips[i].bullet.exploding()){
				   	
					shipHandler.bullets[j].explode();
					LevelHandler.eShips[i].bullet.explode();
					MiscHandler.awardBulletDestroyedPoints();
				}								
			}				
		}
		
		if(LevelHandler.mothership != null){
			for(int i = 0; i < shipHandler.bullets.length; i++){
		    	if(shipHandler.bullets[i] == null)continue;
	    		
	    		for (int j = 0; j < LevelHandler.mothership.bullets.length; j++){		
					if(LevelHandler.mothership.bullets[j] == null)continue;
					
					if(LevelHandler.mothership.bullets[j].getRect().intersects(shipHandler.bullets[i].getRect())
				   	   && !shipHandler.bullets[i].exploding() && !LevelHandler.mothership.bullets[j].exploding()){
				    
				    	LevelHandler.mothership.bullets[j].explode();
					    shipHandler.bullets[i].explode();
					    MiscHandler.awardBulletDestroyedPoints();						
					}
				}
			}
		}	
	}
	
	private static void shipCollisions(){
		for(int i = 0; i < LevelHandler.fighterN; i++){
					
			if(LevelHandler.eShips[i] == null) continue;
		    else if(LevelHandler.eShips[i].bullet == null)continue;
		    		    
		    if(LevelHandler.eShips[i].bullet.getRect().intersects(shipHandler.getRect()) && 
		       !shipHandler.exploding() && !LevelHandler.eShips[i].bullet.exploding()){
		       			       	
		       	LevelHandler.eShips[i].bullet.explode();
				shipHandler.explode();			
			}
		}
		
		if(LevelHandler.mothership != null){
			for (int j = 0; j < LevelHandler.mothership.bullets.length; j++){		
				if(LevelHandler.mothership.bullets[j] == null)continue;
					
				if(LevelHandler.mothership.bullets[j].getRect().intersects(shipHandler.getRect())
				   && !shipHandler.exploding() && !LevelHandler.mothership.bullets[j].exploding()){
				    
					LevelHandler.mothership.bullets[j].explode();
					shipHandler.explode();							
				}
			}
		}			
	}
}