/*******************************
* This class is a template for *
* bullets and missiles.        *
*******************************/

import java.awt.*;
import java.util.*;

public class Bullet extends SpaceM{
	
	private int explodeFrame = 0;
	private boolean exploding = false;
	private boolean exploded = false;
	private long timeLastExplosion = 0;
	
	private String type;
	private String rocket = "rocket";
	private String normal = "normal";
	
	private static int xSpeed = 3;
	private int speed;
	private int x;
	private int y;
	private int width;
	private int height;
	Image bullet;
	Rectangle bulletR;
	
	private int[] eShipX;
	
	public Bullet(int X, int Y, int Width, int Height, int Speed, String Type, Image Bullet){
		x = X;
		y = Y;
		width = Width;
		height = Height;
		speed = Speed;
		type = Type;
		bullet = Bullet;
		
		bulletR = new Rectangle(x, y, width, height);
		
		eShipX = new int[13];
	}
	
	public int getX(){
		return x;
	}
	
	public int getY(){
		return y;
	}
	
	public int getHeight(){
		return height;
	}
	
	public Rectangle getRect(){
		return bulletR;
	}
	
	public Image getImage(){
		if(exploding){
			
			if((System.currentTimeMillis() - timeLastExplosion) > 10){
				timeLastExplosion = System.currentTimeMillis();
				++explodeFrame;
			}
			
			switch(explodeFrame){
				
				case 4:
					explodeFrame = 0;
					exploding = false;
					exploded = true;				
					return e1;
				
				default: 
					return e1;
			}
		}				
		return bullet;
	}
	
	public boolean aboveScreen(){
		if((y - height) < 0)return true;
		return false;
	}
		
	private void setRect(){
		bulletR.setBounds(x, y, width, height);
	}
	
	public void moveBullet(){
		
		if(type.equals(rocket) && LevelHandler.levelN < 8){
			
			for(int i = 0; i < LevelHandler.fighterN; i++){
				if(LevelHandler.eShips[i] == null)continue;
				
				eShipX[i] = LevelHandler.eShips[i].getShipCenterX();				
			}
			
			Arrays.sort(eShipX);		
			
			for(int i = 0; i < LevelHandler.fighterN; i++){
				
				if(i == 0){
					if(x < eShipX[i]){
						x += xSpeed;			
					}
				}
				
				else if(i < eShipX.length-1){  //added this
				
					if((x > eShipX[i]) && (x < eShipX[i + 1])){
						
						if((x - eShipX[i]) > (eShipX[i + 1] - x)){
							x += xSpeed;					
						}
							
						else{
							x -= xSpeed;						
						}					
					}
				}
					
				if(i == 0){
					if(x > eShipX[i]){  // changed < to >
						x -= xSpeed;					
					}
				}					
			}	
		}
		
		y -= speed;
		
	 	setRect();
	}
	
	public void explode(){
    	if(!exploding && !exploded){
	    	exploding = true;
	    	explosionS.setMicrosecondPosition(0);
			explosionS.start();	    
	    }
    }
    
    public boolean exploding(){
    	return exploding;
    }
    
    public boolean exploded(){
    	return exploded;
    }
}		