/***********************************
* This class paints the background *
************************************/
import java.util.*;
import java.awt.*;

public class BackgroundHandler extends SpaceM{
	
	static Random random = new Random();
	
	static boolean starsInited = false;
	static int[] x = new int[60];
	static int[] y = new int[60];
	static int speed = 1;
	
	public void	paintBackground(Graphics g){
		g.drawImage(background, 0, 0, width, height, this);		
		
		if(!starsInited){
			initStars();
			return;
		}
		
		moveStars();
		paintStars(g);		
	}
	
	private static void initStars(){
		for(int i = 0; i < x.length; i++){
			x[i] = random.nextInt(width);
			y[i] = random.nextInt(height);
		}
		
		starsInited = true;
	}
	
	private static void moveStars(){
		for(int i = 0; i <x.length; i++){
			y[i] += speed;
			if(y[i] > height) y[i] = 0;
		}		
	}
	
	private static void paintStars(Graphics g){
		g.setColor(Color.white);
		for(int i = 0; i < x.length; i++){
			g.fillRect(x[i], y[i], 2, 2);
		}
	}
}