/* Device packet support for PC version of AVRIL */

/* Written by Bernie Roehl, June 1994 */

/* Copyright 1994 by Bernie Roehl */

/* You may use this code for your own non-commercial projects without
   paying any fees or royalties.  "Non-commercial", in this context,
   means that the software you write is given away for free to anyone
   who wants it.
   
   Commercial use, including shareware, requires a licensing
   fee and a specific written agreement with the author.

   All programs created using this software (both commercial and
   non-commercial) must acknowledge the use of the AVRIL library,
   both in the documentation and in a banner screen at the start or
   end of the program.

   For more information, contact Bernie Roehl (broehl@uwaterloo.ca).

*/

#include "avril.h"

vrl_DevicePacketBuffer *vrl_DeviceCreatePacketBuffer(int buffsize)
	{
	vrl_DevicePacketBuffer *p;
	p = vrl_malloc(sizeof(vrl_DevicePacketBuffer));
	if (p == NULL) return NULL;
	p->buffer = vrl_malloc(buffsize);
	if (p->buffer == NULL)
		{
		vrl_free(p);
		return NULL;
		}
	p->ind = 0;  p->buffsize = buffsize;
	return p;
	}

void vrl_DeviceDestroyPacketBuffer(vrl_DevicePacketBuffer *buff)
	{
	if (buff->buffer)
		vrl_free(buff->buffer);
	vrl_free(buff);
	}

vrl_Boolean vrl_DeviceGetPacket(vrl_SerialPort *port, vrl_DevicePacketBuffer *buff)
	{
	while (vrl_SerialCheck(port))
		{
		int c = vrl_SerialGetc(port);
		if (c & 0x80)  /* framing bit set */
			buff->ind = 0;
		if (buff->ind < buff->buffsize)
			buff->buffer[buff->ind++] = c;
		if (buff->ind == buff->buffsize)
			{
			++buff->ind;  /* make sure we only return it once */
			return 1;     /* complete packet received */
			}
		}
	return 0;  /* no data waiting, packet not yet complete */
	}
