/* EXAMPLE2 -- several asteroids, sharing the same geometry */

/* Written by Bernie Roehl, April 1994 */

#include "avril.h"
#include <stdlib.h>  /* needed for rand() */

void main()
	{
	FILE *infile;
	vrl_Light *light;
	vrl_Camera *camera;
	vrl_Shape *asteroidshape = NULL;
	int i;

	vrl_SystemStartup();
	
	vrl_WorldSetHorizon(0);    /* turn off horizon */
	vrl_WorldSetSkyColor(0);   /* black sky */

	infile = fopen("asteroid.plg", "r");
	if (infile)
		{
		asteroidshape = vrl_ReadPLG(infile);
		fclose(infile);
		}

	light = vrl_LightCreate();
	vrl_LightRotY(light, float2angle(45));
	vrl_LightRotX(light, float2angle(45));
	vrl_LightSetIntensity(light, float2factor(0.9));

	camera = vrl_CameraCreate();
	vrl_CameraMove(camera, 0, 100, -50);

	for (i = 0; i < 5; ++i)
		{
		vrl_Object *obj = vrl_ObjectCreate(asteroidshape);
		vrl_ObjectMove(obj, rand() % 1000, rand() % 1000, rand() % 1000);
		}

	vrl_SystemRun();
	}

